/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.RefreshThread;
import scouter.client.util.ColorUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.TimeUtil;

public abstract class ActiveSpeedCommonView
extends ViewPart
implements RefreshThread.Refreshable {
    public final int BAR_WIDTH = 8;
    private static final int FETCH_INTERVAL = 2000;
    private static final int HEIGHT_MARGIN = 3;
    protected RefreshThread thread;
    private Canvas canvas;
    private Image ibuffer;
    Rectangle area;
    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    protected ActiveSpeedData activeSpeedData = new ActiveSpeedData();
    protected int update = 0;
    protected static final int UPDATE_FACTOR = 24;
    protected long last_update = 0L;
    private boolean onGoing;
    private long lastDrawTime;
    static Color black = ColorUtil.getInstance().getColor(2);
    static Color white = ColorUtil.getInstance().getColor(1);

    public void createPartControl(Composite parent) {
        this.setTitleImage(Images.TYPE_ACTSPEED);
        this.canvas = new Canvas(parent, 0x20000000);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                try {
                    ActiveSpeedCommonView.this.area = ActiveSpeedCommonView.this.canvas.getClientArea();
                    ActiveSpeedCommonView.this.drawCanvasImage(e.gc);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    private void drawCanvasImage(GC gc) {
        if (this.ibuffer != null && !this.ibuffer.isDisposed()) {
            gc.drawImage(this.ibuffer, 0, 0);
        }
    }

    @Override
    public void refresh() {
        ++this.update;
        if (this.update == 24) {
            this.update = 0;
        }
        this.draw();
        ExUtil.syncExec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                ActiveSpeedCommonView.this.canvas.redraw();
            }
        });
        final long now = TimeUtil.getCurrentTime();
        if (now >= this.last_update + 2000L) {
            ExUtil.asyncRun(new Runnable(){

                @Override
                public void run() {
                    ActiveSpeedCommonView.this.last_update = now;
                    ActiveSpeedCommonView.this.fetch();
                }
            });
        }
    }

    public abstract void fetch();

    protected void draw() {
        long now = TimeUtil.getCurrentTime();
        if (now - this.lastDrawTime < 100L || this.area == null) {
            return;
        }
        if (this.onGoing) {
            return;
        }
        this.onGoing = true;
        ActiveSpeedData data = this.activeSpeedData;
        int work_w = this.area.width < 400 ? 400 : this.area.width;
        int work_h = this.area.height < 20 ? 20 : this.area.height;
        Image img = new Image(null, work_w, work_h);
        GC gc = new GC((Drawable)img);
        try {
            try {
                this.lastDrawTime = now;
                int barWidth = 6;
                int barHehgit = work_h - 6;
                int idx = 0;
                int i = 0;
                while (i < data.act3) {
                    this.drawNemo(gc, ColorUtil.getInstance().ac3, idx * 8 + 1, 3, barWidth, barHehgit);
                    ++i;
                    ++idx;
                }
                i = 0;
                while (i < data.act2) {
                    this.drawNemo(gc, ColorUtil.getInstance().ac2, idx * 8 + 1, 3, barWidth, barHehgit);
                    ++i;
                    ++idx;
                }
                i = 0;
                while (i < data.act1) {
                    this.drawNemo(gc, ColorUtil.getInstance().ac1, idx * 8 + 1, 3, barWidth, barHehgit);
                    ++i;
                    ++idx;
                }
                int mod = 0;
                if (data.tps > 5000.0f) {
                    mod = 24;
                } else if (data.tps > 1000.0f) {
                    mod = 12;
                } else if (data.tps > 200.0f) {
                    mod = 8;
                } else if (data.tps > 80.0f) {
                    mod = 6;
                } else if (data.tps > 40.0f) {
                    mod = 4;
                } else if (data.tps >= 20.0f) {
                    mod = 3;
                } else if (data.tps >= 10.0f) {
                    mod = 2;
                } else if (data.tps > 0.0f) {
                    mod = 1;
                }
                int i2 = idx;
                while (i2 < work_w / 8) {
                    if (mod > 0 && i2 % (24 / mod) == this.update % (24 / mod)) {
                        this.drawNemo(gc, ColorUtil.getInstance().acm, i2 * 8 + 1, 3, barWidth, barHehgit);
                    } else {
                        this.drawNemo(gc, white, i2 * 8 + 1, 3, barWidth, barHehgit);
                    }
                    ++i2;
                }
                if (work_h >= 35) {
                    Font font = new Font(null, "Verdana", 14, 2);
                    gc.setFont(font);
                    gc.drawText(Integer.toString(idx), 5, work_h / 2 - 8, true);
                    font.dispose();
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
                gc.dispose();
                Image old = this.ibuffer;
                this.ibuffer = img;
                if (old != null) {
                    old.dispose();
                }
                this.onGoing = false;
            }
        }
        finally {
            gc.dispose();
            Image old = this.ibuffer;
            this.ibuffer = img;
            if (old != null) {
                old.dispose();
            }
            this.onGoing = false;
        }
    }

    private void drawNemo(GC gc, Color background, int x, int y, int width, int height) {
        gc.setBackground(background);
        gc.fillRectangle(x, y, width, height);
        gc.setForeground(black);
        gc.drawRectangle(x, y, width, height);
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    public static class ActiveSpeedData {
        public int act1;
        public int act2;
        public int act3;
        public float tps;
    }
}

