/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.views.ActiveSpeedCommonView;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.util.CastUtil;
import scouter.util.StringUtil;

public class ActiveSpeedView
extends ActiveSpeedCommonView {
    public static final String ID = ActiveSpeedView.class.getName();
    private String objType;
    private int serverId;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = StringUtil.split((String)secId, (String)"&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objType = ids[1];
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Server server = ServerManager.getInstance().getServer(this.serverId);
        String objTypeDisplay = "";
        if (server != null) {
            objTypeDisplay = server.getCounterEngine().getDisplayNameObjectType(this.objType);
        }
        this.setPartName("ActiveSpeed - " + objTypeDisplay);
        this.thread = new RefreshThread(this, 150);
        this.thread.start();
        this.thread.setName(String.valueOf(this.toString()) + " - " + "objType:" + this.objType + ", serverId:" + this.serverId);
    }

    @Override
    public void fetch() {
        TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
        try {
            ActiveSpeedCommonView.ActiveSpeedData a;
            MapPack param = new MapPack();
            param.put("objType", this.objType);
            MapPack p = (MapPack)tcp.getSingle("ACTIVESPEED_REAL_TIME_GROUP", (Pack)param);
            this.activeSpeedData = a = new ActiveSpeedCommonView.ActiveSpeedData();
            if (p == null) {
                return;
            }
            try {
                a.act1 = CastUtil.cint((Object)p.get("act1"));
                a.act2 = CastUtil.cint((Object)p.get("act2"));
                a.act3 = CastUtil.cint((Object)p.get("act3"));
                a.tps = CastUtil.cfloat((Object)p.get("tps"));
            }
            catch (Exception e) {
                ConsoleProxy.errorSafe(e.toString());
            }
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
    }
}

