/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.popup.AlertNotifierDialog;
import scouter.client.popup.CalendarDialog;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.AlertLevel;
import scouter.lang.pack.AlertPack;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.MapValue;
import scouter.util.DateUtil;
import scouter.util.HashUtil;
import scouter.util.StringEnumer;
import scouter.util.StringUtil;

public class AlertDetailListView
extends ViewPart
implements CalendarDialog.ILoadCalendarDialog {
    public static final String ID = AlertDetailListView.class.getName();
    private int serverId;
    private Text dateText;
    private DateTime fromTime;
    private DateTime toTime;
    private Text maxCountText;
    private Combo levelCombo;
    private Text objText;
    private Text keyText;
    private TableViewer viewer;
    private String yyyymmdd;
    private TableColumnLayout tableColumnLayout;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        this.serverId = Integer.valueOf(secId);
        this.yyyymmdd = DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(this.serverId));
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Group parentGroup = new Group(parent, 0);
        parentGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(10, false);
        parentGroup.setLayout((Layout)layout);
        Label label = new Label((Composite)parentGroup, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText("Date");
        this.dateText = new Text((Composite)parentGroup, 2056);
        this.dateText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dateText.setBackground(ColorUtil.getInstance().getColor("white"));
        this.dateText.setText(DateUtil.format((long)TimeUtil.getCurrentTime(this.serverId), (String)"yyyy-MM-dd"));
        Button button = new Button((Composite)parentGroup, 8);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        button.setImage(Images.calendar);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        Display display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        CalendarDialog dialog = new CalendarDialog(display, AlertDetailListView.this);
                        dialog.show(AlertDetailListView.this.dateText.getLocation().x, AlertDetailListView.this.dateText.getLocation().y, DateUtil.yyyymmdd((String)AlertDetailListView.this.yyyymmdd));
                    }
                }
            }
        });
        long now = TimeUtil.getCurrentTime(this.serverId);
        label = new Label((Composite)parentGroup, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText("From");
        this.fromTime = new DateTime((Composite)parentGroup, 32896);
        this.fromTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fromTime.setHours(DateUtil.getHour((long)now) - 1);
        this.fromTime.setMinutes(DateUtil.getMin((long)now));
        label = new Label((Composite)parentGroup, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText("To");
        this.toTime = new DateTime((Composite)parentGroup, 32896);
        this.toTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.toTime.setHours(DateUtil.getHour((long)now));
        this.toTime.setMinutes(DateUtil.getMin((long)now));
        label = new Label((Composite)parentGroup, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText("Count(Max:1000)");
        this.maxCountText = new Text((Composite)parentGroup, 2048);
        this.maxCountText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.maxCountText.setText("500");
        this.maxCountText.setToolTipText("1~1000");
        this.maxCountText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                String count = AlertDetailListView.this.maxCountText.getText();
                if (StringUtil.isEmpty((String)count)) {
                    return;
                }
                try {
                    Integer.valueOf(count);
                }
                catch (Exception ex) {
                    MessageDialog.openError((Shell)AlertDetailListView.this.maxCountText.getShell(), (String)"Invalid Count", (String)"Count is allowed only digits");
                    AlertDetailListView.this.maxCountText.setText("");
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        button = new Button((Composite)parentGroup, 8);
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.setText("&Search");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AlertDetailListView.this.load();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label((Composite)parentGroup, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText("Level");
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        this.levelCombo = new Combo((Composite)parentGroup, 8);
        this.levelCombo.setLayoutData((Object)gridData);
        this.levelCombo.add("ALL");
        StringEnumer itr = AlertLevel.names();
        while (itr.hasMoreElements()) {
            this.levelCombo.add(itr.nextString());
        }
        this.levelCombo.select(0);
        label = new Label((Composite)parentGroup, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText("Object");
        this.objText = new Text((Composite)parentGroup, 2048);
        this.objText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label((Composite)parentGroup, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText("Key");
        this.keyText = new Text((Composite)parentGroup, 2048);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.keyText.setLayoutData((Object)gridData);
        button = new Button((Composite)parentGroup, 8);
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.setText("&Clear");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AlertDetailListView.this.levelCombo.select(0);
                AlertDetailListView.this.objText.setText("");
                AlertDetailListView.this.keyText.setText("");
                AlertDetailListView.this.viewer.getTable().removeAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)this.tableColumnLayout);
        this.viewer = new TableViewer(tableComposite, 67586);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.viewer));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof AlertData) {
                    AlertData data = (AlertData)o;
                    Display display = Display.getCurrent();
                    if (display == null) {
                        display = Display.getDefault();
                    }
                    AlertNotifierDialog alertDialog = new AlertNotifierDialog(display, AlertDetailListView.this.serverId);
                    alertDialog.setObjName(data.object);
                    alertDialog.setPack(data.toPack());
                    alertDialog.show(AlertDetailListView.this.getViewSite().getShell().getBounds());
                } else {
                    System.out.println(o);
                }
            }
        });
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Export CSV", ImageUtil.getImageDescriptor(Images.csv)){

            public void run() {
                Server server = ServerManager.getInstance().getServer(AlertDetailListView.this.serverId);
                FileDialog dialog = new FileDialog(AlertDetailListView.this.getViewSite().getShell(), 8192);
                dialog.setOverwrite(true);
                String filename = "[" + server.getName() + "]" + AlertDetailListView.this.yyyymmdd + "_" + AlertDetailListView.this.fromTime.getHours() + AlertDetailListView.this.fromTime.getMinutes() + "_" + AlertDetailListView.this.toTime.getHours() + AlertDetailListView.this.toTime.getMinutes() + ".csv";
                dialog.setFileName(filename);
                dialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
                dialog.setFilterNames(new String[]{"CSV File(*.csv)", "All Files"});
                String fileSelected = dialog.open();
                if (fileSelected != null) {
                    CSVWriter cw = null;
                    try {
                        try {
                            cw = new CSVWriter((Writer)new FileWriter(fileSelected));
                            int colCnt = AlertDetailListView.this.viewer.getTable().getColumnCount();
                            ArrayList<String> list = new ArrayList<String>();
                            int i = 0;
                            while (i < colCnt) {
                                TableColumn column = AlertDetailListView.this.viewer.getTable().getColumn(i);
                                list.add(column.getText());
                                ++i;
                            }
                            cw.writeNext(list.toArray(new String[list.size()]));
                            cw.flush();
                            TableItem[] items = AlertDetailListView.this.viewer.getTable().getItems();
                            if (items != null && items.length > 0) {
                                TableItem[] tableItemArray = items;
                                int n = items.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TableItem item = tableItemArray[n2];
                                    list.clear();
                                    int i2 = 0;
                                    while (i2 < colCnt) {
                                        list.add(item.getText(i2));
                                        ++i2;
                                    }
                                    cw.writeNext(list.toArray(new String[list.size()]));
                                    cw.flush();
                                    ++n2;
                                }
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            try {
                                if (cw != null) {
                                    cw.close();
                                }
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    finally {
                        try {
                            if (cw != null) {
                                cw.close();
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        });
    }

    private void createColumns() {
        AlertColumnEnum[] alertColumnEnumArray = AlertColumnEnum.values();
        int n = alertColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlertColumnEnum column = alertColumnEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWeight(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case TIME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof AlertData) {
                                return DateUtil.format((long)((AlertData)element).time, (String)"yyyy-MM-dd HH:mm:ss");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case LEVEL: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof AlertData) {
                                return ((AlertData)element).level;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case OBJECT: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof AlertData) {
                                return ((AlertData)element).object;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case TITLE: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof AlertData) {
                                return ((AlertData)element).title;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case MESSAGE: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof AlertData) {
                                return ((AlertData)element).message;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case TAGS: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof AlertData) {
                                return ((AlertData)element).tags.toString();
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int weight, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight, 10, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)AlertDetailListView.this.viewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    public void setFocus() {
    }

    public void setInput(long stime, long etime) {
        this.onPressedOk(DateUtil.yyyymmdd((long)stime));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(stime));
        int hours = calendar.get(11);
        int minutes = calendar.get(12);
        int seconds = calendar.get(13);
        this.fromTime.setTime(hours, minutes, seconds);
        calendar = Calendar.getInstance();
        calendar.setTime(new Date(etime));
        hours = calendar.get(11);
        minutes = calendar.get(12);
        seconds = calendar.get(13);
        this.toTime.setTime(hours, minutes, seconds);
    }

    private void load() {
        int fromHour = this.fromTime.getHours();
        int fromMin = this.fromTime.getMinutes();
        int toHour = this.toTime.getHours();
        int toMin = this.toTime.getMinutes();
        final long stime = DateUtil.getTime((String)(String.valueOf(this.yyyymmdd) + (fromHour < 10 ? "0" + fromHour : Integer.valueOf(fromHour)) + (fromMin < 10 ? "0" + fromMin : Integer.valueOf(fromMin))), (String)"yyyyMMddHHmm");
        final long etime = DateUtil.getTime((String)(String.valueOf(this.yyyymmdd) + (toHour < 10 ? "0" + toHour : Integer.valueOf(toHour)) + (toMin < 10 ? "0" + toMin : Integer.valueOf(toMin))), (String)"yyyyMMddHHmm");
        final String count = this.maxCountText.getText();
        final String level = this.levelCombo.getText();
        final String object = this.objText.getText();
        final String key = this.keyText.getText();
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                ArrayList<AlertData> dataList;
                block10: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(AlertDetailListView.this.serverId);
                    dataList = new ArrayList<AlertData>();
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("date", AlertDetailListView.this.yyyymmdd);
                            param.put("stime", stime);
                            param.put("etime", etime);
                            if (StringUtil.isNotEmpty((String)count)) {
                                param.put("count", Long.valueOf(count).longValue());
                            }
                            if (StringUtil.isNotEmpty((String)level) && !"ALL".equalsIgnoreCase(level)) {
                                param.put("level", level);
                            }
                            if (StringUtil.isNotEmpty((String)object)) {
                                param.put("object", object);
                            }
                            if (StringUtil.isNotEmpty((String)key)) {
                                param.put("key", key);
                            }
                            List<Pack> packList = tcp.process("ALERT_LOAD_TIME", (Pack)param);
                            for (Pack pack : packList) {
                                if (!(pack instanceof AlertPack)) continue;
                                AlertPack alertPack = (AlertPack)pack;
                                AlertData data = new AlertData();
                                data.time = alertPack.time;
                                data.level = AlertLevel.getName((byte)alertPack.level);
                                data.object = TextProxy.object.getLoadText(AlertDetailListView.this.yyyymmdd, alertPack.objHash, AlertDetailListView.this.serverId);
                                data.title = alertPack.title;
                                data.message = alertPack.message;
                                data.objType = alertPack.objType;
                                data.tags = alertPack.tags;
                                dataList.add(data);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ConsoleProxy.errorSafe(e.getMessage());
                            TcpProxy.putTcpProxy(tcp);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                ExUtil.exec((Composite)AlertDetailListView.this.viewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        (this).AlertDetailListView.this.viewer.setInput((Object)dataList);
                    }
                });
            }
        });
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
    }

    @Override
    public void onPressedOk(String date) {
        this.yyyymmdd = date;
        this.dateText.setText(String.valueOf(date.substring(0, 4)) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8));
    }

    @Override
    public void onPressedCancel() {
    }

    static enum AlertColumnEnum {
        TIME("TIME", 6, 131072, true, true, false),
        LEVEL("LEVEL", 3, 0x1000000, true, true, false),
        OBJECT("OBJECT", 9, 16384, true, true, false),
        TITLE("TITLE", 10, 16384, true, true, false),
        MESSAGE("MESSAGE", 25, 16384, true, true, false),
        TAGS("TAGs", 7, 16384, true, true, false);

        private final String title;
        private final int weight;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private AlertColumnEnum(String text, int weight, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.weight = weight;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWeight() {
            return this.weight;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }

    static class AlertData {
        public long time;
        public String level;
        public String object;
        public String title;
        public String message;
        public MapValue tags;
        public String objType;

        AlertData() {
        }

        public AlertPack toPack() {
            AlertPack pack = new AlertPack();
            pack.level = AlertLevel.getValue((String)this.level);
            pack.message = this.message;
            pack.objHash = this.object == null ? 0 : HashUtil.hash((String)this.object);
            pack.objType = this.objType;
            pack.tags = this.tags;
            pack.time = this.time;
            pack.title = this.title;
            return pack;
        }

        public String toString() {
            return "AlertData [time=" + this.time + ", level=" + this.level + ", object=" + this.object + ", title=" + this.title + ", message=" + this.message + ", tags=" + this.tags + ", objType=" + this.objType + "]";
        }
    }
}

