/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.popup.AlertNotifierDialog;
import scouter.client.threads.AlertProxyThread;
import scouter.client.util.ChartUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.lang.AlertLevel;
import scouter.lang.pack.AlertPack;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;

public class AlertView
extends ViewPart
implements AlertProxyThread.IAlertListener {
    public static final String ID = AlertView.class.getName();
    AlertProxyThread proxyThread = AlertProxyThread.getInstance();
    private Table table = null;
    AlertNotifierDialog alertDialog;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)ChartUtil.gridlayout(1));
        this.table = this.build(parent);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] item = AlertView.this.table.getSelection();
                if (item == null || item.length == 0) {
                    return;
                }
                Object o = item[0].getData();
                if (o == null || !(o instanceof AlertData)) {
                    return;
                }
                AlertData d = (AlertData)o;
                String objName = TextProxy.object.getLoadText(DateUtil.yyyymmdd((long)d.p.time), d.p.objHash, d.serverId);
                AlertView.this.alertDialog = new AlertNotifierDialog(AlertView.this.getViewSite().getShell().getDisplay(), d.serverId);
                AlertView.this.alertDialog.setObjName(objName);
                AlertView.this.alertDialog.setPack(d.p);
                AlertView.this.alertDialog.show(AlertView.this.getViewSite().getShell().getBounds());
            }
        });
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("clear", ImageUtil.getImageDescriptor(Images.minus)){

            public void run() {
                AlertView.this.reload();
            }
        });
        this.proxyThread.addAlertListener(this);
    }

    private void reload() {
        this.proxyThread.reset();
        this.table.removeAll();
    }

    private Table build(Composite parent) {
        TableColumn[] cols;
        Table table = new Table(parent, 68416);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        cols = new TableColumn[]{UIUtil.create(table, 16384, "TIME", cols.length, 0, false, 100), UIUtil.create(table, 0x1000000, "LEVEL", cols.length, 1, false, 50), UIUtil.create(table, 16384, "TITLE", cols.length, 2, false, 200), UIUtil.create(table, 16384, "MESSAGE", cols.length, 3, false, 200), UIUtil.create(table, 16384, "OBJECT", cols.length, 5, false, 80)};
        return table;
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        this.proxyThread.removeAlertListener(this);
    }

    @Override
    public void ariseAlert(final int serverId, final AlertPack alert) {
        ExUtil.exec((Composite)this.table, new Runnable(){

            @Override
            public void run() {
                while (AlertView.this.table.getItemCount() > 500) {
                    AlertView.this.table.remove(AlertView.this.table.getItemCount() - 1);
                }
                AlertData data = new AlertData(serverId, alert);
                TableItem t = new TableItem(AlertView.this.table, 0, 0);
                t.setText(new String[]{FormatUtil.print((Object)new Date(alert.time), (String)"HH:mm:ss.SSS"), AlertLevel.getName((byte)alert.level), alert.title, alert.message, TextProxy.object.getLoadText(DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime()), data.p.objHash, serverId)});
                t.setData((Object)data);
            }
        });
    }

    static class AlertData {
        public int serverId;
        public AlertPack p;

        public AlertData(int serverId, AlertPack p) {
            this.serverId = serverId;
            this.p = p;
        }
    }
}

