/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.net.TcpProxy;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.UIUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.util.CastUtil;
import scouter.util.StringUtil;

public class ApiDebugView
extends ViewPart {
    public static final String ID = ApiDebugView.class.getName();
    private Text params;
    private Text command;
    private Text results;
    private int serverId;
    String COMMAND = "";

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)UIUtil.formLayout(5, 5));
        Button callBtn = new Button(parent, 0);
        callBtn.setText("Call");
        callBtn.setLayoutData((Object)UIUtil.formData(null, 0, 0, 5, 100, -5, null, -1));
        callBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ApiDebugView.this.makeParamAndCall();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.params = new Text(parent, 2048);
        this.params.setLayoutData((Object)UIUtil.formData(0, 200, 0, 7, callBtn, -5, null, -1));
        this.command = new Text(parent, 2048);
        this.command.setLayoutData((Object)UIUtil.formData(0, 5, 0, 7, this.params, -5, null, -1));
        this.results = new Text(parent, 2626);
        this.results.setLayoutData((Object)UIUtil.formData(0, 5, this.command, 5, 100, -5, 100, -5));
    }

    protected void makeParamAndCall() {
        String input = this.params.getText();
        MapPack param = null;
        try {
            if (StringUtil.isNotEmpty((String)input)) {
                param = new MapPack();
                String[] inputs = input.split(",");
                int i = 0;
                while (i < inputs.length) {
                    if (inputs[i].indexOf("=") != -1 && inputs[i].indexOf(":") != -1) {
                        String[] keyValue = inputs[i].split("=");
                        String type = StringUtil.removeWhitespace((String)keyValue[0].split(":")[0]);
                        String key = StringUtil.removeWhitespace((String)keyValue[0].split(":")[1]);
                        String value = StringUtil.removeWhitespace((String)keyValue[1]);
                        if (type.equals("I")) {
                            param.put(key, CastUtil.clong((Object)value));
                        } else if (type.equals("S")) {
                            param.put(key, value);
                        }
                    }
                    ++i;
                }
            }
            this.load(param);
        }
        catch (Exception e) {
            ConsoleProxy.errorSafe(e.toString());
        }
    }

    public void setInput(int serverId, int objHash) {
        this.serverId = serverId;
        if (objHash != 0) {
            this.params.setText("I:objHash=" + objHash + ", ");
            this.command.setText("DEBUG_AGENT");
        } else {
            this.command.setText("DEBUG_SERVER");
        }
    }

    public void load(final MapPack param) {
        ExUtil.exec(new Runnable(){

            @Override
            public void run() {
                List<Pack> packList = null;
                TcpProxy tcp = TcpProxy.getTcpProxy(ApiDebugView.this.serverId);
                try {
                    packList = tcp.process(ApiDebugView.this.command.getText(), (Pack)param);
                }
                finally {
                    TcpProxy.putTcpProxy(tcp);
                }
                StringBuilder sb = new StringBuilder();
                if (packList != null && packList.size() > 0) {
                    for (Pack pack : packList) {
                        sb.append(pack.toString());
                        sb.append("\n");
                    }
                }
                ApiDebugView.this.results.setText(sb.toString());
            }
        });
    }

    public void setFocus() {
    }
}

