/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColoringWord;
import scouter.client.util.CustomLineStyleListener;
import scouter.client.util.ImageUtil;
import scouter.client.util.TableControlAdapter;
import scouter.client.util.UIUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.DoubleValue;
import scouter.lang.value.FloatValue;
import scouter.lang.value.TextValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.FormatUtil;
import scouter.util.SortUtil;

public class ClientThreadDetailView
extends ViewPart {
    public static final String ID = ClientThreadDetailView.class.getName();
    private ArrayList<ColoringWord> defaultHighlightings;
    CustomLineStyleListener listener;
    private String title = "";
    private long threadid;
    protected Table table;
    protected StyledText stacktrace;
    TableColumn[] cols;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.initializeColoring();
    }

    public void initializeColoring() {
        this.defaultHighlightings = new ArrayList();
        this.defaultHighlightings.add(new ColoringWord("javax.servlet.http.HttpServlet", 9, false));
        this.defaultHighlightings.add(new ColoringWord("org.apache.jasper.servlet.JspServlet", 9, false));
        this.defaultHighlightings.add(new ColoringWord("java.lang.Thread.sleep", 3, false));
    }

    public void createPartControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)ChartUtil.gridlayout(1));
        comp.setLayoutData((Object)new GridData(1808));
        this.table = this.build(comp);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    ClientThreadDetailView.this.reload();
                }
            }
        });
        this.stacktrace = new StyledText(comp, 770);
        this.stacktrace.setLayoutData((Object)new GridData(1808));
        this.stacktrace.setText("");
        this.stacktrace.setFont(new Font(null, "verdana", 10, 0));
        this.stacktrace.setMargins(10, 10, 10, 10);
        this.listener = new CustomLineStyleListener(false, this.defaultHighlightings, false);
        this.stacktrace.addLineStyleListener((LineStyleListener)this.listener);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ClientThreadDetailView.this.reload();
            }
        });
        comp.addControlListener((ControlListener)new TableControlAdapter(this.table, this.cols, new int[]{3, -1}));
    }

    public void setInput(String title, long threadid) {
        this.title = title;
        this.threadid = threadid;
        this.reload();
    }

    private Table build(Composite parent) {
        this.table = new Table(parent, 68416);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.cols = new TableColumn[9];
        this.cols[0] = UIUtil.create(this.table, 16384, "Key", this.cols.length, 0, true, 150);
        this.cols[1] = UIUtil.create(this.table, 0, "Value", this.cols.length, 1, true, 600);
        return this.table;
    }

    protected void reload() {
        this.table.removeAll();
        MapPack mp = ClientThreadDetailView.getThreadDetail(this.threadid);
        String[] names = SortUtil.sort_string((Iterator)mp.keys(), (int)mp.size());
        int i = 0;
        int j = 0;
        while (i < names.length) {
            String key = names[i];
            Value value = mp.get(key);
            if ("Stack Trace".equals(key)) {
                this.stacktrace.setText(CastUtil.cString((Object)value));
            } else {
                String text = null;
                TableItem ti = new TableItem(this.table, 0, j++);
                if (value instanceof TextValue) {
                    text = CastUtil.cString((Object)value);
                    ti.setText(0, key);
                    ti.setText(1, text);
                } else {
                    if (value instanceof DecimalValue) {
                        text = FormatUtil.print((Object)value, (String)"#,##0");
                    } else if (value instanceof DoubleValue || value instanceof FloatValue) {
                        text = FormatUtil.print((Object)value, (String)"#,##0.0##");
                    }
                    ti.setText(new String[]{key, text});
                }
            }
            ++i;
        }
    }

    public static MapPack getThreadDetail(long threadid) {
        MapPack m = new MapPack();
        if (threadid == 0L) {
            return m;
        }
        ThreadMXBean tmb = ManagementFactory.getThreadMXBean();
        ThreadInfo f = tmb.getThreadInfo(threadid, 500);
        if (f == null) {
            return m;
        }
        m.put("Thread Id", (Value)new DecimalValue(f.getThreadId()));
        m.put("Thread Cpu Time", (Value)new DecimalValue(tmb.getThreadCpuTime(threadid) / 1000000L));
        m.put("Thread User Time", (Value)new DecimalValue(tmb.getThreadUserTime(threadid) / 1000000L));
        m.put("Blocked Count", (Value)new DecimalValue(f.getBlockedCount()));
        m.put("Blocked Time", (Value)new DecimalValue(f.getBlockedTime()));
        m.put("Waited Count", (Value)new DecimalValue(f.getWaitedCount()));
        m.put("Waited Time", (Value)new DecimalValue(f.getWaitedTime()));
        m.put("Lock Owner Id", (Value)new DecimalValue(f.getLockOwnerId()));
        m.put("Lock Name", (Value)new TextValue(f.getLockName()));
        m.put("Lock Owner Name", (Value)new TextValue(f.getLockOwnerName()));
        m.put("Thread Name", (Value)new TextValue(f.getThreadName()));
        m.put("Stack Trace", (Value)new TextValue(ClientThreadDetailView.getStackTrace(f.getStackTrace()).toString()));
        m.put("State", (Value)new TextValue(f.getThreadState().toString()));
        return m;
    }

    public static String getStackTrace(StackTraceElement[] se) {
        String CRLF = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        if (se != null) {
            int i = 0;
            while (i < se.length) {
                if (se[i] != null) {
                    sb.append(String.valueOf(se[i].toString()) + CRLF);
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }
}

