/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.model.AgentModelThread;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.views.CounterStackCommonView;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.NumberValue;
import scouter.lang.value.Value;

public class CounterMapStackTotalView
extends CounterStackCommonView {
    public static final String ID = CounterMapStackTotalView.class.getName();
    int serverId;
    String objType;
    String counter;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = Integer.valueOf(ids[0]);
        this.objType = ids[1];
        this.counter = ids[2];
    }

    @Override
    public void createPartControl(Composite parent) {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        String displayObjType = server.getCounterEngine().getDisplayNameObjectType(this.objType);
        String displaycounter = server.getCounterEngine().getCounterDisplayName(this.objType, this.counter);
        if (displaycounter == null) {
            displaycounter = this.counter;
        }
        this.setPartName(String.valueOf(displayObjType) + " - " + displaycounter + "[" + server.getName() + "]");
        super.createPartControl(parent);
    }

    @Override
    protected MapValue fetch() {
        ArrayList<MapValue> list;
        block6: {
            list = new ArrayList<MapValue>();
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    ListValue objHashLv = param.newList("objHash");
                    Set<Integer> objSet = AgentModelThread.getInstance().getObjectList(this.objType);
                    for (int hash : objSet) {
                        objHashLv.add((long)hash);
                    }
                    param.put("counter", this.counter);
                    tcp.process("COUNTER_MAP_REAL_TIME", param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            Value v = in.readValue();
                            if (v != null) {
                                list.add((MapValue)v);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        return this.combineMapValue(list);
    }

    private MapValue combineMapValue(List<MapValue> list) {
        MapValue mv = new MapValue();
        for (MapValue m : list) {
            Enumeration keys = m.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Value value = m.get(key);
                if (!(value instanceof NumberValue)) continue;
                Value v = mv.get(key);
                if (v == null) {
                    mv.put(key, value);
                    continue;
                }
                NumberValue nv = (NumberValue)v;
                nv.add((NumberValue)value);
            }
        }
        return mv;
    }
}

