/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.net.TcpProxy;
import scouter.client.server.ServerManager;
import scouter.client.views.CounterStackCommonView;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;

public class CounterMapStackView
extends CounterStackCommonView {
    public static final String ID = CounterMapStackView.class.getName();
    int serverId;
    int objHash;
    String objType;
    String title;
    List<String> counters = new ArrayList<String>();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = Integer.valueOf(ids[0]);
        this.objHash = Integer.valueOf(ids[1]);
        this.title = ids[2];
        int i = 3;
        while (i < ids.length) {
            this.counters.add(ids[i]);
            ++i;
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        AgentObject agent = AgentModelThread.getInstance().getAgentObject(this.objHash);
        if (agent == null) {
            this.objType = "tomcat";
            this.setPartName(String.valueOf(this.title) + "[" + this.objHash + "]");
        } else {
            this.objType = agent.getObjType();
            this.setPartName(String.valueOf(this.title) + "[" + agent.getObjName() + "]");
        }
        super.createPartControl(parent);
    }

    @Override
    protected MapValue fetch() {
        Pack p;
        block8: {
            p = null;
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objHash", (long)this.objHash);
                    ListValue counterLv = param.newList("counter");
                    for (String counter : this.counters) {
                        counterLv.add(counter);
                    }
                    p = tcp.getSingle("COUNTER_REAL_TIME_MULTI", (Pack)param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (p == null) {
            return null;
        }
        CounterEngine engine = ServerManager.getInstance().getServer(this.serverId).getCounterEngine();
        MapPack pack = (MapPack)p;
        ListValue counterLv = pack.getList("counter");
        ListValue valueLv = pack.getList("value");
        MapValue mapValue = new MapValue();
        int i = 0;
        while (i < counterLv.size()) {
            String counter = engine.getCounterDisplayName(this.objType, counterLv.getString(i));
            mapValue.put(counter, valueLv.get(i));
            ++i;
        }
        return mapValue;
    }
}

