/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.CounterColorManager;
import scouter.client.model.RefreshThread;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.client.views.AbstractServiceGroupTPSView;
import scouter.lang.value.MapValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.LinkedMap;

public abstract class CounterStackCommonView
extends ViewPart
implements RefreshThread.Refreshable {
    private static final int BUFFER_SIZE = 200;
    protected RefreshThread thread;
    protected XYGraph xyGraph;
    protected FigureCanvas canvas;
    protected Map<String, Trace> traces = new HashMap<String, Trace>();
    private LinkedMap<String, AbstractServiceGroupTPSView.StackValue> stackValueMap = new LinkedMap();

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)UIUtil.formLayout(0, 0));
        this.canvas = new FigureCanvas(parent);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setLayoutData((Object)UIUtil.formData(0, 0, 0, 0, 100, 0, 100, 0));
        this.canvas.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = CounterStackCommonView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    CounterStackCommonView.this.xyGraph.setSize(r.width, r.height);
                    this.lock = false;
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        final DefaultToolTip toolTip = new DefaultToolTip((Control)this.canvas, 1, true);
        toolTip.setFont(new Font(null, "Arial", 10, 1));
        toolTip.setBackgroundColor(Display.getCurrent().getSystemColor(29));
        this.canvas.addMouseListener(new MouseListener(){
            String selectedName;

            public void mouseUp(MouseEvent e) {
                if (this.selectedName == null) {
                    return;
                }
                Trace trace = CounterStackCommonView.this.traces.get(this.selectedName);
                trace.setTraceColor(CounterColorManager.getInstance().assignColor(this.selectedName));
                toolTip.hide();
                this.selectedName = null;
            }

            public void mouseDown(MouseEvent e) {
                double xValue = CounterStackCommonView.this.xyGraph.primaryXAxis.getPositionValue(e.x, false);
                double yValue = CounterStackCommonView.this.xyGraph.primaryYAxis.getPositionValue(e.y, false);
                if (CounterStackCommonView.this.xyGraph.primaryXAxis.getRange().getLower() > xValue || CounterStackCommonView.this.xyGraph.primaryXAxis.getRange().getUpper() < xValue) {
                    return;
                }
                if (CounterStackCommonView.this.xyGraph.primaryYAxis.getRange().getLower() > yValue || CounterStackCommonView.this.xyGraph.primaryYAxis.getRange().getUpper() < yValue) {
                    return;
                }
                List sortedTraces = CounterStackCommonView.this.traces.values().stream().sorted(Comparator.comparingDouble(ScouterUtil.nearestPointYValueFunc(xValue)).reversed()).collect(Collectors.toList());
                ISample topSample = ScouterUtil.getNearestPoint(((Trace)sortedTraces.get(0)).getDataProvider(), xValue);
                double valueTime = topSample.getXValue();
                double total = topSample.getYValue();
                if (yValue > total) {
                    return;
                }
                int i = 0;
                Trace selectedTrace = null;
                while (i < sortedTraces.size()) {
                    Trace t = (Trace)sortedTraces.get(i);
                    double stackValue = ScouterUtil.getNearestValue(t.getDataProvider(), valueTime);
                    if (stackValue < yValue) {
                        selectedTrace = (Trace)sortedTraces.get(--i);
                        break;
                    }
                    ++i;
                }
                if (selectedTrace == null) {
                    selectedTrace = (Trace)sortedTraces.get(i - 1);
                }
                this.selectedName = selectedTrace.getName();
                double value = ScouterUtil.getNearestValue(selectedTrace.getDataProvider(), valueTime);
                if (i < sortedTraces.size() - 1) {
                    int j = i + 1;
                    double nextStackValue = value;
                    while (nextStackValue == value && j < sortedTraces.size()) {
                        nextStackValue = ScouterUtil.getNearestValue(((Trace)sortedTraces.get(j)).getDataProvider(), valueTime);
                        ++j;
                    }
                    if (nextStackValue < value) {
                        value -= nextStackValue;
                    }
                }
                double percent = value * 100.0 / total;
                selectedTrace.setTraceColor(ColorUtil.getInstance().getColor("dark magenta"));
                toolTip.setText(String.valueOf(DateUtil.format((long)CastUtil.clong((Object)valueTime), (String)"HH:mm:ss")) + "\n" + this.selectedName + "\n" + FormatUtil.print((Object)percent, (String)"##0.0") + " %");
                toolTip.show(new Point(e.x, e.y));
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(true);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.thread = new RefreshThread(this, 2000);
        this.thread.start();
    }

    @Override
    public void refresh() {
        MapValue mv = this.fetch();
        if (mv == null) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    CounterStackCommonView.this.setTitleImage(Images.inactive);
                    long now = TimeUtil.getCurrentTime();
                    CounterStackCommonView.this.xyGraph.primaryXAxis.setRange(now - 300000L, now + 1L);
                }
            });
            return;
        }
        final long now = TimeUtil.getCurrentTime();
        final long stime = now - 300000L;
        Enumeration keys = mv.keys();
        while (keys.hasMoreElements()) {
            AbstractServiceGroupTPSView.StackValue sv;
            String key = (String)keys.nextElement();
            double value = CastUtil.cdouble((Object)mv.get(key));
            if (this.stackValueMap.containsKey((Object)key)) {
                sv = (AbstractServiceGroupTPSView.StackValue)this.stackValueMap.get((Object)key);
                sv.actualValue = value;
                sv.lastUpdateTime = now;
                continue;
            }
            sv = new AbstractServiceGroupTPSView.StackValue();
            sv.actualValue = value;
            sv.lastUpdateTime = now;
            this.stackValueMap.putFirst((Object)key, (Object)sv);
        }
        Enumeration itr = this.stackValueMap.keys();
        final LinkedMap tempMap = new LinkedMap();
        double stackValue = 0.0;
        while (itr.hasMoreElements()) {
            String name = (String)itr.nextElement();
            AbstractServiceGroupTPSView.StackValue sv = (AbstractServiceGroupTPSView.StackValue)this.stackValueMap.get((Object)name);
            if (sv.lastUpdateTime != now) continue;
            sv.stackedValue = stackValue += sv.actualValue;
            tempMap.putFirst((Object)name, (Object)sv);
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                CounterStackCommonView.this.setTitleImage(Images.active);
                CounterStackCommonView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                Enumeration itr = tempMap.keys();
                while (itr.hasMoreElements()) {
                    String name = (String)itr.nextElement();
                    AbstractServiceGroupTPSView.StackValue sv = (AbstractServiceGroupTPSView.StackValue)tempMap.get((Object)name);
                    CircularBufferDataProvider provider = (CircularBufferDataProvider)CounterStackCommonView.this.getTrace(name).getDataProvider();
                    provider.addSample(new Sample(now, sv.stackedValue));
                }
                CounterStackCommonView.this.xyGraph.primaryYAxis.setRange(0.0, CounterStackCommonView.this.getMaxValue());
            }
        });
    }

    private Trace getTrace(String name) {
        Trace trace = this.traces.get(name);
        if (trace == null) {
            CircularBufferDataProvider provider = new CircularBufferDataProvider(true);
            provider.setBufferSize(200);
            trace = new Trace(name, this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, provider);
            trace.setPointStyle(Trace.PointStyle.NONE);
            trace.getXAxis().setFormatPattern("HH:mm:ss");
            trace.getYAxis().setFormatPattern("#,##0");
            trace.setTraceType(Trace.TraceType.AREA);
            trace.setAreaAlpha(255);
            trace.setTraceColor(CounterColorManager.getInstance().assignColor(name));
            this.xyGraph.addTrace(trace);
            this.traces.put(name, trace);
        }
        return trace;
    }

    private double getMaxValue() {
        Range xRange = this.xyGraph.primaryXAxis.getRange();
        double lower = xRange.getLower();
        double upper = xRange.getUpper();
        double max = 0.0;
        for (String name : this.traces.keySet()) {
            CircularBufferDataProvider data = (CircularBufferDataProvider)this.traces.get(name).getDataProvider();
            if (data == null) continue;
            int inx = 0;
            while (inx < data.getSize()) {
                double y;
                Sample sample = (Sample)data.getSample(inx);
                double x = sample.getXValue();
                if (!(x < lower) && !(x > upper) && (y = sample.getYValue()) > max) {
                    max = y;
                }
                ++inx;
            }
        }
        return ChartUtil.getGroupMaxValue(max);
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    public void setFocus() {
    }

    protected abstract MapValue fetch();
}

