/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import scouter.client.util.ColorUtil;

public class DigitalCountView
extends ViewPart {
    public static final String ID = DigitalCountView.class.getName();
    protected Canvas canvas;
    protected String value = "DigitalCount";
    protected String title = "";

    public void createPartControl(Composite parent) {
        this.canvas = new Canvas(parent, 0x20000000);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.canvas.setLayout((Layout)layout);
        this.canvas.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                DigitalCountView.this.drawText(DigitalCountView.this.canvas.getClientArea(), e.gc);
            }
        });
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (!this.lock) {
                    this.lock = true;
                    DigitalCountView.this.canvas.redraw();
                    this.lock = false;
                }
            }
        });
    }

    private void drawText(Rectangle area, GC gc) {
        try {
            int fontSize2;
            int fontSize = area.height / 2;
            Font font = new Font(null, "Arial", fontSize, 1);
            gc.setFont(font);
            int stringLength = gc.stringExtent((String)this.value).x;
            if (stringLength > area.width && (fontSize2 = area.width / this.value.length()) < fontSize) {
                fontSize = fontSize2;
                Font oldfont = gc.getFont();
                font = new Font(null, "Arial", fontSize, 1);
                gc.setFont(font);
                oldfont.dispose();
                stringLength = gc.stringExtent((String)this.value).x;
            }
            int x = area.width / 2 - stringLength / 2;
            int y = area.height / 2 - fontSize / 2;
            if (x < 1) {
                x = 1;
            }
            gc.drawText(this.value, x, y, true);
            font.dispose();
            fontSize = area.height / 20;
            if (fontSize < 10) {
                fontSize = 10;
            }
            font = new Font(null, "Arial", fontSize, 1);
            gc.setFont(font);
            gc.setForeground(ColorUtil.getInstance().getColor(16));
            stringLength = gc.stringExtent((String)this.title).x;
            x = area.width / 2 - stringLength / 2;
            if (x < 1) {
                x = 1;
            }
            gc.drawText(this.title, x, 1 > (y = y - fontSize - 10) ? 1 : y, true);
            font.dispose();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setFocus() {
    }
}

