/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.io.IOException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.model.AgentModelThread;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ScouterUtil;
import scouter.client.views.EQCommonView;
import scouter.io.DataInputX;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.util.CastUtil;

public class EQView
extends EQCommonView {
    public static final String ID = EQView.class.getName();
    private int serverId;
    protected String objType;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String[] ids = site.getSecondaryId().split("&");
        this.serverId = Integer.valueOf(ids[0]);
        this.objType = ids[1];
    }

    @Override
    public void createPartControl(Composite parent) {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        if (server != null) {
            CounterEngine counterEngine = server.getCounterEngine();
            String displayName = counterEngine.getDisplayNameObjectType(this.objType);
            this.setPartName("Active Service EQ - " + displayName);
        }
        super.createPartControl(parent);
    }

    @Override
    public void fetch() {
        TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
        try {
            try {
                MapPack param = new MapPack();
                param.put("objType", this.objType);
                tcp.process("ACTIVESPEED_REAL_TIME", param, new INetReader(){

                    @Override
                    public void process(DataInputX in) throws IOException {
                        MapPack m = (MapPack)in.readPack();
                        EQCommonView.ActiveSpeedData asd = new EQCommonView.ActiveSpeedData();
                        asd.act1 = CastUtil.cint((Object)m.get("act1"));
                        asd.act2 = CastUtil.cint((Object)m.get("act2"));
                        asd.act3 = CastUtil.cint((Object)m.get("act3"));
                        int objHash = CastUtil.cint((Object)m.get("objHash"));
                        EQCommonView.EqData data = new EQCommonView.EqData();
                        data.objHash = objHash;
                        data.asd = asd;
                        data.displayName = ScouterUtil.getFullObjName(objHash);
                        data.isAlive = AgentModelThread.getInstance().getAgentObject(objHash).isAlive();
                        EQView.this.valueSet.add(data);
                    }
                });
            }
            catch (Throwable t) {
                ConsoleProxy.errorSafe(t.toString());
                TcpProxy.putTcpProxy(tcp);
            }
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
    }
}

