/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.RefreshThread;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ImageUtil;
import scouter.client.util.SortUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.StringUtil;

public class GeneralTableView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = GeneralTableView.class.getName();
    private MapPack pack;
    private Table table;
    private TableColumnLayout tableColumnLayout = new TableColumnLayout();
    Action action;
    Composite comp;
    boolean lastIsNum;
    boolean lastIsAsc;
    int lastSortIndex;
    Action actAutoRefresh;
    protected RefreshThread thread = null;
    boolean noCols = true;

    public void createPartControl(Composite parent) {
        this.comp = new Composite(parent, 0);
        this.table = new Table(this.comp, 68416);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.comp.setLayout((Layout)this.tableColumnLayout);
        this.table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E && GeneralTableView.this.action != null) {
                    GeneralTableView.this.action.run();
                }
            }
        });
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        Action action = new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                if (GeneralTableView.this.action != null) {
                    GeneralTableView.this.action.run();
                }
            }
        };
        man.add((IAction)action);
        this.actAutoRefresh = new Action("Auto Refresh in 5 sec.", 2){

            public void run() {
                if (GeneralTableView.this.actAutoRefresh.isChecked() && GeneralTableView.this.action != null) {
                    GeneralTableView.this.action.run();
                }
            }
        };
        this.actAutoRefresh.setImageDescriptor(ImageUtil.getImageDescriptor(Images.refresh_auto));
        man.add((IAction)this.actAutoRefresh);
        if (this.thread == null) {
            this.thread = new RefreshThread(this, 5000);
            this.thread.start();
        }
    }

    public void setInput(Action action, MapPack pack) throws IOException {
        this.action = action;
        if (pack == null || pack.size() < 1) {
            ConsoleProxy.error("empty value");
            return;
        }
        this.pack = pack;
        String name = pack.getText("_name_");
        if (StringUtil.isNotEmpty((String)name)) {
            this.setPartName(name);
        }
        this.table.setRedraw(false);
        this.process();
        this.table.setRedraw(true);
        this.comp.layout(true, true);
        this.table.redraw();
        this.thread.setName(String.valueOf(this.toString()) + " - " + "action:" + action + ", pack:" + pack);
    }

    private void sortTable() {
        int col_count = this.table.getColumnCount();
        TableItem[] items = this.table.getItems();
        if (this.lastIsNum) {
            new SortUtil(this.lastIsAsc).sort_num(items, this.lastSortIndex, col_count);
        } else {
            new SortUtil(this.lastIsAsc).sort_str(items, this.lastSortIndex, col_count);
        }
    }

    private void process() {
        this.table.removeAll();
        try {
            int max = 0;
            ArrayList<ListValue> lvList = new ArrayList<ListValue>();
            String error = this.pack.getText("_error_");
            if (error != null) {
                ConsoleProxy.errorSafe(error);
            }
            String seq = this.pack.getText("_seq_");
            List<String> keys = null;
            keys = seq != null ? Arrays.asList(StringUtil.tokenizer((String)seq, (String)"/")) : new ArrayList<String>(this.pack.keySet());
            int index = 0;
            for (String key : keys) {
                Value value = this.pack.get(key);
                if (value == null || !(value instanceof ListValue)) continue;
                ListValue lv = (ListValue)value;
                if (this.noCols) {
                    final TableColumn column = new TableColumn(this.table, 16384);
                    column.setText(key);
                    column.setData("index", (Object)index);
                    boolean isNum = true;
                    try {
                        int i = 0;
                        while (i < lv.size()) {
                            String str = lv.getString(i);
                            Double.valueOf(str);
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        isNum = false;
                    }
                    column.setData("isNum", (Object)isNum);
                    this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(30));
                    column.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            TableItem[] items = GeneralTableView.this.table.getItems();
                            boolean asc = CastUtil.cboolean((Object)column.getData("sort"));
                            column.setData("sort", (Object)new Boolean(!asc));
                            boolean isNum = CastUtil.cboolean((Object)column.getData("isNum"));
                            if (isNum) {
                                new SortUtil(asc).sort_num(items, CastUtil.cint((Object)column.getData("index")), GeneralTableView.this.table.getColumnCount());
                            } else {
                                new SortUtil(asc).sort_str(items, CastUtil.cint((Object)column.getData("index")), GeneralTableView.this.table.getColumnCount());
                            }
                            GeneralTableView.this.lastIsAsc = asc;
                            GeneralTableView.this.lastIsNum = isNum;
                            GeneralTableView.this.lastSortIndex = CastUtil.cint((Object)column.getData("index"));
                        }
                    });
                }
                if (lv.size() > max) {
                    max = lv.size();
                }
                lvList.add(lv);
                ++index;
            }
            this.noCols = false;
            ArrayList<String> tempStr = new ArrayList<String>();
            int i = 0;
            while (i < max) {
                tempStr.clear();
                for (ListValue listValue : lvList) {
                    String v = listValue.getString(i);
                    if (v == null) {
                        v = "";
                    }
                    tempStr.add(v);
                }
                TableItem tableItem = new TableItem(this.table, 0, i);
                tableItem.setText(tempStr.toArray(new String[tempStr.size()]));
                ++i;
            }
            this.sortTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.shutdown();
            this.thread = null;
        }
    }

    public void setFocus() {
        if (this.table != null) {
            this.table.setFocus();
        }
    }

    @Override
    public void refresh() {
        if (this.actAutoRefresh.isChecked() && this.action != null) {
            this.action.run();
        }
    }
}

