/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.StringUtil;

public class HeapHistoView
extends ViewPart {
    public static final String ID = HeapHistoView.class.getName();
    private TableViewer viewer;
    private TableColumnLayout tableColumnLayout;
    private Clipboard clipboard;
    private int objHash;
    private int serverId;
    private String secondId;
    boolean ctrlPressed = false;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.secondId = site.getSecondaryId();
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createTableViewer(composite);
        this.clipboard = new Clipboard(null);
    }

    public void setInput(int serverId) {
        this.serverId = serverId;
        if (this.secondId != null) {
            String[] tokens = StringUtil.tokenizer((String)this.secondId, (String)"&");
            this.objHash = CastUtil.cint((Object)tokens[0]);
            long time = CastUtil.clong((Object)tokens[1]);
            this.setPartName("HeapHistogram[" + TextProxy.object.getLoadText(DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(serverId)), this.objHash, serverId) + "][" + DateUtil.format((long)time, (String)"HH:mm:ss") + "]");
        }
        this.load();
    }

    private void createTableContextMenu() {
        MenuManager manager = new MenuManager();
        this.viewer.getControl().setMenu(manager.createContextMenu(this.viewer.getControl()));
        manager.add((IAction)new Action("&Copy", ImageDescriptor.createFromImage((Image)Images.copy)){

            public void run() {
                HeapHistoView.this.selectionCopyToClipboard();
            }
        });
        this.viewer.getTable().addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 262144) {
                    HeapHistoView.this.ctrlPressed = true;
                } else if ((e.keyCode == 99 || e.keyCode == 67) && HeapHistoView.this.ctrlPressed) {
                    HeapHistoView.this.selectionCopyToClipboard();
                }
            }
        });
        this.viewer.getTable().addListener(2, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 262144) {
                    HeapHistoView.this.ctrlPressed = false;
                }
            }
        });
    }

    private void selectionCopyToClipboard() {
        TableItem[] items;
        if (this.viewer != null && (items = this.viewer.getTable().getSelection()) != null && items.length > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                HeapHistoData data = (HeapHistoData)items[i].getData();
                sb.append(data.toString());
                ++i;
            }
            this.clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private void createTableViewer(Composite composite) {
        this.viewer = new TableViewer(composite, 67586);
        this.tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)this.tableColumnLayout);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableContextMenu();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.viewer));
        GridData gridData = new GridData(4, 4, true, true);
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private void createColumns() {
        HeapHistoColumnEnum[] heapHistoColumnEnumArray = HeapHistoColumnEnum.values();
        int n = heapHistoColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            HeapHistoColumnEnum column = heapHistoColumnEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case NO: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof HeapHistoData) {
                                return String.valueOf(((HeapHistoData)element).no);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case COUNT: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof HeapHistoData) {
                                return String.valueOf(((HeapHistoData)element).count);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case SIZE: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof HeapHistoData) {
                                return String.format("%,d", ((HeapHistoData)element).size);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case CLASSNAME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof HeapHistoData) {
                                return ((HeapHistoData)element).name;
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(width, width, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)HeapHistoView.this.viewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    public void setFocus() {
    }

    public void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                ListValue lv;
                TcpProxy tcp;
                ArrayList<HeapHistoData> datas;
                block10: {
                    MapPack out;
                    block9: {
                        out = null;
                        datas = new ArrayList<HeapHistoData>();
                        tcp = TcpProxy.getTcpProxy(HeapHistoView.this.serverId);
                        MapPack param = new MapPack();
                        param.put("objHash", (long)HeapHistoView.this.objHash);
                        out = (MapPack)tcp.getSingle("OBJECT_HEAPHISTO", (Pack)param);
                        if (out != null) break block9;
                        TcpProxy.putTcpProxy(tcp);
                        return;
                    }
                    String error = out.getText("error");
                    if (error != null) {
                        ConsoleProxy.errorSafe(error);
                    }
                    if ((lv = out.getList("heaphisto")) != null) break block10;
                    TcpProxy.putTcpProxy(tcp);
                    return;
                }
                try {
                    try {
                        int i = 0;
                        while (i < lv.size()) {
                            HeapHistoData data = new HeapHistoData();
                            String[] tokens = StringUtil.tokenizer((String)lv.getString(i), (String)" ");
                            if (tokens != null && tokens.length >= 4) {
                                String index = HeapHistoView.removeNotDigit(tokens[0]);
                                data.no = CastUtil.cint((Object)index);
                                data.count = CastUtil.cint((Object)tokens[1]);
                                data.size = CastUtil.clong((Object)tokens[2]);
                                data.name = HeapHistoView.getCanonicalName(tokens[3]);
                                datas.add(data);
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        ConsoleProxy.errorSafe(e.toString());
                        TcpProxy.putTcpProxy(tcp);
                    }
                }
                catch (Throwable throwable) {
                    TcpProxy.putTcpProxy(tcp);
                    throw throwable;
                }
                TcpProxy.putTcpProxy(tcp);
                ExUtil.exec((Composite)HeapHistoView.this.viewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        (this).HeapHistoView.this.viewer.setInput((Object)datas);
                    }
                });
            }
        });
    }

    private static String getCanonicalName(String className) {
        if (StringUtil.isEmpty((String)className)) {
            return className;
        }
        int arrayCnt = 0;
        boolean prefix = true;
        char[] arr = className.toCharArray();
        int offset = 0;
        StringBuilder sb = new StringBuilder();
        while (offset < arr.length && prefix) {
            if (arr[offset] == '[') {
                ++arrayCnt;
            } else if (offset == 0 || arr[offset - 1] == '[') {
                if ('L' == arr[offset]) {
                    if (className.endsWith(";")) {
                        sb.append(className.substring(offset + 1, className.length() - 1));
                    } else {
                        sb.append(className.substring(offset + 1));
                    }
                } else if ('V' == arr[offset]) {
                    sb.append("void");
                } else if ('Z' == arr[offset]) {
                    sb.append("boolean");
                } else if ('C' == arr[offset]) {
                    sb.append("char");
                } else if ('B' == arr[offset]) {
                    sb.append("byte");
                } else if ('S' == arr[offset]) {
                    sb.append("short");
                } else if ('I' == arr[offset]) {
                    sb.append("int");
                } else if ('F' == arr[offset]) {
                    sb.append("float");
                } else if ('J' == arr[offset]) {
                    sb.append("long");
                } else if ('D' == arr[offset]) {
                    sb.append("double");
                } else {
                    sb.append(className);
                }
                prefix = false;
            }
            ++offset;
        }
        while (arrayCnt > 0) {
            sb.append("[]");
            --arrayCnt;
        }
        return sb.toString();
    }

    private static String removeNotDigit(String name) {
        StringBuffer sb = new StringBuffer();
        char[] charArray = name.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            if (Character.isDigit(charArray[i])) {
                sb.append(charArray[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    static enum HeapHistoColumnEnum {
        NO("No", 50, 131072, true, true, true),
        COUNT("Count", 100, 131072, true, true, true),
        SIZE("Size", 150, 131072, true, true, true),
        CLASSNAME("ClassName", 250, 16384, true, true, false);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private HeapHistoColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }

    class HeapHistoData {
        public int no;
        public int count;
        public long size;
        public String name;

        HeapHistoData() {
        }

        public String toString() {
            return String.valueOf(this.no) + "\t" + this.count + "\t" + this.size + "\t" + this.name + "\n";
        }
    }
}

