/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.UIUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.StringUtil;

public class LoginUserView
extends ViewPart {
    public static final String ID = LoginUserView.class.getName();
    private int serverId;
    private TableViewer viewer;
    private TableColumnLayout tableColumnLayout;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.serverId = Integer.valueOf(site.getSecondaryId());
    }

    public void createPartControl(Composite parent) {
        this.setPartName("Login List[" + ServerManager.getInstance().getServer(this.serverId).getName() + "]");
        this.tableColumnLayout = new TableColumnLayout();
        parent.setLayout((Layout)this.tableColumnLayout);
        this.viewer = new TableViewer(parent, 67584);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.viewer));
        this.createTableContextMenu();
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                LoginUserView.this.load();
            }
        });
        this.load();
    }

    public void setFocus() {
    }

    private void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack p;
                block7: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(LoginUserView.this.serverId);
                    p = null;
                    try {
                        try {
                            p = (MapPack)tcp.getSingle("GET_LOGIN_LIST", null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                final ArrayList<UserData> dataList = new ArrayList<UserData>();
                if (p != null) {
                    ListValue sessionLv = p.getList("session");
                    ListValue userLv = p.getList("user");
                    ListValue ipLv = p.getList("ip");
                    ListValue timeLv = p.getList("logintime");
                    ListValue verLv = p.getList("ver");
                    ListValue hostLv = p.getList("host");
                    int i = 0;
                    while (i < sessionLv.size()) {
                        UserData data = new UserData();
                        dataList.add(data);
                        data.session = sessionLv.getLong(i);
                        data.user = userLv.getString(i);
                        data.ip = ipLv.getString(i);
                        data.logintime = timeLv.getLong(i);
                        data.version = verLv.getString(i);
                        data.host = hostLv.getString(i);
                        ++i;
                    }
                }
                ExUtil.exec((Composite)LoginUserView.this.viewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        (this).LoginUserView.this.viewer.setInput((Object)dataList);
                    }
                });
            }
        });
    }

    private void createColumns() {
        UserEnum[] userEnumArray = UserEnum.values();
        int n = userEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            UserEnum column = userEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case USER: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof UserData) {
                                return ((UserData)element).user;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case IP: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof UserData) {
                                return ((UserData)element).ip;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case LOGINTIME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof UserData) {
                                return String.valueOf(((UserData)element).logintime);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case VERSION: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof UserData) {
                                return ((UserData)element).version;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case HOST: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof UserData) {
                                return ((UserData)element).host;
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(width, 10, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)LoginUserView.this.viewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    private void createTableContextMenu() {
        MenuManager manager = new MenuManager();
        this.viewer.getControl().setMenu(manager.createContextMenu(this.viewer.getControl()));
        manager.add((IAction)this.makeRemoteAction("&Force Exit", "EXIT_CLIENT", null));
        manager.add((IAction)this.makeRemoteAction("&Restart", "RESTART_CLIENT", null));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new Action("&Send Message"){

            public void run() {
                new MessageWritingDialog().show();
            }
        });
    }

    public Action makeRemoteAction(String label, final String cmd, final MapPack m) {
        return new Action(label){

            public void run() {
                TableItem[] items = LoginUserView.this.viewer.getTable().getSelection();
                if (items == null || items.length < 1) {
                    return;
                }
                UserData data = (UserData)items[0].getData();
                long session = data.session;
                TcpProxy tcp = TcpProxy.getTcpProxy(LoginUserView.this.serverId);
                try {
                    try {
                        MapPack param = new MapPack();
                        param.put("toSession", session);
                        param.put("command", cmd);
                        if (m != null) {
                            Iterator itr = m.keys();
                            while (itr.hasNext()) {
                                String key = (String)itr.next();
                                param.put(key, m.get(key));
                            }
                        }
                        param.put("fromSession", ServerManager.getInstance().getServer(LoginUserView.this.serverId).getSession());
                        Pack p = tcp.getSingle("REMOTE_CONTROL", (Pack)param);
                        if (p == null || p.getPackType() != 10) {
                            ConsoleProxy.errorSafe(String.valueOf(cmd) + " Network Error");
                        } else if (!((MapPack)p).getBoolean("success")) {
                            ConsoleProxy.errorSafe(String.valueOf(cmd) + " Remote Control Error");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        TcpProxy.putTcpProxy(tcp);
                    }
                }
                finally {
                    TcpProxy.putTcpProxy(tcp);
                }
            }
        };
    }

    class MessageWritingDialog {
        MessageWritingDialog() {
        }

        void show() {
            final Shell dialog = new Shell(Display.getDefault(), 67680);
            UIUtil.setDialogDefaultFunctions(dialog);
            dialog.setText("Send Message");
            dialog.setLayout((Layout)new GridLayout(1, true));
            final Text text = new Text((Composite)dialog, 2626);
            GridData gd = new GridData(400, 300);
            text.setLayoutData((Object)gd);
            Composite comp = new Composite((Composite)dialog, 0);
            comp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            comp.setLayout((Layout)UIUtil.formLayout(0, 0));
            Button btn = new Button(comp, 8);
            btn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, 100, -5, null, -1, 100));
            btn.setText("&Send");
            Composite timerComp = new Composite(comp, 0);
            timerComp.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, btn, -5, null, -1));
            timerComp.setLayout((Layout)new FillLayout());
            final Button autoCloseBtn = new Button(timerComp, 32);
            autoCloseBtn.setText("Auto Close");
            final Combo timerCombo = new Combo(timerComp, 8);
            timerCombo.add("5 sec");
            timerCombo.add("30 sec");
            timerCombo.add("60 sec");
            timerCombo.add("10 min");
            timerCombo.setEnabled(false);
            autoCloseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (autoCloseBtn.getSelection()) {
                        timerCombo.setEnabled(true);
                    } else {
                        timerCombo.setEnabled(false);
                    }
                }
            });
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String text2;
                    MapPack param = new MapPack();
                    Server server = ServerManager.getInstance().getServer(((MessageWritingDialog)MessageWritingDialog.this).LoginUserView.this.serverId);
                    param.put("from", String.valueOf(server.getUserId()) + "(" + server.getName() + ")");
                    param.put("message", text.getText());
                    if (timerCombo.isEnabled() && StringUtil.isNotEmpty((String)(text2 = timerCombo.getText()))) {
                        char[] c = text2.toCharArray();
                        StringBuffer sb = new StringBuffer();
                        int i = 0;
                        while (i < c.length) {
                            switch (c[i]) {
                                case '.': 
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    sb.append(c[i]);
                                }
                            }
                            ++i;
                        }
                        int num = Integer.valueOf(sb.toString());
                        int value = text2.endsWith("min") ? num * 60 : num;
                        param.put("keeptime", (long)value);
                    }
                    LoginUserView.this.makeRemoteAction("Send Message", "POPUP_MESSAGE", param).run();
                    dialog.close();
                }
            });
            dialog.pack();
            dialog.open();
        }
    }

    static class UserData {
        public long session;
        public String user;
        public String ip;
        public long logintime;
        public String version;
        public String host;

        UserData() {
        }
    }

    static enum UserEnum {
        USER("User", 50, 0x1000000, true, true, false),
        IP("Ip", 50, 16384, true, true, false),
        LOGINTIME("Login Time(Sec)", 50, 131072, true, true, true),
        VERSION("Ver.", 50, 16384, true, true, false),
        HOST("Host", 50, 16384, true, true, false);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private UserEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }
}

