/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.AgentDataProxy;
import scouter.client.model.RefreshThread;
import scouter.client.model.TextProxy;
import scouter.client.model.ThreadData;
import scouter.client.server.ServerManager;
import scouter.client.sorter.TableLabelSorter;
import scouter.client.util.ColorUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.views.ObjectThreadDetailView;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.FormatUtil;
import scouter.util.Hexa32;
import scouter.util.StringUtil;

public class ObjectActiveServiceListView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = ObjectActiveServiceListView.class.getName();
    private int serverId;
    private String objType;
    private int objHash = 0;
    CounterEngine counterEngine;
    private TableViewer tableViewer;
    private TableColumnLayout tableColumnLayout;
    private Label errorLbl;
    RefreshThread thread;
    boolean autoRefresh = false;
    boolean manulRefresh = true;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objType = ids[1];
        if (ids.length > 2) {
            this.objHash = CastUtil.cint((Object)ids[2]);
        }
    }

    public void createPartControl(Composite parent) {
        this.counterEngine = ServerManager.getInstance().getServer(this.serverId).getCounterEngine();
        if (this.objHash == 0) {
            this.setPartName("Active Service List[" + this.counterEngine.getDisplayNameObjectType(this.objType) + "]");
        } else {
            this.setPartName("Active Service List[" + TextProxy.object.getText(this.objHash) + "]");
        }
        this.initialLayout(parent);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ObjectActiveServiceListView.this.manulRefresh = true;
                ObjectActiveServiceListView.this.thread.interrupt();
            }
        });
        man.add((IContributionItem)new Separator());
        Action actAutoRefresh = new Action("Auto Refresh in 5 sec.", 2){

            public void run() {
                ObjectActiveServiceListView.this.autoRefresh = this.isChecked();
                if (ObjectActiveServiceListView.this.autoRefresh) {
                    ObjectActiveServiceListView.this.thread.interrupt();
                }
            }
        };
        actAutoRefresh.setImageDescriptor(ImageUtil.getImageDescriptor(Images.refresh_auto));
        man.add((IAction)actAutoRefresh);
        this.thread = new RefreshThread(this, 5000);
        this.thread.start();
    }

    private void initialLayout(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.errorLbl = new Label(composite, 0);
        this.errorLbl.setForeground(ColorUtil.getInstance().getColor(3));
        GridData gr = new GridData(4, 4, true, false);
        gr.exclude = true;
        this.errorLbl.setLayoutData((Object)gr);
        this.errorLbl.setVisible(false);
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComposite.setLayout((Layout)new GridLayout(1, true));
        this.createTableViewer(tableComposite);
    }

    private void createTableViewer(Composite composite) {
        this.tableViewer = new TableViewer(composite, 67586);
        this.tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)this.tableColumnLayout);
        this.createColumns();
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.tableViewer.setComparator((ViewerComparator)new TableLabelSorter(this.tableViewer));
        GridData gridData = new GridData(4, 4, true, true);
        this.tableViewer.getControl().setLayoutData((Object)gridData);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof ThreadData) {
                    ThreadData data = (ThreadData)o;
                    try {
                        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        ObjectThreadDetailView view = (ObjectThreadDetailView)win.getActivePage().showView(ObjectThreadDetailView.ID, String.valueOf(ObjectActiveServiceListView.this.serverId) + "&" + data.objHash, 1);
                        view.setInput(data.id, Hexa32.toLong32((String)data.txid));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    public void refresh() {
        if (!this.manulRefresh && !this.autoRefresh) {
            return;
        }
        this.manulRefresh = false;
        this.load();
    }

    private void load() {
        List<Pack> packList = AgentDataProxy.getActiveThreadList(this.objType, this.objHash, this.serverId);
        final ArrayList<ThreadData> datas = new ArrayList<ThreadData>();
        final DecimalValue count = new DecimalValue();
        final StringBuilder error = new StringBuilder();
        for (Pack pack : packList) {
            String objName;
            MapPack mpack = (MapPack)pack;
            boolean complete = mpack.getBoolean("complete");
            int objHash = mpack.getInt("objHash");
            if (!complete && (objName = TextProxy.object.getText(objHash)) != null) {
                error.append(String.valueOf(objName) + " ");
            }
            ListValue idLv = mpack.getList("id");
            ListValue nameLv = mpack.getList("name");
            ListValue statLv = mpack.getList("stat");
            ListValue cpuLv = mpack.getList("cpu");
            ListValue txidLv = mpack.getList("txid");
            ListValue elapsedLv = mpack.getList("elapsed");
            ListValue serviceLv = mpack.getList("service");
            ListValue ipLv = mpack.getList("ip");
            ListValue sqlLv = mpack.getList("sql");
            ListValue subcallLv = mpack.getList("subcall");
            if (idLv != null) {
                int size = idLv.size();
                count.value += (long)size;
                int i = 0;
                while (i < size) {
                    ThreadData data = new ThreadData();
                    data.id = idLv.getLong(i);
                    data.objHash = objHash;
                    data.name = nameLv.getString(i);
                    data.state = statLv.getString(i);
                    data.cpu = cpuLv.getLong(i);
                    data.txid = txidLv.getString(i);
                    data.elapsed = elapsedLv.getLong(i);
                    data.serviceName = serviceLv.getString(i);
                    String sql = sqlLv.getString(i);
                    data.note = StringUtil.isNotEmpty((String)sql) ? sql : subcallLv.getString(i);
                    if (ipLv != null) {
                        data.ip = ipLv.getString(i);
                    }
                    datas.add(data);
                    ++i;
                }
            }
            Collections.sort(datas, new Comparator<ThreadData>(){

                @Override
                public int compare(ThreadData o1, ThreadData o2) {
                    return o1.elapsed > o2.elapsed ? -1 : 1;
                }
            });
        }
        if (error.length() > 0) {
            error.append("may be not loaded.");
        }
        ExUtil.exec((Composite)this.tableViewer.getTable(), new Runnable(){

            @Override
            public void run() {
                ObjectActiveServiceListView.this.setContentDescription("Count = " + count.value);
                if (error.length() > 0) {
                    GridData gr = (GridData)ObjectActiveServiceListView.this.errorLbl.getLayoutData();
                    gr.exclude = false;
                    ObjectActiveServiceListView.this.errorLbl.setVisible(true);
                    ObjectActiveServiceListView.this.errorLbl.setText(error.toString());
                } else {
                    GridData gr = (GridData)ObjectActiveServiceListView.this.errorLbl.getLayoutData();
                    gr.exclude = true;
                    ObjectActiveServiceListView.this.errorLbl.setVisible(false);
                    ObjectActiveServiceListView.this.errorLbl.setText("");
                }
                ObjectActiveServiceListView.this.errorLbl.getParent().layout(false);
                ObjectActiveServiceListView.this.tableViewer.setInput((Object)datas);
            }
        });
    }

    private void createColumns() {
        ColumnEnum[] columnEnumArray = ColumnEnum.values();
        int n = columnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnEnum column = columnEnumArray[n2];
            this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(width, width, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableLabelSorter sorter = (TableLabelSorter)ObjectActiveServiceListView.this.tableViewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    public void setFocus() {
    }

    static enum ColumnEnum {
        OBJNAME("ObjectName", 150, 16384, true, true, false, 0),
        SERVICE("Service", 200, 16384, true, true, false, 1),
        ELAPSED("Elapsed", 60, 131072, true, true, true, 2),
        NOTE("Note", 200, 16384, true, true, false, 3),
        CPU("Cpu", 60, 131072, true, true, true, 4),
        IP("IP", 100, 16384, true, true, false, 5),
        STATE("State", 100, 16384, true, true, false, 6),
        NAME("Name", 250, 16384, true, true, false, 7),
        NO("No", 40, 131072, true, true, true, 8),
        TXID("TxId", 70, 16384, true, true, false, 9);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;
        private final int index;

        private ColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber, int index) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
            this.index = index;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }

        public int getIndex() {
            return this.index;
        }
    }

    class LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        LabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof ThreadData) {
                ThreadData t = (ThreadData)element;
                if (t.elapsed > 8000L) {
                    return ColorUtil.getInstance().getColor(3);
                }
                if (t.elapsed > 3000L) {
                    return ColorUtil.getInstance().getColor(11);
                }
                return ColorUtil.getInstance().getColor(9);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ThreadData) {
                if (columnIndex == ColumnEnum.NO.getIndex()) {
                    return FormatUtil.print((Object)((ThreadData)element).id, (String)"000");
                }
                if (columnIndex == ColumnEnum.OBJNAME.getIndex()) {
                    return TextProxy.object.getText(((ThreadData)element).objHash);
                }
                if (columnIndex == ColumnEnum.NAME.getIndex()) {
                    return ((ThreadData)element).name;
                }
                if (columnIndex == ColumnEnum.STATE.getIndex()) {
                    return ((ThreadData)element).state;
                }
                if (columnIndex == ColumnEnum.CPU.getIndex()) {
                    return FormatUtil.print((Object)((ThreadData)element).cpu, (String)"#,##0");
                }
                if (columnIndex == ColumnEnum.ELAPSED.getIndex()) {
                    return FormatUtil.print((Object)((ThreadData)element).elapsed, (String)"#,##0");
                }
                if (columnIndex == ColumnEnum.TXID.getIndex()) {
                    return ((ThreadData)element).txid;
                }
                if (columnIndex == ColumnEnum.SERVICE.getIndex()) {
                    return ((ThreadData)element).serviceName;
                }
                if (columnIndex == ColumnEnum.NOTE.getIndex()) {
                    return ((ThreadData)element).note;
                }
                if (columnIndex == ColumnEnum.IP.getIndex()) {
                    return ((ThreadData)element).ip;
                }
            }
            return null;
        }
    }
}

