/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.popup.EditableMessageDialog;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.BlobValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.StringUtil;

public class ObjectClassListView
extends ViewPart {
    public static final String ID = ObjectClassListView.class.getName();
    private int objHash;
    private int currentPage = 1;
    private int totalPage = 1;
    private Text filterText;
    private Button leftButton;
    private Button rightButton;
    private TableViewer tableViewer;
    private TableColumnLayout tableColumnLayout;
    private Clipboard clipboard;
    private int serverId;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objHash = CastUtil.cint((Object)ids[1]);
    }

    public void createPartControl(Composite parent) {
        this.setPartName("Loaded Class List[" + TextProxy.object.getLoadText(DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(this.serverId)), this.objHash, this.serverId) + "]");
        this.initialLayout(parent);
        this.clipboard = new Clipboard(null);
        this.load();
    }

    public void load() {
        final String filter = this.filterText.getText();
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                TcpProxy tcp = TcpProxy.getTcpProxy(ObjectClassListView.this.serverId);
                MapPack out = null;
                try {
                    MapPack param = new MapPack();
                    param.put("objHash", (long)ObjectClassListView.this.objHash);
                    if (StringUtil.isNotEmpty((String)filter)) {
                        param.put("filter", filter);
                    }
                    param.put("page", (long)ObjectClassListView.this.currentPage);
                    out = (MapPack)tcp.getSingle("OBJECT_CLASS_LIST", (Pack)param);
                    if (out == null) {
                        return;
                    }
                }
                catch (Throwable t) {
                    ConsoleProxy.errorSafe(t.toString());
                }
                finally {
                    TcpProxy.putTcpProxy(tcp);
                }
                ObjectClassListView.this.currentPage = out.getInt("page");
                ObjectClassListView.this.totalPage = out.getInt("totalPage");
                ListValue indexLv = out.getList("index");
                if (indexLv == null) {
                    return;
                }
                ListValue nameLv = out.getList("name");
                ListValue typeLv = out.getList("type");
                ListValue superClassLv = out.getList("superClass");
                ListValue interfaceLv = out.getList("interfaces");
                ListValue resourceLv = out.getList("resource");
                int count = indexLv.size();
                final ArrayList<ClassData> classDataList = new ArrayList<ClassData>(count);
                int i = 0;
                while (i < count) {
                    ClassData data = new ClassData();
                    data.index = indexLv.getLong(i);
                    data.type = typeLv.getString(i);
                    data.name = nameLv.getString(i);
                    data.superClass = superClassLv.getString(i);
                    data.interfaces = interfaceLv.getString(i);
                    data.resources = resourceLv.getString(i);
                    classDataList.add(data);
                    ++i;
                }
                ExUtil.exec((Composite)ObjectClassListView.this.tableViewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        ObjectClassListView.this.validatePageButton();
                        (this).ObjectClassListView.this.tableViewer.setInput((Object)classDataList);
                    }
                });
            }
        });
    }

    private void initialLayout(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createUpperMenu(composite);
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComposite.setLayout((Layout)new GridLayout(1, true));
        this.createTableViewer(tableComposite);
    }

    private void createTableViewer(Composite composite) {
        this.tableViewer = new TableViewer(composite, 67586);
        this.tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)this.tableColumnLayout);
        this.createColumns();
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableContextMenu();
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                ObjectClassListView.this.openDescription();
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.tableViewer));
        GridData gridData = new GridData(4, 4, true, true);
        this.tableViewer.getControl().setLayoutData((Object)gridData);
    }

    private void createTableContextMenu() {
        MenuManager manager = new MenuManager();
        this.tableViewer.getControl().setMenu(manager.createContextMenu(this.tableViewer.getControl()));
        manager.add((IAction)new Action("&Copy", ImageDescriptor.createFromImage((Image)Images.copy)){

            public void run() {
                ObjectClassListView.this.selectionCopyToClipboard();
            }
        });
        Server server = ServerManager.getInstance().getServer(this.serverId);
        if (server.isAllowAction("AllowExportClass")) {
            manager.add((IAction)new Action("&Export Class"){

                public void run() {
                    StructuredSelection selection = (StructuredSelection)ObjectClassListView.this.tableViewer.getSelection();
                    ClassData data = (ClassData)selection.getFirstElement();
                    final String className = data.name;
                    if (StringUtil.isEmpty((String)className)) {
                        return;
                    }
                    ExUtil.asyncRun(new Runnable(){

                        @Override
                        public void run() {
                            MapPack p;
                            block8: {
                                TcpProxy tcp = TcpProxy.getTcpProxy((this).ObjectClassListView.this.serverId);
                                p = null;
                                try {
                                    try {
                                        MapPack param = new MapPack();
                                        param.put("objHash", (long)(this).ObjectClassListView.this.objHash);
                                        param.put("class", className);
                                        p = (MapPack)tcp.getSingle("OBJECT_LOAD_CLASS_BY_STREAM", (Pack)param);
                                    }
                                    catch (Exception e) {
                                        ConsoleProxy.errorSafe(e.getMessage());
                                        TcpProxy.putTcpProxy(tcp);
                                        break block8;
                                    }
                                }
                                catch (Throwable throwable) {
                                    TcpProxy.putTcpProxy(tcp);
                                    throw throwable;
                                }
                                TcpProxy.putTcpProxy(tcp);
                            }
                            if (p != null) {
                                Value v;
                                String error = CastUtil.cString((Object)p.get("error"));
                                if (StringUtil.isNotEmpty((String)error)) {
                                    ConsoleProxy.errorSafe(error);
                                }
                                if ((v = p.get("class")) != null) {
                                    final BlobValue bv = (BlobValue)v;
                                    ExUtil.exec((Composite)(this).ObjectClassListView.this.tableViewer.getTable(), new Runnable(){

                                        @Override
                                        public void run() {
                                            ObjectClassListView.this.saveClassFile(className, bv);
                                        }
                                    });
                                }
                            }
                        }
                    });
                }
            });
            manager.add((IAction)new Action("&Export Jar"){

                public void run() {
                    StructuredSelection selection = (StructuredSelection)ObjectClassListView.this.tableViewer.getSelection();
                    final ClassData data = (ClassData)selection.getFirstElement();
                    final String resource = data.resources;
                    if (StringUtil.isEmpty((String)resource)) {
                        return;
                    }
                    ExUtil.asyncRun(new Runnable(){

                        @Override
                        public void run() {
                            MapPack p;
                            block8: {
                                TcpProxy tcp = TcpProxy.getTcpProxy((this).ObjectClassListView.this.serverId);
                                p = null;
                                try {
                                    try {
                                        MapPack param = new MapPack();
                                        param.put("objHash", (long)(this).ObjectClassListView.this.objHash);
                                        param.put("resource", resource);
                                        p = (MapPack)tcp.getSingle("OBJECT_CHECK_RESOURCE_FILE", (Pack)param);
                                    }
                                    catch (Exception e) {
                                        ConsoleProxy.errorSafe(e.getMessage());
                                        TcpProxy.putTcpProxy(tcp);
                                        break block8;
                                    }
                                }
                                catch (Throwable throwable) {
                                    TcpProxy.putTcpProxy(tcp);
                                    throw throwable;
                                }
                                TcpProxy.putTcpProxy(tcp);
                            }
                            if (p != null) {
                                String error = p.getText("error");
                                if (StringUtil.isNotEmpty((String)error)) {
                                    ConsoleProxy.errorSafe(error);
                                } else {
                                    final String name = p.getText("name");
                                    final long size = p.getLong("size");
                                    ExUtil.exec((Composite)(this).ObjectClassListView.this.tableViewer.getTable(), new Runnable(){

                                        @Override
                                        public void run() {
                                            if (MessageDialog.openQuestion((Shell)((this).this).ObjectClassListView.this.tableViewer.getTable().getShell(), (String)data.name, (String)(String.valueOf(name) + "(" + ScouterUtil.humanReadableByteCount(size, true) + ") will be downloaded.\nContinue?"))) {
                                                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                                                FileDialog dialog = new FileDialog(shell, 8192);
                                                dialog.setOverwrite(true);
                                                dialog.setFileName(name);
                                                dialog.setFilterExtensions(new String[]{"*.jar", "*.*"});
                                                dialog.setFilterNames(new String[]{"Jar File(*.jar)", "All Files"});
                                                String fileSelected = dialog.open();
                                                if (fileSelected != null) {
                                                    new DownloadJarFileJob(name, resource, fileSelected).schedule();
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    });
                }
            });
        }
        manager.add((IAction)new Action("&Description"){

            public void run() {
                ObjectClassListView.this.openDescription();
            }
        });
        manager.add((IContributionItem)new Separator());
        if (server.isAllowAction("AllowRedefineClass")) {
            manager.add((IAction)new Action("&Redefine class"){

                public void run() {
                    StructuredSelection selection = (StructuredSelection)ObjectClassListView.this.tableViewer.getSelection();
                    ListValue classLv = new ListValue();
                    Object[] datas = selection.toArray();
                    int i = 0;
                    while (i < datas.length) {
                        ClassData data = (ClassData)datas[i];
                        classLv.add(data.name);
                        ++i;
                    }
                    if (MessageDialog.openQuestion((Shell)ObjectClassListView.this.tableViewer.getTable().getShell(), (String)(String.valueOf(classLv.size()) + " class(es) selected"), (String)"Redefine class may affect this server.\nContinue?")) {
                        new RedefineClassJob(classLv).schedule();
                    }
                }
            });
        }
        this.tableViewer.getTable().addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.stateMask == 262144 && (e.keyCode == 99 || e.keyCode == 67)) {
                    ObjectClassListView.this.selectionCopyToClipboard();
                }
            }
        });
    }

    public void saveClassFile(String className, final BlobValue bv) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setOverwrite(true);
        dialog.setFileName(String.valueOf(className) + ".class");
        dialog.setFilterExtensions(new String[]{"*.class", "*.*"});
        dialog.setFilterNames(new String[]{"Class File(*.class)", "All Files"});
        final String fileSelected = dialog.open();
        if (fileSelected != null) {
            ExUtil.asyncRun("Decompile-" + className + TimeUtil.getCurrentTime(this.serverId), new Runnable(){

                @Override
                public void run() {
                    FileUtil.save((String)fileSelected, (byte[])bv.value);
                    ConsoleProxy.infoSafe(String.valueOf(fileSelected) + " saved.");
                }
            });
        }
    }

    private void createUpperMenu(Composite composite) {
        Group parentGroup = new Group(composite, 0);
        parentGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(5, false);
        parentGroup.setLayout((Layout)layout);
        this.filterText = new Text((Composite)parentGroup, 2048);
        GridData gridData = new GridData(131072, 0x1000000, true, false);
        gridData.minimumWidth = 150;
        this.filterText.setLayoutData((Object)gridData);
        final Button applyButton = new Button((Composite)parentGroup, 8);
        applyButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        applyButton.setImage(Images.filter);
        applyButton.setText("Apply Filter");
        applyButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ObjectClassListView.this.currentPage = 1;
                ExUtil.exec(new Runnable(){

                    @Override
                    public void run() {
                        ObjectClassListView.this.load();
                    }
                });
            }
        });
        this.filterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    applyButton.notifyListeners(13, new Event());
                }
            }
        });
        this.leftButton = new Button((Composite)parentGroup, 8);
        this.leftButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.leftButton.setText("<");
        this.leftButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (ObjectClassListView.this.currentPage > 1) {
                    --ObjectClassListView.this.currentPage;
                    ExUtil.exec(new Runnable(){

                        @Override
                        public void run() {
                            ObjectClassListView.this.load();
                        }
                    });
                }
            }
        });
        this.rightButton = new Button((Composite)parentGroup, 8);
        this.rightButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.rightButton.setText(">");
        this.rightButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (ObjectClassListView.this.currentPage < ObjectClassListView.this.totalPage) {
                    ++ObjectClassListView.this.currentPage;
                    ExUtil.exec(new Runnable(){

                        @Override
                        public void run() {
                            ObjectClassListView.this.load();
                        }
                    });
                }
            }
        });
        this.validatePageButton();
    }

    private void createColumns() {
        ClassColumnEnum[] classColumnEnumArray = ClassColumnEnum.values();
        int n = classColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassColumnEnum column = classColumnEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case NO: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ClassData) {
                                return String.valueOf(((ClassData)element).index);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case TYPE: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ClassData) {
                                return ((ClassData)element).type;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case NAME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ClassData) {
                                return ((ClassData)element).name;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case SUPERCLASS: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ClassData) {
                                return ((ClassData)element).superClass;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case INTERFACES: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ClassData) {
                                return ((ClassData)element).interfaces;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case RESOURCE: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ClassData) {
                                return ((ClassData)element).resources;
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(width, width, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)ObjectClassListView.this.tableViewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    public void setFocus() {
    }

    private void validatePageButton() {
        if (this.currentPage <= 1) {
            this.leftButton.setEnabled(false);
        } else {
            this.leftButton.setEnabled(true);
        }
        if (this.currentPage == this.totalPage) {
            this.rightButton.setEnabled(false);
        } else {
            this.rightButton.setEnabled(true);
        }
    }

    private void selectionCopyToClipboard() {
        TableItem[] items;
        if (this.tableViewer != null && (items = this.tableViewer.getTable().getSelection()) != null && items.length > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                ClassData data = (ClassData)items[i].getData();
                sb.append(data.toString());
                ++i;
            }
            this.clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private void openDescription() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        ClassData data = (ClassData)selection.getFirstElement();
        final String className = data.name;
        if (StringUtil.isEmpty((String)className)) {
            return;
        }
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack p;
                block6: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(ObjectClassListView.this.serverId);
                    p = null;
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("objHash", (long)ObjectClassListView.this.objHash);
                            param.put("class", className);
                            p = (MapPack)tcp.getSingle("OBJECT_CLASS_DESC", (Pack)param);
                        }
                        catch (Exception e) {
                            ConsoleProxy.errorSafe(e.getMessage());
                            TcpProxy.putTcpProxy(tcp);
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (p != null) {
                    final String error = CastUtil.cString((Object)p.get("error"));
                    final Value v = p.get("class");
                    ExUtil.exec((Composite)ObjectClassListView.this.tableViewer.getTable(), new Runnable(){

                        @Override
                        public void run() {
                            if (StringUtil.isNotEmpty((String)error)) {
                                new EditableMessageDialog().show("ERROR", error);
                                return;
                            }
                            new EditableMessageDialog().show(className, CastUtil.cString((Object)v));
                        }
                    });
                }
            }
        });
    }

    static enum ClassColumnEnum {
        NO("No", 20, 131072, true, true, true),
        TYPE("Type", 30, 0x1000000, true, true, false),
        NAME("Name", 250, 16384, true, true, false),
        SUPERCLASS("SuperClass", 150, 16384, true, true, false),
        INTERFACES("Interfaces", 150, 16384, true, true, false),
        RESOURCE("Resources", 150, 16384, true, true, false);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private ClassColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }

    class ClassData {
        public long index;
        public String type;
        public String name;
        public String superClass;
        public String interfaces;
        public String resources;

        ClassData() {
        }

        public String toString() {
            return String.valueOf(this.index) + "\t" + this.type + "\t" + this.name + "\t" + this.superClass + "\t" + this.interfaces + "\t" + this.resources + "\n";
        }
    }

    class DownloadJarFileJob
    extends Job {
        String resource;
        String saveFile;

        public DownloadJarFileJob(String name, String resource, String saveFile) {
            super("Download...." + name);
            this.resource = resource;
            this.saveFile = saveFile;
        }

        protected IStatus run(IProgressMonitor monitor) {
            MapPack p;
            block9: {
                monitor.beginTask("Downloading resource", -1);
                TcpProxy tcp = TcpProxy.getTcpProxy(ObjectClassListView.this.serverId);
                p = null;
                try {
                    try {
                        MapPack param = new MapPack();
                        param.put("objHash", (long)ObjectClassListView.this.objHash);
                        param.put("resource", this.resource);
                        p = (MapPack)tcp.getSingle("OBJECT_DOWNLOAD_JAR", (Pack)param);
                    }
                    catch (Exception e) {
                        ConsoleProxy.errorSafe(e.getMessage());
                        TcpProxy.putTcpProxy(tcp);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    TcpProxy.putTcpProxy(tcp);
                    throw throwable;
                }
                TcpProxy.putTcpProxy(tcp);
            }
            if (p != null) {
                String error = p.getText("error");
                if (StringUtil.isNotEmpty((String)error)) {
                    ConsoleProxy.errorSafe(error);
                } else {
                    Value v = p.get("jar");
                    if (v != null) {
                        BlobValue bv = (BlobValue)v;
                        FileUtil.save((String)this.saveFile, (byte[])bv.value);
                        return Status.OK_STATUS;
                    }
                }
            }
            return Status.CANCEL_STATUS;
        }
    }

    class RedefineClassJob
    extends Job {
        ListValue classLv;

        public RedefineClassJob(ListValue classLv) {
            super("Redefine.... " + classLv.size() + " classes.....");
            this.classLv = classLv;
        }

        protected IStatus run(IProgressMonitor monitor) {
            MapPack p;
            block10: {
                monitor.beginTask("Redefine class", -1);
                TcpProxy tcp = TcpProxy.getTcpProxy(ObjectClassListView.this.serverId);
                p = null;
                try {
                    try {
                        MapPack param = new MapPack();
                        param.put("objHash", (long)ObjectClassListView.this.objHash);
                        param.put("class", (Value)this.classLv);
                        p = (MapPack)tcp.getSingle("REDEFINE_CLASSES", (Pack)param);
                    }
                    catch (Exception e) {
                        ConsoleProxy.errorSafe(e.getMessage());
                        TcpProxy.putTcpProxy(tcp);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    TcpProxy.putTcpProxy(tcp);
                    throw throwable;
                }
                TcpProxy.putTcpProxy(tcp);
            }
            if (p != null) {
                boolean success = p.getBoolean("success");
                if (success) {
                    ConsoleProxy.infoSafe("Redefine complete");
                } else {
                    String error = p.getText("error");
                    if (StringUtil.isNotEmpty((String)error)) {
                        ConsoleProxy.errorSafe(error);
                    } else {
                        ConsoleProxy.errorSafe("Redefine failed.");
                    }
                }
            }
            return Status.CANCEL_STATUS;
        }
    }
}

