/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.actions.OpenObjectDailyListAction;
import scouter.client.context.actions.OpenCxtmenuPropertiesAction;
import scouter.client.counter.actions.OpenPastDateViewAction;
import scouter.client.counter.actions.OpenPastTimeViewAction;
import scouter.client.model.AgentDailyListProxy;
import scouter.client.model.AgentObject;
import scouter.client.model.DummyObject;
import scouter.client.model.HierarchyObject;
import scouter.client.model.ServerObject;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.MenuUtil;
import scouter.client.util.ScouterUtil;
import scouter.lang.counters.CounterConstants;
import scouter.lang.counters.CounterEngine;

public class ObjectDailyListView
extends ViewPart {
    public static final String ID = ObjectDailyListView.class.getName();
    public TreeViewer viewer;
    private String curdate;
    private Tree addressTree;
    AgentDailyListProxy proxy = new AgentDailyListProxy();
    private Map<String, ServerObject> root = new HashMap<String, ServerObject>();
    int serverId;
    boolean showMenu = false;
    Set<String> objTypeList = new HashSet<String>();

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)ChartUtil.gridlayout(1));
        parent.setLayoutData((Object)new GridData(1808));
        Composite area2 = new Composite(parent, 0);
        area2.setLayoutData((Object)new GridData(1808));
        area2.setLayout((Layout)new FillLayout());
        this.addressTree = new Tree(area2, 2816);
        this.addressTree.setHeaderVisible(true);
        this.viewer = new TreeViewer(this.addressTree);
        TreeColumn column1 = new TreeColumn(this.addressTree, 16384);
        this.addressTree.setLinesVisible(true);
        column1.setAlignment(16384);
        column1.setText("Instance");
        column1.setWidth(220);
        TreeColumnLayout layout = new TreeColumnLayout();
        area2.setLayout((Layout)layout);
        layout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(90));
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.viewer.setInput(this.root);
        this.createContextMenu((Viewer)this.viewer, new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (ObjectDailyListView.this.showMenu) {
                    ObjectDailyListView.this.fillTreeViewerContextMenu(manager);
                    ObjectDailyListView.this.showMenu = false;
                }
            }
        });
        this.viewer.getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                TreeItem item = ObjectDailyListView.this.viewer.getTree().getItem(point);
                if (item != null) {
                    ObjectDailyListView.this.showMenu = true;
                }
            }
        });
        this.viewer.getTree().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                TreeItem item = ObjectDailyListView.this.viewer.getTree().getItem(point);
                if (item != null) {
                    if (item.getExpanded()) {
                        item.setExpanded(false);
                    } else {
                        item.setExpanded(true);
                    }
                }
            }
        });
        this.createQuickMenus();
    }

    public void setInput(String date, int serverId) {
        this.serverId = serverId;
        this.setDate(date);
    }

    private void createQuickMenus() {
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Expand all", ImageUtil.getImageDescriptor(Images.expand)){

            public void run() {
                ObjectDailyListView.this.viewer.expandAll();
            }
        });
        man.add((IAction)new Action("Collapse All", ImageUtil.getImageDescriptor(Images.collapse)){

            public void run() {
                ObjectDailyListView.this.viewer.collapseAll();
            }
        });
        man.add((IAction)new Action("Date", ImageUtil.getImageDescriptor(Images.calendar)){

            public void run() {
                new OpenObjectDailyListAction(ObjectDailyListView.this.getSite().getWorkbenchWindow(), "Date", Images.calendar, ObjectDailyListView.this.serverId).run();
            }
        });
    }

    private void createContextMenu(Viewer viewer, IMenuListener listener) {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(listener);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
    }

    private void fillTreeViewerContextMenu(IMenuManager mgr) {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object[] elements = sel.toArray();
            if (elements == null || elements.length < 1) {
                return;
            }
            Object selObject = elements[elements.length - 1];
            IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (selObject instanceof AgentObject) {
                int serverId = ((AgentObject)selObject).getServerId();
                String objType = ((AgentObject)selObject).getObjType();
                int objHash = ((AgentObject)selObject).getObjHash();
                String objName = ((AgentObject)selObject).getObjName();
                Server server = ServerManager.getInstance().getServer(serverId);
                CounterEngine counterEngine = server.getCounterEngine();
                String[] counterNames = counterEngine.getSortedCounterName(objType);
                int inx = 0;
                while (inx < counterNames.length) {
                    String counter = counterNames[inx];
                    String counterDisplay = counterEngine.getCounterDisplayName(objType, counter);
                    MenuManager counterMenu = new MenuManager(counterDisplay, Images.getCounterImageDescriptor(objType, counter, serverId), "scouter." + objType + "." + counter);
                    mgr.add((IContributionItem)counterMenu);
                    counterMenu.add((IAction)new OpenPastTimeViewAction(win, "Time", Images.CTXMENU_RTC, objHash, objType, this.curdate, objName, counter, serverId));
                    counterMenu.add((IAction)new OpenPastDateViewAction(win, "Daily", Images.CTXMENU_RDC, objHash, objType, this.curdate, objName, counter, serverId));
                    ++inx;
                }
                mgr.add((IContributionItem)new Separator());
                mgr.add((IAction)new OpenCxtmenuPropertiesAction(win, "Properties", objHash, serverId, this.curdate));
            } else if (selObject instanceof ServerObject) {
                int serverId = ((ServerObject)selObject).getId();
                Server server = ServerManager.getInstance().getServer(serverId);
                CounterEngine counterEngine = server.getCounterEngine();
                HashMap<String, Action> actions = MenuUtil.getPastCounterActionList(win, counterEngine, this.curdate, serverId);
                if (actions == null) {
                    return;
                }
                for (String objType : this.objTypeList) {
                    String objTypeDisplay = counterEngine.getDisplayNameObjectType(objType);
                    ImageDescriptor objImage = Images.getObjectImageDescriptor(objType, true, serverId);
                    MenuManager objTitle = new MenuManager(objTypeDisplay, objImage, "scouter.menu.id.load." + objTypeDisplay);
                    mgr.add((IContributionItem)objTitle);
                    ArrayList counters = counterEngine.getAllCounterWithDisplay(objType);
                    int i = 0;
                    while (counters != null && i < counters.size()) {
                        String[] cnt = ((String)counters.get(i)).split(":");
                        String display = cnt[0];
                        String counter = cnt[1];
                        MenuManager counterMenuManager = new MenuManager(display, ImageUtil.getImageDescriptor(Images.getCounterImage(objType, counter, serverId)), "scouter.menu.id.load." + objType + "." + counter);
                        String[] stringArray = CounterConstants.COUNTER_MENU_ARRAY;
                        int n = CounterConstants.COUNTER_MENU_ARRAY.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Action act;
                            String menu = stringArray[n2];
                            if (!ScouterUtil.isLiveMenu(menu) && (act = actions.get(String.valueOf(objType) + ":" + counter + ":" + menu)) != null) {
                                act.setText(ScouterUtil.getActionName(menu));
                                act.setImageDescriptor(ScouterUtil.getActionIconName(menu));
                                counterMenuManager.add((IAction)act);
                            }
                            ++n2;
                        }
                        objTitle.add((IContributionItem)counterMenuManager);
                        ++i;
                    }
                    MenuUtil.addPastObjTypeSpecialMenu(win, (IMenuManager)objTitle, serverId, objType, counterEngine, this.curdate);
                }
            }
        }
    }

    private void setDate(String date) {
        this.curdate = date;
        this.setContentDescription(String.valueOf(date.substring(0, 4)) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8));
        this.makeHierarchyMap();
        this.viewer.refresh();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private synchronized void makeHierarchyMap() {
        HashMap<String, ServerObject> tempRootMap = new HashMap<String, ServerObject>();
        this.objTypeList.clear();
        ArrayList<AgentObject> objectList = this.proxy.getObjectList(this.curdate, this.serverId);
        for (AgentObject agent : objectList) {
            int serverId = agent.getServerId();
            this.objTypeList.add(agent.getObjType());
            String serverName = ServerManager.getInstance().getServer(serverId).getName();
            ServerObject serverObj = (ServerObject)tempRootMap.get(serverName);
            if (serverObj == null) {
                serverObj = new ServerObject(serverId, serverName);
                tempRootMap.put(serverName, serverObj);
            }
            String objName = agent.getObjName();
            HierarchyObject parent = serverObj;
            int inx = objName.indexOf("/", 1);
            while (inx != -1) {
                String childName = objName.substring(0, inx);
                HierarchyObject child = parent.getChild(childName);
                if (child == null) {
                    child = new DummyObject(childName);
                    child.setParent(parent);
                    parent.putChild(childName, child);
                }
                parent = child;
                inx = objName.indexOf("/", inx + 1);
            }
            HierarchyObject beforeDummyObj = parent.putChild(objName, agent);
            if (beforeDummyObj != null && beforeDummyObj instanceof DummyObject) {
                agent.setChildMap(((DummyObject)beforeDummyObj).getChildMap());
            }
            agent.setParent(parent);
        }
        this.root.clear();
        this.root.putAll(tempRootMap);
    }

    public class TreeLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof AgentObject) {
                AgentObject a = (AgentObject)element;
                return Images.getObjectIcon(a.getObjType(), true, ObjectDailyListView.this.serverId);
            }
            if (element instanceof ServerObject) {
                return Images.SERVER_ACT;
            }
            if (element instanceof DummyObject) {
                DummyObject dummyObj = (DummyObject)element;
                if (dummyObj.getChildSize() > 0) {
                    return Images.folder;
                }
                return Images.default_context;
            }
            return Images.default_context;
        }

        public String getText(Object element) {
            if (element instanceof AgentObject) {
                AgentObject a = (AgentObject)element;
                return a.getDisplayName();
            }
            if (element instanceof ServerObject) {
                ServerObject a = (ServerObject)element;
                return a.getName();
            }
            if (element instanceof DummyObject) {
                DummyObject a = (DummyObject)element;
                return a.getName();
            }
            return element.toString();
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof Map) {
                return ((Map)parent).values().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof HierarchyObject) {
                return ((HierarchyObject)parentElement).getSortedChildArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof HierarchyObject) {
                return ((HierarchyObject)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof HierarchyObject) {
                return ((HierarchyObject)element).getChildSize() > 0;
            }
            return false;
        }

        public boolean equals(Object obj) {
            return true;
        }
    }
}

