/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IFigureProvider;
import org.eclipse.zest.core.viewers.IGraphEntityContentProvider;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import scouter.client.Images;
import scouter.client.context.actions.OpenCxtmenuActiveServiceListAction;
import scouter.client.dashboard.figure.AgentObjectFigure;
import scouter.client.dashboard.figure.DummyObjectFigure;
import scouter.client.dashboard.figure.ServerObjectFigure;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.model.DummyObject;
import scouter.client.model.HierarchyObject;
import scouter.client.model.RefreshThread;
import scouter.client.model.ServerObject;
import scouter.client.popup.ObjectSelectionDialog;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.threads.AlertProxyThread;
import scouter.client.threads.ObjectSelectManager;
import scouter.client.util.DummyAction;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.MenuUtil;
import scouter.lang.ObjectType;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.AlertPack;
import scouter.util.CacheTable;

public class ObjectDashboardView
extends ViewPart
implements RefreshThread.Refreshable,
ObjectSelectManager.IObjectCheckListener,
AlertProxyThread.IAlertListener {
    public static final String ID = ObjectDashboardView.class.getName();
    Font arial10font = new Font(null, "Arial", 10, 1);
    private GraphViewer viewer = null;
    private AgentModelThread agentThread = AgentModelThread.getInstance();
    private TreeMap<String, HierarchyObject> rootMap = new TreeMap();
    private ArrayList<HierarchyObject> elementList = new ArrayList();
    ObjectSelectManager objSelManager = ObjectSelectManager.getInstance();
    private RefreshThread thread;
    private Action actAutoRefresh = null;
    private boolean autoRefresh = true;
    Action autoResizeAct;
    Action withServerObjAct;
    IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    AlertProxyThread alertThread = AlertProxyThread.getInstance();
    CacheTable<Integer, AlertPack> alertTable = new CacheTable();
    boolean firstTime = true;
    int lastElementSize;

    public void createPartControl(final Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        parent.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (ObjectDashboardView.this.autoResizeAct.isChecked()) {
                    ObjectDashboardView.this.viewer.applyLayout();
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.viewer = new GraphViewer(parent, 0);
        this.viewer.setContentProvider((IContentProvider)new DashboardContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DashboardLabelProvider());
        boolean style = true;
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Filter Object", ImageUtil.getImageDescriptor(Images.filter)){

            public void run() {
                new ObjectSelectionDialog().show();
            }
        });
        this.actAutoRefresh = new Action("AutoRefresh in 2 sec.", 2){

            public void run() {
                ObjectDashboardView.this.autoRefresh = ObjectDashboardView.this.actAutoRefresh.isChecked();
            }
        };
        this.actAutoRefresh.setImageDescriptor(ImageUtil.getImageDescriptor(Images.refresh_auto));
        man.add((IAction)this.actAutoRefresh);
        this.actAutoRefresh.setChecked(true);
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        MenuManager layoutMenu = new MenuManager("Layout");
        menuManager.add((IContributionItem)layoutMenu);
        Action treeLayout = new Action("Tree", 8){

            public void run() {
                ObjectDashboardView.this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new TreeLayoutAlgorithm(1));
                ObjectDashboardView.this.viewer.applyLayout();
            }
        };
        layoutMenu.add((IAction)treeLayout);
        treeLayout.setChecked(true);
        Action horizontalTreeLayout = new Action("Horizontal Tree", 8){

            public void run() {
                ObjectDashboardView.this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new HorizontalTreeLayoutAlgorithm(1));
                ObjectDashboardView.this.viewer.applyLayout();
            }
        };
        layoutMenu.add((IAction)horizontalTreeLayout);
        Action radialLayout = new Action("Radial", 8){

            public void run() {
                ObjectDashboardView.this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new RadialLayoutAlgorithm(1));
                ObjectDashboardView.this.viewer.applyLayout();
            }
        };
        layoutMenu.add((IAction)radialLayout);
        Action springLayout = new Action("Spring", 8){

            public void run() {
                ObjectDashboardView.this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new SpringLayoutAlgorithm(1));
                ObjectDashboardView.this.viewer.applyLayout();
            }
        };
        layoutMenu.add((IAction)springLayout);
        layoutMenu.add((IContributionItem)new Separator());
        this.autoResizeAct = new Action("Auto Resize", 2){

            public void run() {
                if (ObjectDashboardView.this.autoResizeAct.isChecked()) {
                    parent.notifyListeners(11, new Event());
                }
            }
        };
        this.autoResizeAct.setChecked(true);
        layoutMenu.add((IAction)this.autoResizeAct);
        this.withServerObjAct = new Action("With Server", 2){

            public void run() {
                ObjectDashboardView.this.notifyChangeState();
            }
        };
        this.withServerObjAct.setChecked(true);
        layoutMenu.add((IAction)this.withServerObjAct);
        this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new TreeLayoutAlgorithm(1));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof AgentObject) {
                    AgentObject ao = (AgentObject)o;
                    Server server = ServerManager.getInstance().getServer(ao.getServerId());
                    if (server == null) {
                        return;
                    }
                    CounterEngine counterEngine = server.getCounterEngine();
                    if (counterEngine.isChildOf(ao.getObjType(), "javaee")) {
                        new OpenCxtmenuActiveServiceListAction(ObjectDashboardView.this.getSite().getWorkbenchWindow(), "Active Service List", ao.getObjHash(), ao.getObjType(), ao.getServerId()).run();
                    } else if (counterEngine.isChildOf(ao.getObjType(), "golang")) {
                        new OpenCxtmenuActiveServiceListAction(ObjectDashboardView.this.getSite().getWorkbenchWindow(), "Active Service List", ao.getObjHash(), ao.getObjType(), ao.getServerId()).run();
                    }
                }
            }
        });
        MenuManager contextMgr = new MenuManager();
        Menu menu = contextMgr.createContextMenu((Control)this.viewer.getGraphControl());
        contextMgr.setRemoveAllWhenShown(true);
        contextMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection;
                Object obj;
                ISelection sel = ObjectDashboardView.this.viewer.getSelection();
                if (sel instanceof IStructuredSelection && (obj = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof AgentObject) {
                    AgentObject object = (AgentObject)obj;
                    manager.add((IAction)new DummyAction(object.getObjName(), Images.getObjectIcon(object.getObjType(), true, object.getServerId())));
                    manager.add((IContributionItem)new Separator());
                    MenuUtil.addObjectContextMenu(manager, ObjectDashboardView.this.win, object);
                    return;
                }
            }
        });
        this.viewer.getGraphControl().setMenu(menu);
        this.objSelManager.addObjectCheckStateListener(this);
        this.alertThread.addAlertListener(this);
        this.thread = new RefreshThread(this, 2000);
        this.thread.start();
    }

    @Override
    public void refresh() {
        if (!this.firstTime && !this.autoRefresh) {
            return;
        }
        this.forceRefresh();
        if (this.firstTime) {
            this.firstTime = false;
            ExUtil.exec((Composite)this.viewer.getGraphControl(), new Runnable(){

                @Override
                public void run() {
                    ObjectDashboardView.this.viewer.setInput(new Object());
                }
            });
        }
    }

    private void forceRefresh() {
        AgentObject[] objectList = this.agentThread.getObjectList();
        this.makeHierarchyMap(objectList);
        ExUtil.exec((Composite)this.viewer.getGraphControl(), new Runnable(){

            @Override
            public void run() {
                ObjectDashboardView.this.viewer.refresh(true);
                if (ObjectDashboardView.this.lastElementSize < ObjectDashboardView.this.elementList.size()) {
                    ObjectDashboardView.this.viewer.applyLayout();
                }
                ObjectDashboardView.this.lastElementSize = ObjectDashboardView.this.elementList.size();
            }
        });
    }

    private synchronized void makeHierarchyMap(AgentObject[] objectList) {
        this.elementList.clear();
        this.rootMap.clear();
        Set<Integer> sIds = ServerManager.getInstance().getOpenServerList();
        for (int serverId : sIds) {
            Server server = ServerManager.getInstance().getServer(serverId);
            ServerObject serverObj = new ServerObject(serverId, server.getName());
            this.rootMap.put(server.getName(), serverObj);
            if (!this.withServerObjAct.isChecked()) continue;
            serverObj.setTotalMemory(server.getTotalMemory());
            serverObj.setUsedMemory(server.getUsedMemory());
            this.elementList.add(serverObj);
        }
        AgentObject[] agentObjectArray = objectList;
        int n = objectList.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectType type;
            CounterEngine engine;
            HierarchyObject serverObj;
            AgentObject originAgent = agentObjectArray[n2];
            int serverId = originAgent.getServerId();
            Server server = ServerManager.getInstance().getServer(serverId);
            if (!(server == null || (serverObj = this.rootMap.get(server.getName())) == null || this.objSelManager.isUnselectedObject(originAgent.getObjHash()) || (engine = server.getCounterEngine()).isUnknownObjectType(originAgent.getObjType()) || (type = engine.getObjectType(originAgent.getObjType())) != null && type.isSubObject())) {
                AgentObject newObj = new AgentObject(originAgent);
                String objName = newObj.getObjName();
                HierarchyObject parent = serverObj;
                int inx = objName.indexOf("/", 1);
                while (inx != -1) {
                    String childName = objName.substring(0, inx);
                    HierarchyObject child = parent.getChild(childName);
                    if (child == null) {
                        child = new DummyObject(childName);
                        child.setParent(parent);
                        parent.putChild(childName, child);
                        this.elementList.add(child);
                    }
                    parent = child;
                    inx = objName.indexOf("/", inx + 1);
                }
                HierarchyObject beforeDummyObj = parent.putChild(objName, newObj);
                if (beforeDummyObj != null && beforeDummyObj instanceof DummyObject) {
                    this.elementList.remove(beforeDummyObj);
                    newObj.setChildMap(((DummyObject)beforeDummyObj).getChildMap());
                }
                newObj.setParent(parent);
                this.elementList.add(newObj);
            }
            ++n2;
        }
    }

    public void dispose() {
        this.objSelManager.removeObjectCheckStateListener(this);
        this.alertThread.removeAlertListener(this);
        this.arial10font.dispose();
        super.dispose();
    }

    public void setFocus() {
    }

    @Override
    public void notifyChangeState() {
        this.forceRefresh();
        ExUtil.exec((Composite)this.viewer.getGraphControl(), new Runnable(){

            @Override
            public void run() {
                ObjectDashboardView.this.viewer.applyLayout();
            }
        });
    }

    @Override
    public void ariseAlert(int serverId, AlertPack alert) {
        this.alertTable.put((Object)alert.objHash, (Object)alert, 30000L);
    }

    class DashboardContentProvider
    implements IGraphEntityContentProvider {
        DashboardContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ObjectDashboardView.this.elementList.toArray(new HierarchyObject[ObjectDashboardView.this.elementList.size()]);
        }

        public Object[] getConnectedTo(Object entity) {
            if (entity instanceof HierarchyObject) {
                return ((HierarchyObject)entity).getSortedChildArray();
            }
            return null;
        }
    }

    class DashboardLabelProvider
    extends LabelProvider
    implements IFigureProvider {
        DashboardLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof AgentObject) {
                AgentObject ao = (AgentObject)element;
                return Images.getObjectIcon(ao.getObjType(), true, ao.getServerId());
            }
            if (element instanceof ServerObject) {
                return Images.SERVER_DEFAULT_ACT;
            }
            if (element instanceof DummyObject) {
                return Images.folder;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof HierarchyObject) {
                return ((HierarchyObject)element).getDisplayName();
            }
            return null;
        }

        public IFigure getFigure(Object element) {
            if (element instanceof AgentObject) {
                AgentObject ao = (AgentObject)element;
                return new AgentObjectFigure(ao, ObjectDashboardView.this.arial10font, (AlertPack)ObjectDashboardView.this.alertTable.get((Object)ao.getObjHash()));
            }
            if (element instanceof DummyObject) {
                return new DummyObjectFigure((DummyObject)element);
            }
            if (element instanceof ServerObject) {
                return new ServerObjectFigure((ServerObject)element, ObjectDashboardView.this.arial10font);
            }
            return null;
        }
    }
}

