/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.util.ColoringWord;
import scouter.client.util.CustomLineStyleListener;
import scouter.client.util.ExUtil;
import scouter.client.util.UIUtil;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.util.FileUtil;
import scouter.util.StringUtil;

public class ObjectDumpFileDetailView
extends ViewPart {
    public static final String ID = ObjectDumpFileDetailView.class.getName();
    int serverId;
    int objHash;
    String filename;
    StyledText text;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secondaryId = site.getSecondaryId();
        if (secondaryId != null) {
            String[] secIds = secondaryId.split("&");
            this.serverId = Integer.parseInt(secIds[0]);
            this.objHash = Integer.parseInt(secIds[1]);
        }
    }

    public void setInput(String filename) {
        this.filename = filename;
        this.setPartName(filename);
        this.load();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, false));
        comp.setLayout((Layout)UIUtil.formLayout(5, 5));
        Button saveAsBtn = new Button(comp, 8);
        saveAsBtn.setImage(Images.save);
        saveAsBtn.setText("&Save As");
        saveAsBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, 100, -5, null, -1));
        saveAsBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ObjectDumpFileDetailView.this.saveAs();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Text searchText = new Text(comp, 2048);
        searchText.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, saveAsBtn, -5, null, -1, 100));
        final CustomLineStyleListener styleListener = new CustomLineStyleListener(false, new ArrayList<ColoringWord>(), false, false, 7);
        searchText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (StringUtil.isNotEmpty((String)searchText.getText())) {
                    styleListener.setSearchString(searchText.getText());
                    ObjectDumpFileDetailView.this.text.redraw();
                } else {
                    styleListener.setSearchString(null);
                    ObjectDumpFileDetailView.this.text.redraw();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.text = new StyledText(parent, 2818);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.addLineStyleListener((LineStyleListener)styleListener);
    }

    private void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                TcpProxy tcp = TcpProxy.getTcpProxy(ObjectDumpFileDetailView.this.serverId);
                try {
                    try {
                        MapPack param = new MapPack();
                        param.put("objHash", (long)ObjectDumpFileDetailView.this.objHash);
                        param.put("name", ObjectDumpFileDetailView.this.filename);
                        final ArrayList bytesList = new ArrayList();
                        tcp.process("OBJECT_DUMP_FILE_DETAIL", param, new INetReader(){

                            @Override
                            public void process(DataInputX in) throws IOException {
                                byte[] blob = in.readBlob();
                                int i = 0;
                                while (i < blob.length) {
                                    bytesList.add(blob[i]);
                                    ++i;
                                }
                            }
                        });
                        ExUtil.exec((Composite)ObjectDumpFileDetailView.this.text, new Runnable(){

                            @Override
                            public void run() {
                                Byte[] bytes = bytesList.toArray(new Byte[bytesList.size()]);
                                byte[] result = new byte[bytes.length];
                                int i = 0;
                                while (i < bytes.length) {
                                    result[i] = bytes[i];
                                    ++i;
                                }
                                String content = new String(result);
                                (this).ObjectDumpFileDetailView.this.text.setText(content);
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        TcpProxy.putTcpProxy(tcp);
                    }
                }
                finally {
                    TcpProxy.putTcpProxy(tcp);
                }
            }
        });
    }

    private void saveAs() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setOverwrite(true);
        dialog.setFileName(this.filename);
        dialog.setFilterExtensions(new String[]{"*.txt", "*.*"});
        dialog.setFilterNames(new String[]{"Text File(*.txt)", "All Files"});
        String fileSelected = dialog.open();
        if (fileSelected != null) {
            FileUtil.save((String)fileSelected, (byte[])this.text.getText().getBytes());
        }
    }

    public void setFocus() {
    }
}

