/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.views.ObjectDumpFileDetailView;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.DateUtil;

public class ObjectDumpFileListView
extends ViewPart {
    public static final String ID = ObjectDumpFileListView.class.getName();
    int serverId;
    int objHash;
    TableViewer viewer;
    TableColumnLayout tableColumnLayout;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secondaryId = site.getSecondaryId();
        if (secondaryId != null) {
            String[] secIds = secondaryId.split("_");
            this.serverId = Integer.parseInt(secIds[0]);
            this.objHash = Integer.parseInt(secIds[1]);
        }
    }

    public void createPartControl(Composite parent) {
        this.setPartName("Dump File List[" + TextProxy.object.getLoadText(DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(this.serverId)), this.objHash, this.serverId) + "]");
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite tableComp = new Composite(parent, 0);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableColumnLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)this.tableColumnLayout);
        this.viewer = new TableViewer(tableComp, 67584);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.viewer).setCustomCompare(new ColumnLabelSorter.ICustomCompare(){

            @Override
            public int doCompare(TableColumn col, int index, Object o1, Object o2) {
                Boolean isNumber = (Boolean)col.getData("isNumber");
                if (isNumber != null && isNumber.booleanValue()) {
                    FileData d1 = (FileData)o1;
                    FileData d2 = (FileData)o2;
                    return (int)(d1.getNumberValue(index) - d2.getNumberValue(index));
                }
                ILabelProvider labelProvider = (ILabelProvider)ObjectDumpFileListView.this.viewer.getLabelProvider(index);
                String t1 = labelProvider.getText(o1);
                String t2 = labelProvider.getText(o2);
                if (t1 == null) {
                    t1 = "";
                }
                if (t2 == null) {
                    t2 = "";
                }
                return t1.compareTo(t2);
            }
        }));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                FileData data = (FileData)sel.getFirstElement();
                try {
                    ObjectDumpFileDetailView view = (ObjectDumpFileDetailView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ObjectDumpFileDetailView.ID, String.valueOf(ObjectDumpFileListView.this.serverId) + "&" + ObjectDumpFileListView.this.objHash + "&" + data.name, 1);
                    if (view != null) {
                        view.setInput(data.name);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ObjectDumpFileListView.this.load();
            }
        });
        this.load();
    }

    private void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                Pack p;
                block8: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(ObjectDumpFileListView.this.serverId);
                    p = null;
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("objHash", (long)ObjectDumpFileListView.this.objHash);
                            p = tcp.getSingle("OBJECT_DUMP_FILE_LIST", (Pack)param);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                final ArrayList<FileData> dataList = new ArrayList<FileData>();
                if (p != null) {
                    MapPack m = (MapPack)p;
                    ListValue nameLv = m.getList("name");
                    ListValue sizeLv = m.getList("size");
                    ListValue lastLv = m.getList("last_modified");
                    if (nameLv != null) {
                        int i = 0;
                        while (i < nameLv.size()) {
                            FileData data = new FileData();
                            dataList.add(data);
                            data.name = nameLv.getString(i);
                            data.size = sizeLv.getLong(i);
                            data.lastModifed = lastLv.getLong(i);
                            ++i;
                        }
                    }
                }
                ExUtil.exec((Composite)ObjectDumpFileListView.this.viewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        (this).ObjectDumpFileListView.this.viewer.setInput((Object)dataList);
                    }
                });
            }
        });
    }

    private void createColumns() {
        ColumnEnum[] columnEnumArray = ColumnEnum.values();
        int n = columnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnEnum column = columnEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case NAME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof FileData) {
                                FileData data = (FileData)element;
                                return data.name;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case SIZE: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof FileData) {
                                FileData data = (FileData)element;
                                return ScouterUtil.humanReadableByteCount(data.size, true);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case LAST_MODIFIED: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof FileData) {
                                FileData data = (FileData)element;
                                return DateUtil.format((long)data.lastModifed, (String)"yyyy-MM-dd HH:mm:ss");
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        final TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(width, 20, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)ObjectDumpFileListView.this.viewer.getComparator();
                sorter.setColumn(column);
            }
        });
        return viewerColumn;
    }

    public void setFocus() {
    }

    public static enum ColumnEnum {
        NAME("Name", 300, 0x1000000, true, true, false),
        SIZE("Size", 100, 131072, true, true, true),
        LAST_MODIFIED("Last Modified", 200, 0x1000000, true, true, true);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private ColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }

    class FileData {
        String name;
        long size;
        long lastModifed;

        FileData() {
        }

        public long getNumberValue(int index) {
            switch (index) {
                case 1: {
                    return this.size;
                }
                case 2: {
                    return this.lastModifed;
                }
            }
            return 0L;
        }
    }
}

