/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.AgentDataProxy;
import scouter.client.model.TextProxy;
import scouter.client.popup.EditableMessageDialog;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.lang.pack.MapPack;
import scouter.util.CastUtil;
import scouter.util.StringUtil;

public class ObjectEnvView
extends ViewPart {
    public static final String ID = ObjectEnvView.class.getName();
    private Text filterTxt;
    private TableViewer viewer;
    private TableColumnLayout tableColumnLayout;
    Composite parent;
    private Clipboard clipboard;
    private int objHash;
    private int serverId;
    ArrayList<VariableData> variableList;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = Integer.valueOf(ids[0]);
        this.objHash = Integer.valueOf(ids[1]);
    }

    public void createPartControl(Composite parent) {
        this.setPartName(TextProxy.object.getText(this.objHash));
        this.parent = parent;
        this.initialLayout();
        this.clipboard = new Clipboard(null);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ObjectEnvView.this.load();
            }
        });
        this.load();
    }

    private void initialLayout() {
        Composite composite = new Composite(this.parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createUpperMenu(composite);
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComposite.setLayout((Layout)new GridLayout(1, true));
        this.createTableViewer(tableComposite);
    }

    private void createTableViewer(Composite composite) {
        this.viewer = new TableViewer(composite, 67586);
        this.tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)this.tableColumnLayout);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableContextMenu();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.viewer));
        GridData gridData = new GridData(4, 4, true, true);
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private void createTableContextMenu() {
        MenuManager manager = new MenuManager();
        this.viewer.getControl().setMenu(manager.createContextMenu(this.viewer.getControl()));
        manager.add((IAction)new Action("&Copy", ImageDescriptor.createFromImage((Image)Images.copy)){

            public void run() {
                ObjectEnvView.this.selectionCopyToClipboard();
            }
        });
        this.viewer.getTable().addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.stateMask == 262144 && (e.keyCode == 99 || e.keyCode == 67)) {
                    ObjectEnvView.this.selectionCopyToClipboard();
                }
            }
        });
        this.viewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] items = ObjectEnvView.this.viewer.getTable().getSelection();
                if (items != null && items.length > 0) {
                    VariableData data = (VariableData)items[0].getData();
                    new EditableMessageDialog().show(data.name, data.value);
                }
            }
        });
    }

    private void selectionCopyToClipboard() {
        TableItem[] items;
        if (this.viewer != null && (items = this.viewer.getTable().getSelection()) != null && items.length > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                VariableData data = (VariableData)items[i].getData();
                sb.append(data.toString());
                ++i;
            }
            this.clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack pack = AgentDataProxy.getEnv(ObjectEnvView.this.objHash, ObjectEnvView.this.serverId);
                if (pack != null) {
                    ObjectEnvView.this.variableList = new ArrayList();
                    Iterator keys = pack.keys();
                    while (keys.hasNext()) {
                        String name = (String)keys.next();
                        String value = CastUtil.cString((Object)pack.get(name));
                        VariableData data = new VariableData();
                        ObjectEnvView.this.variableList.add(data);
                        data.name = name;
                        data.value = value;
                    }
                    ExUtil.exec((Composite)ObjectEnvView.this.viewer.getTable(), new Runnable(){

                        @Override
                        public void run() {
                            (this).ObjectEnvView.this.viewer.setInput((this).ObjectEnvView.this.variableList);
                        }
                    });
                }
            }
        });
    }

    private void createUpperMenu(Composite composite) {
        Group parentGroup = new Group(composite, 0);
        parentGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(4, true);
        parentGroup.setLayout((Layout)layout);
        Label dummyLabel = new Label((Composite)parentGroup, 0);
        dummyLabel = new Label((Composite)parentGroup, 0);
        dummyLabel = new Label((Composite)parentGroup, 0);
        dummyLabel.setLayoutData((Object)new GridData());
        this.filterTxt = new Text((Composite)parentGroup, 2048);
        this.filterTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.filterTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String searchText = ObjectEnvView.this.filterTxt.getText();
                if (StringUtil.isEmpty((String)searchText)) {
                    ObjectEnvView.this.viewer.setInput(ObjectEnvView.this.variableList);
                } else {
                    searchText = searchText.toLowerCase();
                    ArrayList<VariableData> tempList = new ArrayList<VariableData>();
                    for (VariableData data : ObjectEnvView.this.variableList) {
                        String name = data.name.toLowerCase();
                        String value = data.value.toLowerCase();
                        if (!name.contains(searchText) && !value.contains(searchText)) continue;
                        tempList.add(data);
                    }
                    ObjectEnvView.this.viewer.setInput(tempList);
                }
            }
        });
    }

    private void createColumns() {
        VariableEnum[] variableEnumArray = VariableEnum.values();
        int n = variableEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableEnum column = variableEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case NAME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof VariableData) {
                                return ((VariableData)element).name;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case VALUE: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof VariableData) {
                                return ((VariableData)element).value;
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(30, width, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)ObjectEnvView.this.viewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    public void setFocus() {
    }

    class VariableData {
        public String name;
        public String value;

        VariableData() {
        }

        public String toString() {
            return String.valueOf(this.name) + "\t" + this.value + "\n";
        }
    }

    static enum VariableEnum {
        NAME("Name", 50, 16384, true, true, false),
        VALUE("Value", 50, 16384, true, true, false);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private VariableEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }
}

