/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.popup.EditableMessageDialog;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.client.util.ColoringWord;
import scouter.client.util.CustomLineStyleListener;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.BlobValue;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.Hexa32;
import scouter.util.IPUtil;
import scouter.util.StringUtil;

public class ObjectFileSocketView
extends ViewPart {
    public static final String ID = ObjectFileSocketView.class.getName();
    static ArrayList<ColoringWord> keyWords = new ArrayList();
    ResourceBundle bundle = ResourceBundle.getBundle("scouter.client.views.tcpport");
    private int serverId;
    private int objHash;
    private TableViewer viewer;
    private TableColumnLayout tableColumnLayout;

    static {
        keyWords.add(new ColoringWord("java.lang.Thread.State:", 9, false));
        keyWords.add(new ColoringWord("daemon", 9, false));
        keyWords.add(new ColoringWord("java.util", 9, false));
        keyWords.add(new ColoringWord("java.net.Socket.connect", 9, false));
        keyWords.add(new ColoringWord("prio", 9, false));
        keyWords.add(new ColoringWord("org.apache", 9, false));
        keyWords.add(new ColoringWord("java.lang.Thread.run", 6, false));
        keyWords.add(new ColoringWord("java.lang", 12, false));
    }

    public void setInput(int serverId, int objHash) {
        this.serverId = serverId;
        this.objHash = objHash;
        this.setPartName("Socket[" + TextProxy.object.getText(objHash) + "]");
        this.load(0L);
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createTableViewer(composite);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ObjectFileSocketView.this.load(0L);
            }
        });
    }

    private void createTableViewer(Composite composite) {
        this.viewer = new TableViewer(composite, 67584);
        this.tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)this.tableColumnLayout);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableContextMenu();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.viewer));
        GridData gridData = new GridData(4, 4, true, true);
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    StructuredSelection sel = (StructuredSelection)event.getSelection();
                    SocketObject socketObj = (SocketObject)sel.getFirstElement();
                    if (StringUtil.isNotEmpty((String)socketObj.stack)) {
                        new EditableMessageDialog().show("Stack", socketObj.stack, new CustomLineStyleListener(false, keyWords, false));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void load(final long key) {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                Pack p;
                block7: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(ObjectFileSocketView.this.serverId);
                    p = null;
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("objHash", (long)ObjectFileSocketView.this.objHash);
                            param.put("key", key);
                            p = tcp.getSingle("SOCKET", (Pack)param);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                final ArrayList<SocketObject> list = new ArrayList<SocketObject>();
                if (p != null) {
                    MapPack m = (MapPack)p;
                    ListValue keyLv = m.getList("key");
                    ListValue hostLv = m.getList("host");
                    ListValue portLv = m.getList("port");
                    ListValue countLv = m.getList("count");
                    ListValue serviceLv = m.getList("service");
                    ListValue txidLv = m.getList("txid");
                    ListValue orderLv = m.getList("order");
                    ListValue stackLv = m.getList("stack");
                    TextProxy.service.load(DateUtil.yyyymmdd(), serviceLv, ObjectFileSocketView.this.serverId);
                    int i = 0;
                    while (i < keyLv.size()) {
                        SocketObject socketObj = new SocketObject();
                        socketObj.key = keyLv.getLong(i);
                        socketObj.host = ((BlobValue)hostLv.get((int)i)).value;
                        socketObj.port = portLv.getInt(i);
                        socketObj.count = countLv.getInt(i);
                        socketObj.service = TextProxy.service.getText(serviceLv.getInt(i));
                        socketObj.txid = txidLv.getLong(i);
                        socketObj.standby = orderLv.getBoolean(i);
                        socketObj.stack = stackLv.getString(i);
                        list.add(socketObj);
                        ++i;
                    }
                }
                ExUtil.exec((Composite)ObjectFileSocketView.this.viewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        (this).ObjectFileSocketView.this.viewer.setInput((Object)list);
                    }
                });
            }
        });
    }

    private void createTableContextMenu() {
        MenuManager manager = new MenuManager();
        this.viewer.getControl().setMenu(manager.createContextMenu(this.viewer.getControl()));
        manager.add((IAction)new Action("&Stack Trace", ImageDescriptor.createFromImage((Image)Images.pin)){

            public void run() {
                try {
                    StructuredSelection sel = (StructuredSelection)ObjectFileSocketView.this.viewer.getSelection();
                    SocketObject socketObj = (SocketObject)sel.getFirstElement();
                    if (socketObj != null) {
                        ObjectFileSocketView.this.load(socketObj.key);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void createColumns() {
        SocketTableEnum[] socketTableEnumArray = SocketTableEnum.values();
        int n = socketTableEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SocketTableEnum column = socketTableEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case HOST: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SocketObject) {
                                SocketObject so = (SocketObject)element;
                                return IPUtil.toString((byte[])so.host);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case PORT: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SocketObject) {
                                SocketObject so = (SocketObject)element;
                                return CastUtil.cString((Object)so.port);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case DESC: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SocketObject) {
                                SocketObject so = (SocketObject)element;
                                String port = CastUtil.cString((Object)so.port);
                                if (ObjectFileSocketView.this.bundle.containsKey(port)) {
                                    return ObjectFileSocketView.this.bundle.getString(port);
                                }
                            }
                            return null;
                        }
                    };
                    break;
                }
                case COUNT: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SocketObject) {
                                SocketObject so = (SocketObject)element;
                                return FormatUtil.print((Object)so.count, (String)"#,##0");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case SERVICE: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SocketObject) {
                                SocketObject so = (SocketObject)element;
                                return so.service;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case TXID: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SocketObject) {
                                SocketObject so = (SocketObject)element;
                                return Hexa32.toString32((long)so.txid);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case STANDBY: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SocketObject) {
                                SocketObject so = (SocketObject)element;
                                if (so.standby) {
                                    return "\u2713";
                                }
                            }
                            return null;
                        }
                    };
                    break;
                }
                case STACK: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SocketObject) {
                                SocketObject so = (SocketObject)element;
                                return so.stack;
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(width, width, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)ObjectFileSocketView.this.viewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    public void setFocus() {
    }

    static class SocketObject {
        long key;
        byte[] host;
        int port;
        long count;
        String service;
        long txid;
        boolean standby;
        String stack;

        SocketObject() {
        }
    }

    static enum SocketTableEnum {
        HOST("Host", 150, 16384, true, true, false),
        PORT("Port", 50, 16384, true, true, true),
        DESC("Description", 150, 16384, true, true, false),
        COUNT("Count", 50, 131072, true, true, true),
        SERVICE("Service", 250, 16384, true, true, false),
        TXID("Txid", 100, 16384, true, true, false),
        STANDBY("\u2713", 30, 0x1000000, true, true, false),
        STACK("Stack", 300, 16384, true, true, false);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private SocketTableEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }
}

