/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.actions.AddServerAction;
import scouter.client.actions.ClearObjectFilterAction;
import scouter.client.actions.OpenAlertDetailListAction;
import scouter.client.actions.OpenGroupNavigationAction;
import scouter.client.actions.OpenLoginListAction;
import scouter.client.actions.OpenObjectDailyListAction;
import scouter.client.actions.OpenServerFileManagementAction;
import scouter.client.actions.OpenServerLogsAction;
import scouter.client.actions.OpenServerManagerAction;
import scouter.client.actions.OpenServerThreadListAction;
import scouter.client.configuration.actions.AddAccountAction;
import scouter.client.configuration.actions.EditAccountAction;
import scouter.client.configuration.actions.ListAccountAction;
import scouter.client.configuration.actions.OpenAlertScriptingAction;
import scouter.client.configuration.actions.OpenCountersSiteFileConfigureAction;
import scouter.client.configuration.actions.OpenGroupPolicyAction;
import scouter.client.configuration.actions.OpenServerConfigureAction;
import scouter.client.configuration.actions.OpenTelegrafConfigureAction;
import scouter.client.configuration.actions.OpenTelegrafFileConfigureAction;
import scouter.client.context.actions.CloseServerAction;
import scouter.client.context.actions.OpenCxtmenuEnvAction;
import scouter.client.context.actions.OpenCxtmenuServerPropertiesAction;
import scouter.client.context.actions.OpenServerAction;
import scouter.client.context.actions.RemoveServerAction;
import scouter.client.context.actions.SetDefaultServerAction;
import scouter.client.counter.actions.OpenTotalSummaryAction;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.model.DummyObject;
import scouter.client.model.GroupObject;
import scouter.client.model.HierarchyObject;
import scouter.client.model.RefreshThread;
import scouter.client.model.ServerObject;
import scouter.client.net.LoginMgr;
import scouter.client.popup.ObjectSelectionDialog;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.tags.actions.OpenTagCountViewAction;
import scouter.client.threads.ObjectSelectManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.DummyAction;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.MenuUtil;
import scouter.client.util.ScouterUtil;
import scouter.lang.Counter;
import scouter.lang.Family;
import scouter.lang.ObjectType;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.lang.value.BlobValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.FormatUtil;
import scouter.util.HashUtil;

public class ObjectNavigationView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = ObjectNavigationView.class.getName();
    private RefreshThread thread;
    public TreeViewer objTreeViewer;
    Tree agentTree;
    Composite parent;
    Composite noticeComposite;
    CLabel noticeLabel;
    boolean selectedItem = false;
    private Map<String, ServerObject> root = new TreeMap<String, ServerObject>();
    private AgentModelThread agentThread = AgentModelThread.getInstance();
    private ObjectSelectManager objSelMgr = ObjectSelectManager.getInstance();
    PresentMode mode = PresentMode.HIERACHY_MODE;
    boolean prevExistUnknown = false;
    MenuManager topMenuManager;
    IMenuManager collectorMenuManager;
    IMenuManager hostMenuManager;
    IMenuManager objectMenuManager;
    private static HashMap<Integer, Map<String, Action>> counterActions = new HashMap();
    ArrayList<AgentObject> objectList = new ArrayList();

    @Override
    public void refresh() {
        if (this.mode == PresentMode.HIERACHY_MODE) {
            this.makeHierarchyMap();
        } else if (this.mode == PresentMode.FLAT_MODE) {
            this.makeFlatMap();
        }
        Integer[] actionSet = counterActions.keySet().toArray(new Integer[counterActions.size()]);
        Set<Integer> existServerSet = this.agentThread.existServerSet();
        Integer[] integerArray = actionSet;
        int n = actionSet.length;
        int n2 = 0;
        while (n2 < n) {
            int serverId = integerArray[n2];
            Server server = ServerManager.getInstance().getServer(serverId);
            if (!existServerSet.contains(serverId) || server == null) {
                ObjectNavigationView.removeActionCache(serverId);
            } else if (server.isDirty()) {
                server.setDirty(false);
                ObjectNavigationView.removeActionCache(serverId);
            }
            ++n2;
        }
        ExUtil.exec((Composite)this.agentTree, new Runnable(){

            @Override
            public void run() {
                ObjectNavigationView.this.refreshViewer();
                GridData griddata = (GridData)ObjectNavigationView.this.noticeComposite.getLayoutData();
                boolean existUnknown = ObjectNavigationView.this.agentThread.existUnknownType();
                if (ObjectNavigationView.this.prevExistUnknown != existUnknown) {
                    if (existUnknown) {
                        griddata.exclude = false;
                        ObjectNavigationView.this.noticeLabel.setImage(Images.exclamation);
                        ObjectNavigationView.this.noticeLabel.setText("Unknown monitoring group id(object type) detected.\nClick for Re-Check.");
                        ObjectNavigationView.this.noticeComposite.setVisible(true);
                        ObjectNavigationView.this.parent.layout(false);
                    } else {
                        griddata.exclude = true;
                        ObjectNavigationView.this.noticeComposite.setVisible(false);
                        ObjectNavigationView.this.parent.layout(false);
                    }
                    ObjectNavigationView.this.prevExistUnknown = existUnknown;
                }
            }
        });
    }

    private void forceRefresh() {
        this.agentThread.fetchObjectList();
        this.refreshCounterEngine();
        this.refresh();
    }

    private void refreshCounterEngine() {
        Set<Integer> serverIdSet = ServerManager.getInstance().getOpenServerList();
        if (serverIdSet.size() > 0) {
            for (int serverId : serverIdSet) {
                CounterEngine counterEngine = ServerManager.getInstance().getServer(serverId).getCounterEngine();
                MapPack m = LoginMgr.getCounterXmlServer(serverId);
                if (m == null) continue;
                counterEngine.clear();
                Value v1 = m.get("default");
                counterEngine.parse(((BlobValue)v1).value);
                v1 = m.get("custom");
                if (v1 == null) continue;
                counterEngine.parse(((BlobValue)v1).value);
            }
        }
    }

    public void refreshViewer() {
        this.objTreeViewer.refresh();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        GridLayout gridlayout = new GridLayout(1, false);
        gridlayout.marginHeight = 0;
        gridlayout.horizontalSpacing = 0;
        gridlayout.marginWidth = 0;
        parent.setLayout((Layout)gridlayout);
        this.noticeComposite = new Composite(parent, 0);
        GridData griddata = new GridData(4, 4, true, false);
        griddata.exclude = true;
        this.noticeComposite.setLayoutData((Object)griddata);
        this.noticeComposite.setLayout((Layout)new FillLayout());
        this.noticeLabel = new CLabel(this.noticeComposite, 66);
        this.noticeComposite.setVisible(false);
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.objTreeViewer = new TreeViewer(mainComposite, 0x10000B00);
        this.agentTree = this.objTreeViewer.getTree();
        this.agentTree.setHeaderVisible(true);
        TreeColumn column1 = new TreeColumn(this.agentTree, 16384);
        this.agentTree.setLinesVisible(true);
        column1.setAlignment(16384);
        column1.setText("Object");
        TreeColumn column2 = new TreeColumn(this.agentTree, 131072);
        column2.setAlignment(131072);
        column2.setText("Perf");
        TreeColumnLayout layout = new TreeColumnLayout();
        mainComposite.setLayout((Layout)layout);
        layout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(68));
        layout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(22));
        this.objTreeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.objTreeViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.objTreeViewer.setInput(this.root);
        this.noticeLabel.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                ObjectNavigationView.this.refreshCounterEngine();
            }
        });
        this.createContextMenu((Viewer)this.objTreeViewer, new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (ObjectNavigationView.this.selectedItem) {
                    ISelection selection = ObjectNavigationView.this.objTreeViewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        IStructuredSelection sel = (IStructuredSelection)selection;
                        Object[] elements = sel.toArray();
                        if (elements == null || elements.length < 1) {
                            return;
                        }
                        Object selObject = elements[elements.length - 1];
                        if (selObject instanceof HierarchyObject) {
                            ObjectNavigationView.this.fillMenu(manager, (HierarchyObject)selObject);
                        }
                    }
                } else {
                    ObjectNavigationView.this.backgroundContextMenu(manager);
                }
            }
        });
        this.objTreeViewer.getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                TreeItem item = ObjectNavigationView.this.objTreeViewer.getTree().getItem(point);
                ObjectNavigationView.this.selectedItem = item != null;
            }
        });
        this.objTreeViewer.getTree().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                StructuredSelection sel;
                Object o;
                Point point = new Point(event.x, event.y);
                TreeItem item = ObjectNavigationView.this.objTreeViewer.getTree().getItem(point);
                if (item != null && (o = (sel = (StructuredSelection)ObjectNavigationView.this.objTreeViewer.getSelection()).getFirstElement()) instanceof AgentObject) {
                    AgentObject ao = (AgentObject)o;
                    if (ObjectNavigationView.this.objSelMgr.unselectedSize() > 0) {
                        ObjectNavigationView.this.objSelMgr.selectObj(ao.getObjHash());
                        if (ObjectNavigationView.this.objSelMgr.unselectedSize() >= ObjectNavigationView.this.objectList.size()) {
                            ObjectNavigationView.this.objSelMgr.clear();
                        }
                    } else {
                        HashSet<Integer> unselSet = new HashSet<Integer>();
                        for (AgentObject a : ObjectNavigationView.this.objectList) {
                            if (a.getObjHash() == ao.getObjHash()) continue;
                            unselSet.add(a.getObjHash());
                        }
                        ObjectNavigationView.this.objSelMgr.addAll(unselSet);
                    }
                    ObjectNavigationView.this.refreshViewer();
                }
            }
        });
        this.createQuickMenus();
        this.initTopMenuMangers();
        ObjectSelectManager.getInstance().addObjectCheckStateListener(new ObjectSelectManager.IObjectCheckListener(){

            @Override
            public void notifyChangeState() {
                if (ObjectNavigationView.this.objSelMgr.unselectedSize() > 0) {
                    ObjectNavigationView.this.agentTree.setBackground(ColorUtil.getInstance().getColor("azure"));
                } else {
                    ObjectNavigationView.this.agentTree.setBackground(null);
                }
                ObjectNavigationView.this.refreshViewer();
            }
        });
        this.thread = new RefreshThread(this, 3000);
        this.thread.start();
    }

    private void resetTopMenu(IMenuManager manager, String dummy) {
        manager.removeAll();
        manager.add((IAction)new DummyAction(dummy, Images.alert));
    }

    private HierarchyObject fillTopMenu(HierarchyObject object, IMenuManager manager) {
        manager.removeAll();
        this.fillMenu(manager, object);
        return object;
    }

    private void initTopMenuMangers() {
        WorkbenchWindow win = (WorkbenchWindow)this.getViewSite().getWorkbenchWindow();
        this.topMenuManager = win.getMenuManager();
        this.collectorMenuManager = (IMenuManager)this.topMenuManager.find("scouter.menu.collector");
        this.hostMenuManager = (IMenuManager)this.topMenuManager.find("scouter.menu.host");
        this.objectMenuManager = (IMenuManager)this.topMenuManager.find("scouter.menu.object");
        this.collectorMenuManager.add((IAction)new DummyAction("Choose Collector in ObjectView", Images.alert));
        this.hostMenuManager.add((IAction)new DummyAction("Choose Host in ObjectView", Images.alert));
        this.objectMenuManager.add((IAction)new DummyAction("Choose Object in ObjectView", Images.alert));
        this.topMenuManager.update(true);
        this.collectorMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ISelection selection = ObjectNavigationView.this.objTreeViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)selection;
                    Object[] elements = sel.toArray();
                    ServerObject serverObject = null;
                    if (elements == null || elements.length < 1) {
                        Server defServer = ServerManager.getInstance().getDefaultServer();
                        serverObject = ObjectNavigationView.this.root.get(defServer.getName());
                    } else {
                        Object selObject = elements[elements.length - 1];
                        if (selObject instanceof ServerObject) {
                            serverObject = (ServerObject)selObject;
                        } else if (selObject instanceof AgentObject) {
                            AgentObject ao = (AgentObject)selObject;
                            Server server = ServerManager.getInstance().getServer(ao.getServerId());
                            serverObject = ObjectNavigationView.this.root.get(server.getName());
                        }
                    }
                    if (serverObject != null) {
                        ObjectNavigationView.this.fillTopMenu(serverObject, mgr);
                    } else {
                        ObjectNavigationView.this.resetTopMenu(ObjectNavigationView.this.collectorMenuManager, "Choose Collector in ObjectView");
                    }
                }
            }
        });
        this.hostMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ISelection selection = ObjectNavigationView.this.objTreeViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)selection;
                    Object[] elements = sel.toArray();
                    AgentObject hostObject = null;
                    if (elements == null || elements.length < 1) {
                        return;
                    }
                    Object selObject = elements[elements.length - 1];
                    if (selObject instanceof AgentObject) {
                        AgentObject agent = (AgentObject)selObject;
                        int serverId = agent.getServerId();
                        Server server = ServerManager.getInstance().getServer(serverId);
                        CounterEngine engine = server.getCounterEngine();
                        if (engine.isChildOf(agent.getObjType(), "host")) {
                            hostObject = agent;
                        } else {
                            String objName = agent.getObjName();
                            String host = objName.substring(0, objName.indexOf("/", 1));
                            hostObject = ObjectNavigationView.this.agentThread.getAgentObject(HashUtil.hash((String)host));
                        }
                    }
                    if (hostObject != null) {
                        ObjectNavigationView.this.fillTopMenu(hostObject, mgr);
                    } else {
                        ObjectNavigationView.this.resetTopMenu(ObjectNavigationView.this.hostMenuManager, "Choose Host in ObjectView");
                    }
                }
            }
        });
        this.objectMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ISelection selection = ObjectNavigationView.this.objTreeViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)selection;
                    Object[] elements = sel.toArray();
                    AgentObject object = null;
                    if (elements == null || elements.length < 1) {
                        return;
                    }
                    Object selObject = elements[elements.length - 1];
                    if (selObject instanceof AgentObject) {
                        AgentObject agent = (AgentObject)selObject;
                        int serverId = agent.getServerId();
                        Server server = ServerManager.getInstance().getServer(serverId);
                        CounterEngine engine = server.getCounterEngine();
                        if (!engine.isChildOf(agent.getObjType(), "host")) {
                            object = agent;
                        }
                    }
                    if (object != null) {
                        ObjectNavigationView.this.fillTopMenu(object, mgr);
                    } else {
                        ObjectNavigationView.this.resetTopMenu(ObjectNavigationView.this.objectMenuManager, "Choose Object in ObjectView");
                    }
                }
            }
        });
    }

    private void createQuickMenus() {
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Expand All", ImageUtil.getImageDescriptor(Images.expand)){

            public void run() {
                ObjectNavigationView.this.objTreeViewer.expandAll();
            }
        });
        man.add((IAction)new Action("Collapse All", ImageUtil.getImageDescriptor(Images.collapse)){

            public void run() {
                ObjectNavigationView.this.objTreeViewer.collapseAll();
            }
        });
        man.add((IContributionItem)new Separator());
        man.add((IAction)new OpenServerManagerAction());
        man.add((IAction)new Action("Filter Object", ImageUtil.getImageDescriptor(Images.filter)){

            public void run() {
                new ObjectSelectionDialog().show();
            }
        });
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ObjectNavigationView.this.forceRefresh();
            }
        });
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IAction)new Action("Remove Inactive", ImageUtil.getImageDescriptor(Images.minus)){

            public void run() {
                boolean result = MessageDialog.openConfirm((Shell)ObjectNavigationView.this.getViewSite().getShell(), (String)"Remove Inactive", (String)"Inactive object(s) will be removed. Continue?");
                if (result) {
                    AgentModelThread.removeInactive();
                }
            }
        });
        menuManager.add((IContributionItem)new Separator());
        MenuManager presentMenu = new MenuManager("Object Presentation");
        menuManager.add((IContributionItem)presentMenu);
        Action hieracyMenu = new Action("Hierarchical", 8){

            public void run() {
                ObjectNavigationView.this.mode = PresentMode.HIERACHY_MODE;
                ObjectNavigationView.this.refresh();
            }
        };
        hieracyMenu.setImageDescriptor(ImageUtil.getImageDescriptor(Images.tree_mode));
        presentMenu.add((IAction)hieracyMenu);
        Action flatMenu = new Action("Flat", 8){

            public void run() {
                ObjectNavigationView.this.mode = PresentMode.FLAT_MODE;
                ObjectNavigationView.this.refresh();
            }
        };
        flatMenu.setImageDescriptor(ImageUtil.getImageDescriptor(Images.flat_layout));
        presentMenu.add((IAction)flatMenu);
        hieracyMenu.setChecked(true);
    }

    private void createContextMenu(Viewer viewer, IMenuListener listener) {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(listener);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
    }

    private void backgroundContextMenu(IMenuManager mgr) {
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (this.objSelMgr.unselectedSize() > 0) {
            mgr.add((IAction)new ClearObjectFilterAction());
        }
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)new AddServerAction(win, "Add Server", Images.add));
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)new OpenGroupNavigationAction(win));
    }

    private void fillMenu(IMenuManager mgr, HierarchyObject selObject) {
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (selObject instanceof AgentObject) {
            AgentObject ao = (AgentObject)selObject;
            CounterEngine engine = ServerManager.getInstance().getServer(ao.getServerId()).getCounterEngine();
            if (!engine.isUnknownObjectType(ao.getObjType())) {
                mgr.add((IAction)new DummyAction(ao.getDisplayName(), Images.getObjectIcon(ao.getObjType(), true, ao.getServerId())));
                mgr.add((IContributionItem)new Separator());
            }
            MenuUtil.addObjectContextMenu(mgr, win, (AgentObject)selObject);
        } else if (selObject instanceof ServerObject) {
            int serverId = ((ServerObject)selObject).getId();
            Server server = ServerManager.getInstance().getServer(serverId);
            boolean isOpen = server.isOpen();
            if (isOpen) {
                CounterEngine counterEngine = server.getCounterEngine();
                mgr.add((IAction)new DummyAction(server.getName(), Images.server));
                mgr.add((IContributionItem)new Separator());
                Map<String, Action> counterActionsMap = counterActions.get(serverId);
                if (counterActionsMap == null) {
                    counterActionsMap = MenuUtil.getCounterActionList(win, counterEngine, serverId);
                    if (counterActionsMap == null) {
                        return;
                    }
                    counterActions.put(serverId, counterActionsMap);
                }
                this.addExistObjectTypeMenus(win, mgr, counterEngine, counterActionsMap, serverId);
                if (server.isEnableMenu("tag_count")) {
                    mgr.add((IContributionItem)new Separator());
                    mgr.add((IAction)new OpenTagCountViewAction(win, serverId));
                }
                mgr.add((IContributionItem)new Separator());
                mgr.add((IAction)new OpenTotalSummaryAction(win, serverId));
                mgr.add((IAction)new OpenAlertDetailListAction(win, serverId));
                mgr.add((IContributionItem)new Separator());
                if (server.isAllowAction("AllowConfigure")) {
                    MenuManager configMenuManager = new MenuManager("Configures", ImageUtil.getImageDescriptor(Images.config), "scouter.client.contextmenu.server.configures");
                    mgr.add((IContributionItem)configMenuManager);
                    configMenuManager.add((IAction)new OpenServerConfigureAction(win, "Configure", Images.config, serverId));
                    MenuManager telegrafMenuManager = new MenuManager("Telegraf Config", ImageUtil.getImageDescriptor(Images.config), "scouter.client.contextmenu.server.telegraf.configure");
                    configMenuManager.add((IContributionItem)telegrafMenuManager);
                    telegrafMenuManager.add((IAction)new OpenTelegrafConfigureAction(win, "Telegraf Configure", serverId));
                    telegrafMenuManager.add((IAction)new OpenTelegrafFileConfigureAction(win, "Edit telegraf file directly", serverId));
                    configMenuManager.add((IAction)new OpenCountersSiteFileConfigureAction(win, "Edit counters.site.xml file", serverId));
                }
                MenuManager alertMenuManager = new MenuManager("Customizable Alert", ImageUtil.getImageDescriptor(Images.alert), "scouter.client.alertScripting");
                mgr.add((IContributionItem)alertMenuManager);
                TreeMap alertMenuMap = new TreeMap();
                AgentObject[] agentObjectArray = AgentModelThread.getInstance().getObjectList();
                int n = agentObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AgentObject agentObject = agentObjectArray[n2];
                    if (agentObject.getServerId() == serverId) {
                        ObjectType objectType = counterEngine.getObjectType(agentObject.getObjType());
                        if (objectType == null) {
                            System.out.println("[Null Object Type]" + agentObject.getObjType());
                        } else if (!objectType.isSubObject()) {
                            Family family = objectType.getFamily();
                            if (family == null) {
                                System.out.println("[Null family Type]" + agentObject.getObjType());
                            } else {
                                List counterList = family.listCounters();
                                for (Counter counter : counterList) {
                                    if (!counter.isAll()) continue;
                                    HashMap<String, String> itemMap = new HashMap<String, String>();
                                    itemMap.put("familyName", family.getName());
                                    itemMap.put("counterName", counter.getName());
                                    itemMap.put("counterDisplayName", counter.getDisplayName());
                                    alertMenuMap.put(String.valueOf(family.getName()) + ":" + counter.getName(), itemMap);
                                }
                            }
                        }
                    }
                    ++n2;
                }
                for (Map.Entry entry : alertMenuMap.entrySet()) {
                    Map entryValue = (Map)entry.getValue();
                    alertMenuManager.add((IAction)new OpenAlertScriptingAction(win, (String)entry.getKey(), Images.alert, serverId, (String)entryValue.get("familyName"), (String)entryValue.get("counterName"), (String)entryValue.get("counterDisplayName")));
                }
                mgr.add((IAction)new OpenObjectDailyListAction(win, "Object Daily List", Images.GO_PAST, serverId));
                mgr.add((IContributionItem)new Separator());
                MenuManager management = new MenuManager("Management", "scouter.client.management");
                mgr.add((IContributionItem)management);
                management.add((IAction)new OpenCxtmenuEnvAction(win, "Env", 0, serverId));
                management.add((IAction)new OpenServerThreadListAction(win, "Server Thread List", Images.thread, serverId));
                if (server.isAllowAction("AllowLoginList")) {
                    management.add((IAction)new OpenLoginListAction(win, "Current Login List", Images.CONFIG_USER, serverId));
                }
                if (server.isAllowAction("AllowDBManager")) {
                    management.add((IAction)new OpenServerFileManagementAction(win, "File Management", Images.explorer, serverId));
                }
                management.add((IAction)new OpenServerLogsAction(win, serverId));
                MenuManager userMenu = new MenuManager("Account", ImageUtil.getImageDescriptor(Images.CONFIG_USER), "scouter.client.account");
                management.add((IContributionItem)userMenu);
                userMenu.add((IAction)new ListAccountAction(win, serverId));
                userMenu.add((IAction)new OpenGroupPolicyAction(win, serverId));
                userMenu.add((IContributionItem)new Separator());
                if (server.isAllowAction("AllowAddAccount")) {
                    userMenu.add((IAction)new AddAccountAction(win, serverId));
                }
                if (server.isAllowAction("AllowEditAccount")) {
                    userMenu.add((IAction)new EditAccountAction(win, serverId));
                }
                mgr.add((IContributionItem)new Separator());
                if (ServerManager.getInstance().getOpenServerList().size() > 1) {
                    if (server != ServerManager.getInstance().getDefaultServer() && server.isConnected()) {
                        mgr.add((IAction)new SetDefaultServerAction(win, server));
                    }
                    mgr.add((IAction)new CloseServerAction(win, serverId));
                    mgr.add((IAction)new RemoveServerAction(win, serverId));
                }
                mgr.add((IContributionItem)new Separator());
                mgr.add((IAction)new OpenCxtmenuServerPropertiesAction(win, "Properties", serverId));
            } else {
                mgr.add((IAction)new OpenServerAction(serverId));
                mgr.add((IAction)new RemoveServerAction(win, serverId));
            }
        } else if (selObject instanceof GroupObject) {
            GroupObject obj = (GroupObject)selObject;
            HierarchyObject parent = obj.getParent();
            if (parent == null || !(parent instanceof ServerObject)) {
                return;
            }
            int serverId = ((ServerObject)parent).getId();
            CounterEngine counterEngine = ServerManager.getInstance().getServer(serverId).getCounterEngine();
            Map<String, Action> counterActionsMap = counterActions.get(serverId);
            if (counterActionsMap == null) {
                counterActionsMap = MenuUtil.getCounterActionList(win, counterEngine, serverId);
                if (counterActionsMap == null) {
                    return;
                }
                counterActions.put(serverId, counterActionsMap);
            }
            this.addObjectTypeMenu(mgr, counterEngine, counterActionsMap, serverId, obj.getObjType());
        } else {
            mgr.removeAll();
        }
    }

    private void addExistObjectTypeMenus(IWorkbenchWindow win, IMenuManager mgr, CounterEngine counterEngine, Map<String, Action> actionMap, int serverId) {
        Set<String> agentTypeList = this.agentThread.getCurrentObjectTypeList(serverId);
        ArrayList<ObjectType> objTypeList = new ArrayList<ObjectType>();
        for (String objType : agentTypeList) {
            ObjectType type = counterEngine.getObjectType(objType);
            if (type == null) continue;
            objTypeList.add(type);
        }
        Collections.sort(objTypeList, new Comparator<ObjectType>(){

            @Override
            public int compare(ObjectType o1, ObjectType o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        for (ObjectType type : objTypeList) {
            String objType = type.getName();
            String displayName = type.getDisplayName();
            ImageDescriptor objImage = Images.getObjectImageDescriptor(objType, true, serverId);
            MenuManager objTitle = new MenuManager(displayName, objImage, "scouter.menu.id." + displayName);
            mgr.add((IContributionItem)objTitle);
            this.addObjectTypeMenu((IMenuManager)objTitle, counterEngine, actionMap, serverId, objType);
            MenuUtil.addObjTypeSpecialMenu(win, (IMenuManager)objTitle, serverId, objType, counterEngine);
        }
    }

    private void addObjectTypeMenu(IMenuManager objTitle, CounterEngine counterEngine, Map<String, Action> actionMap, int serverId, String objType) {
        ArrayList counters = counterEngine.getAllCounterWithDisplay(objType);
        int i = 0;
        while (counters != null && i < counters.size()) {
            String[] cnt = ((String)counters.get(i)).split(":");
            String counter = cnt[1];
            Action realtimeAllAct = actionMap.get(String.valueOf(objType) + ":" + counter);
            if (realtimeAllAct != null) {
                objTitle.add((IAction)realtimeAllAct);
            }
            ++i;
        }
    }

    private static void removeActionCache(int serverId) {
        counterActions.remove(serverId);
    }

    public void setFocus() {
        this.objTreeViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.shutdown();
            this.thread = null;
        }
    }

    private void getObjectList() {
        AgentObject[] agentList = this.agentThread.getObjectList();
        this.objectList = new ArrayList<AgentObject>(Arrays.asList(agentList));
    }

    private synchronized void makeHierarchyMap() {
        TreeMap<String, ServerObject> tempRootMap = new TreeMap<String, ServerObject>();
        Enumeration<Integer> sIds = ServerManager.getInstance().getAllServerList();
        while (sIds.hasMoreElements()) {
            int serverId = sIds.nextElement();
            Server server = ServerManager.getInstance().getServer(serverId);
            ServerObject serverObj = new ServerObject(serverId, server.getName());
            if (server.isOpen()) {
                serverObj.setTotalMemory(server.getTotalMemory());
                serverObj.setUsedMemory(server.getUsedMemory());
            }
            tempRootMap.put(server.getName(), serverObj);
        }
        this.getObjectList();
        for (AgentObject agent : this.objectList) {
            ServerObject serverObj;
            if (agent.getObjType().startsWith("z$")) {
                System.out.println("agent: " + agent);
            }
            int serverId = agent.getServerId();
            Server server = ServerManager.getInstance().getServer(serverId);
            if (server == null || (serverObj = (ServerObject)tempRootMap.get(server.getName())) == null) continue;
            String objName = agent.getObjName();
            HierarchyObject parent = serverObj;
            int inx = objName.indexOf("/", 1);
            while (inx != -1) {
                String childName = objName.substring(0, inx);
                HierarchyObject child = parent.getChild(childName);
                if (child == null) {
                    child = new DummyObject(childName);
                    child.setParent(parent);
                    parent.putChild(childName, child);
                }
                parent = child;
                inx = objName.indexOf("/", inx + 1);
            }
            HierarchyObject beforeDummyObj = parent.putChild(objName, agent);
            if (beforeDummyObj != null && beforeDummyObj instanceof DummyObject) {
                agent.setChildMap(((DummyObject)beforeDummyObj).getChildMap());
            }
            agent.setParent(parent);
        }
        this.root.clear();
        this.root.putAll(tempRootMap);
    }

    private synchronized void makeFlatMap() {
        HashMap<String, ServerObject> tempRootMap = new HashMap<String, ServerObject>();
        Enumeration<Integer> sIds = ServerManager.getInstance().getAllServerList();
        while (sIds.hasMoreElements()) {
            int serverId = sIds.nextElement();
            Server server = ServerManager.getInstance().getServer(serverId);
            ServerObject serverObj = new ServerObject(serverId, server.getName());
            if (server.isOpen()) {
                serverObj.setTotalMemory(server.getTotalMemory());
                serverObj.setUsedMemory(server.getUsedMemory());
            }
            tempRootMap.put(server.getName(), serverObj);
        }
        this.getObjectList();
        for (AgentObject agent : this.objectList) {
            ServerObject serverObj;
            int serverId = agent.getServerId();
            Server server = ServerManager.getInstance().getServer(serverId);
            if (server == null || (serverObj = (ServerObject)tempRootMap.get(server.getName())) == null) continue;
            String objType = agent.getObjType();
            HierarchyObject grpObj = serverObj.getChild(objType);
            if (grpObj == null) {
                GroupObject objTypeObj = new GroupObject(objType, String.valueOf(server.getName()) + "/" + server.getCounterEngine().getDisplayNameObjectType(objType));
                serverObj.putChild(objType, objTypeObj);
                objTypeObj.setParent(serverObj);
                grpObj = objTypeObj;
            }
            grpObj.putChild(agent.getObjName(), agent);
            agent.setParent(grpObj);
        }
        this.root.clear();
        this.root.putAll(tempRootMap);
    }

    public static void main(String[] args) {
        String s = "/ab/bc/cd";
        int inx = s.indexOf("/", 1);
        while (inx != -1) {
            System.out.println(s.substring(0, inx));
            inx = s.indexOf("/", inx + 1);
        }
        System.out.println(s);
    }

    static enum PresentMode {
        HIERACHY_MODE,
        FLAT_MODE;

    }

    class TableLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object obj, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (obj instanceof AgentObject) {
                        AgentObject a = (AgentObject)obj;
                        if (ObjectNavigationView.this.mode == PresentMode.HIERACHY_MODE) {
                            return Images.getObjectIcon(a.getObjType(), a.isAlive(), a.getServerId());
                        }
                        if (ObjectNavigationView.this.mode == PresentMode.FLAT_MODE) {
                            return a.isAlive() ? Images.active : Images.dead;
                        }
                    } else {
                        if (obj instanceof ServerObject) {
                            ServerObject a = (ServerObject)obj;
                            Server server = ServerManager.getInstance().getServer(a.getId());
                            boolean isOpen = server.isOpen();
                            if (isOpen) {
                                boolean isConnected = server.isConnected();
                                if (ServerManager.getInstance().getDefaultServer() == server) {
                                    if (isConnected) {
                                        return Images.SERVER_DEFAULT_ACT;
                                    }
                                    return Images.SERVER_DEFAULT_INACT;
                                }
                                if (isConnected) {
                                    return Images.SERVER_ACT;
                                }
                                return Images.SERVER_INACT;
                            }
                            return Images.close_folder;
                        }
                        if (obj instanceof GroupObject) {
                            GroupObject grpObj = (GroupObject)obj;
                            HierarchyObject parent = grpObj.getParent();
                            if (parent != null && parent instanceof ServerObject) {
                                return Images.getObjectIcon(grpObj.getObjType(), true, ((ServerObject)parent).getId());
                            }
                            return Images.getObjectIcon(grpObj.getObjType(), true, 0);
                        }
                        if (obj instanceof DummyObject) {
                            DummyObject dummyObj = (DummyObject)obj;
                            if (dummyObj.getChildSize() > 0) {
                                return Images.folder;
                            }
                            return Images.default_context;
                        }
                    }
                    return Images.default_context;
                }
                case 1: {
                    boolean activeStack;
                    AgentObject a;
                    if (!(obj instanceof AgentObject) || !(a = (AgentObject)obj).isAlive() || !(activeStack = a.getSpec().tags.getBoolean("ActiveStack"))) break;
                    return Images.active;
                }
            }
            return null;
        }

        public String getColumnText(Object obj, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (obj instanceof AgentObject) {
                        AgentObject a = (AgentObject)obj;
                        String display = "";
                        if (ObjectNavigationView.this.mode == PresentMode.HIERACHY_MODE) {
                            display = String.valueOf(display) + a.getDisplayName();
                        } else if (ObjectNavigationView.this.mode == PresentMode.FLAT_MODE) {
                            display = String.valueOf(display) + a.getObjName();
                        }
                        return display;
                    }
                    if (obj instanceof ServerObject) {
                        ServerObject a = (ServerObject)obj;
                        return a.getDisplayName();
                    }
                    if (obj instanceof GroupObject) {
                        GroupObject a = (GroupObject)obj;
                        String name = a.getName();
                        int index = name.indexOf("/");
                        if (index > -1) {
                            return name.substring(index + 1, name.length());
                        }
                        return name;
                    }
                    if (obj instanceof DummyObject) {
                        DummyObject a = (DummyObject)obj;
                        return a.getDisplayName();
                    }
                    return obj.toString();
                }
                case 1: {
                    ServerObject o;
                    if (obj instanceof AgentObject) {
                        AgentObject a = (AgentObject)obj;
                        if (!a.isAlive()) break;
                        Value value = a.getMasterCounter();
                        if (value == null) {
                            return null;
                        }
                        Server server = ServerManager.getInstance().getServer(a.getServerId());
                        if (server == null) {
                            return "?";
                        }
                        return this.getColumnTextForByte(value, server.getCounterEngine().getMasterCounterUnit(a.getObjType()));
                    }
                    if (!(obj instanceof ServerObject) || (o = (ServerObject)obj).getUsedMemory() <= 0L) break;
                    return ScouterUtil.humanReadableByteCount(o.getUsedMemory(), true);
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getForeground(Object obj) {
            if (obj instanceof AgentObject) {
                AgentObject a = (AgentObject)obj;
                if (!a.isAlive()) {
                    return ColorUtil.getInstance().getColor("gray");
                }
                if (ObjectNavigationView.this.objSelMgr.isUnselectedObject(a.getObjHash())) {
                    return ColorUtil.getInstance().getColor(15);
                }
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public String getColumnTextForByte(Value value, String unit) {
            if (unit != null && "bytes".equals(unit)) {
                double v = CastUtil.cdouble((Object)value);
                return ScouterUtil.humanReadableByteCount(v, true);
            }
            return String.valueOf(FormatUtil.print((Object)value, (String)"#,###.##")) + " " + unit;
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof Map) {
                return ((Map)parent).values().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof HierarchyObject) {
                return ((HierarchyObject)parentElement).getSortedChildArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof HierarchyObject) {
                return ((HierarchyObject)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof HierarchyObject) {
                return ((HierarchyObject)element).getChildSize() > 0;
            }
            return false;
        }

        public boolean equals(Object obj) {
            return true;
        }
    }
}

