/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.AgentDataProxy;
import scouter.client.net.TcpProxy;
import scouter.client.popup.EditableMessageDialog;
import scouter.client.server.ServerManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.ColoringWord;
import scouter.client.util.CustomLineStyleListener;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.UIUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.DoubleValue;
import scouter.lang.value.FloatValue;
import scouter.lang.value.TextValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.FormatUtil;
import scouter.util.SortUtil;

public class ObjectThreadDetailView
extends ViewPart
implements UIUtil.ViewWithTable {
    public static final String ID = ObjectThreadDetailView.class.getName();
    private int objHash;
    private long threadid;
    private long txid;
    private int serverId;
    private ArrayList<ColoringWord> defaultHighlightings;
    CustomLineStyleListener listener;
    Button interruptBtn;
    Button stopBtn;
    Button resumeBtn;
    Button suspendBtn;
    protected Table table;
    protected StyledText stacktrace;
    boolean asc;
    int col_idx;
    boolean isNum;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = Integer.valueOf(ids[0]);
        this.objHash = Integer.valueOf(ids[1]);
    }

    public void initializeColoring() {
        this.defaultHighlightings = new ArrayList();
        this.defaultHighlightings.add(new ColoringWord("javax.servlet.http.HttpServlet", 9, false));
        this.defaultHighlightings.add(new ColoringWord("org.apache.jasper.servlet.JspServlet", 9, false));
        this.defaultHighlightings.add(new ColoringWord("java.lang.Thread.sleep", 3, false));
        this.defaultHighlightings.add(new ColoringWord("java.lang", 9, false));
        this.defaultHighlightings.add(new ColoringWord("java.util", 9, false));
    }

    public void createPartControl(final Composite parent) {
        this.initializeColoring();
        SashForm sashForm = new SashForm(parent, 512);
        sashForm.SASH_WIDTH = 1;
        Composite composite = new Composite((Composite)sashForm, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite upperComp = new Composite(composite, 0);
        upperComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        upperComp.setLayout((Layout)UIUtil.formLayout(3, 3));
        if (ServerManager.getInstance().getServer(this.serverId).isAllowAction("AllowKillTransaction")) {
            this.resumeBtn = new Button(upperComp, 8);
            this.resumeBtn.setText("&Resume");
            this.resumeBtn.setImage(Images.WARN);
            this.resumeBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, 100, -5, null, -1, 100));
            this.resumeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (MessageDialog.openConfirm((Shell)parent.getShell(), (String)"Resume Thread", (String)"This thread will be resumed.(This may result in throwing a SecurityException) Continue?")) {
                        ObjectThreadDetailView.this.controlThread("resume");
                    }
                }
            });
            this.suspendBtn = new Button(upperComp, 8);
            this.suspendBtn.setText("&Suspend");
            this.suspendBtn.setImage(Images.WARN);
            this.suspendBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, this.resumeBtn, -5, null, -1, 100));
            this.suspendBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (MessageDialog.openConfirm((Shell)parent.getShell(), (String)"Suspend Thread", (String)"This thread will be suspended.(This may result in throwing a SecurityException) Continue?")) {
                        ObjectThreadDetailView.this.controlThread("suspend");
                    }
                }
            });
            this.stopBtn = new Button(upperComp, 8);
            this.stopBtn.setText("&Stop");
            this.stopBtn.setImage(Images.WARN);
            this.stopBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, this.suspendBtn, -5, null, -1, 100));
            this.stopBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (MessageDialog.openConfirm((Shell)parent.getShell(), (String)"Stop Thread", (String)"This thread will be terminated.(This feature requires a pre-test) Continue?")) {
                        ObjectThreadDetailView.this.controlThread("stop");
                    }
                }
            });
            this.interruptBtn = new Button(upperComp, 8);
            this.interruptBtn.setText("&Interrupt");
            this.interruptBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, this.stopBtn, -5, null, -1, 100));
            this.interruptBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (MessageDialog.openConfirm((Shell)parent.getShell(), (String)"Interrupt Thread", (String)"This thread will be interrupted. Continue?")) {
                        ObjectThreadDetailView.this.controlThread("interrupt");
                    }
                }
            });
        }
        this.table = this.build(composite);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] items = ObjectThreadDetailView.this.table.getSelection();
                if (items == null || items.length < 1) {
                    return;
                }
                String key = items[0].getText(0);
                String content = items[0].getText(1);
                new EditableMessageDialog().show(key, content);
            }
        });
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    ObjectThreadDetailView.this.reload();
                }
            }
        });
        this.stacktrace = new StyledText((Composite)sashForm, 2818);
        this.stacktrace.setText("");
        this.stacktrace.setFont(new Font(null, "verdana", 10, 0));
        this.stacktrace.setMargins(10, 10, 10, 10);
        this.listener = new CustomLineStyleListener(false, this.defaultHighlightings, false);
        this.stacktrace.addLineStyleListener((LineStyleListener)this.listener);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ObjectThreadDetailView.this.reload();
            }
        });
    }

    public void setInput(long threadId, long txid) {
        this.threadid = threadId;
        this.txid = txid;
        if (threadId != 0L) {
            this.setPartName("Thread Detail[" + this.threadid + "]");
        } else {
            this.setPartName("Deferred Tx Detail[" + txid + "]");
        }
        this.table.removeAll();
        this.stacktrace.setText("");
        this.reload();
    }

    private Table build(Composite parent) {
        this.table = new Table(parent, 68352);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn[] cols = new TableColumn[9];
        cols[0] = UIUtil.create(this.table, 16384, "Key", cols.length, 0, true, 150, this);
        cols[1] = UIUtil.create(this.table, 0, "Value", cols.length, 1, true, 600, this);
        return this.table;
    }

    protected void reload() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack mp = AgentDataProxy.getThreadDetail(ObjectThreadDetailView.this.objHash, ObjectThreadDetailView.this.threadid, ObjectThreadDetailView.this.txid, ObjectThreadDetailView.this.serverId);
                ObjectThreadDetailView.this.setThreadDetailContens(mp);
            }
        });
    }

    private void setThreadDetailContens(final MapPack pack) {
        ExUtil.exec((Composite)this.table, new Runnable(){

            @Override
            public void run() {
                ObjectThreadDetailView.this.table.removeAll();
                ObjectThreadDetailView.this.stacktrace.setText("");
                int time = CastUtil.cint((Object)pack.get("Service Elapsed"));
                boolean serviceThread = false;
                String[] names = SortUtil.sort_string((Iterator)pack.keys(), (int)pack.size());
                int i = 0;
                int j = 0;
                while (i < names.length) {
                    String key = names[i];
                    Value value = pack.get(key);
                    if ("Stack Trace".equals(key)) {
                        ObjectThreadDetailView.this.stacktrace.setText(CastUtil.cString((Object)value));
                    } else {
                        String text = null;
                        TableItem ti = new TableItem(ObjectThreadDetailView.this.table, 0, j++);
                        if (value instanceof TextValue) {
                            text = CastUtil.cString((Object)value);
                            ti.setText(0, key);
                            ti.setText(1, text);
                        } else {
                            if (value instanceof DecimalValue) {
                                text = FormatUtil.print((Object)value, (String)"#,##0");
                            } else if (value instanceof DoubleValue || value instanceof FloatValue) {
                                text = FormatUtil.print((Object)value, (String)"#,##0.0##");
                            }
                            ti.setText(new String[]{key, text});
                        }
                        if (key.startsWith("Service")) {
                            if (time > 8000) {
                                ti.setForeground(ColorUtil.getInstance().getColor(3));
                            } else if (time > 3000) {
                                ti.setForeground(ColorUtil.getInstance().getColor(11));
                            } else {
                                ti.setForeground(ColorUtil.getInstance().getColor(9));
                            }
                            serviceThread = true;
                        }
                    }
                    ++i;
                }
                if (ObjectThreadDetailView.this.stopBtn != null && ObjectThreadDetailView.this.interruptBtn != null) {
                    ObjectThreadDetailView.this.stopBtn.setEnabled(serviceThread);
                    ObjectThreadDetailView.this.interruptBtn.setEnabled(serviceThread);
                    ObjectThreadDetailView.this.resumeBtn.setEnabled(serviceThread);
                    ObjectThreadDetailView.this.suspendBtn.setEnabled(serviceThread);
                }
                ObjectThreadDetailView.this.sortTable();
            }
        });
    }

    private void controlThread(final String action) {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack p;
                block6: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(ObjectThreadDetailView.this.serverId);
                    p = null;
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("objHash", (long)ObjectThreadDetailView.this.objHash);
                            param.put("id", ObjectThreadDetailView.this.threadid);
                            param.put("action", action);
                            p = (MapPack)tcp.getSingle("OBJECT_THREAD_CONTROL", (Pack)param);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (p != null) {
                    ObjectThreadDetailView.this.setThreadDetailContens(p);
                }
            }
        });
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    public void setSortCriteria(boolean asc, int col_idx, boolean isNum) {
        this.asc = asc;
        this.col_idx = col_idx;
        this.isNum = isNum;
    }

    @Override
    public void setTableItem(TableItem t) {
    }

    public void sortTable() {
        int col_count = this.table.getColumnCount();
        TableItem[] items = this.table.getItems();
        if (this.isNum) {
            new scouter.client.util.SortUtil(this.asc).sort_num(items, this.col_idx, col_count);
        } else {
            new scouter.client.util.SortUtil(this.asc).sort_str(items, this.col_idx, col_count);
        }
    }
}

