/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.stack.actions.FetchSingleStackJob;
import scouter.client.stack.base.MainProcessor;
import scouter.client.util.ColoringWord;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.CustomLineStyleListener;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.StringUtil;

public class ObjectThreadDumpView
extends ViewPart {
    public static final String ID = ObjectThreadDumpView.class.getName();
    private ArrayList<ColoringWord> defaultHighlightings;
    private StyledText text;
    private String objName;
    private int objHash;
    private int serverId;
    private boolean isTable = true;
    private Table table;
    private String indexFilename = null;
    Composite headerComp;
    Button findButton;
    Button analyzeBtn;
    Text searchText;
    Shell shell;
    boolean loaded = false;
    CustomLineStyleListener listener;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secondId = site.getSecondaryId();
        if (secondId != null) {
            String[] tokens = StringUtil.tokenizer((String)secondId, (String)"&");
            this.objHash = CastUtil.cint((Object)tokens[0]);
            this.isTable = false;
        }
        this.initializeColoring();
    }

    public void initializeColoring() {
        this.defaultHighlightings = new ArrayList();
        this.defaultHighlightings.add(new ColoringWord("java.lang.Thread.State:", 9, false));
        this.defaultHighlightings.add(new ColoringWord("Object.wait()", 9, false));
        this.defaultHighlightings.add(new ColoringWord("daemon", 9, false));
        this.defaultHighlightings.add(new ColoringWord("java.util", 9, false));
        this.defaultHighlightings.add(new ColoringWord("prio", 9, false));
        this.defaultHighlightings.add(new ColoringWord("org.apache", 9, false));
        this.defaultHighlightings.add(new ColoringWord("locked", 3, false));
        this.defaultHighlightings.add(new ColoringWord("java.lang.Thread.run", 6, false));
        this.defaultHighlightings.add(new ColoringWord("java.lang", 12, false));
        this.defaultHighlightings.add(new ColoringWord("waiting on", 4, false));
    }

    public void createUpperMenu(Composite composite) {
        this.headerComp = new Composite(composite, 0);
        this.headerComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.headerComp.setLayout((Layout)UIUtil.formLayout(0, 0));
        this.analyzeBtn = new Button(this.headerComp, 8);
        this.analyzeBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, 100, -5, null, -1));
        this.analyzeBtn.setText("SFA");
        this.analyzeBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        MainProcessor.instance().processStackContents(ObjectThreadDumpView.this.text.getText());
                    }
                }
            }
        });
        this.findButton = new Button(this.headerComp, 8);
        this.findButton.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, this.analyzeBtn, -3, null, -1));
        this.findButton.setText("Find");
        this.findButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        ObjectThreadDumpView.this.listener.setSearchString(ObjectThreadDumpView.this.searchText.getText());
                        ObjectThreadDumpView.this.text.redraw();
                    }
                }
            }
        });
        this.searchText = new Text(this.headerComp, 2048);
        this.searchText.setLayoutData((Object)UIUtil.formData(null, -1, 0, 5, this.findButton, -5, null, -1, 300));
        this.searchText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    ObjectThreadDumpView.this.listener.setSearchString(ObjectThreadDumpView.this.searchText.getText());
                    ObjectThreadDumpView.this.text.redraw();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public void createPartControl(final Composite parent) {
        this.shell = parent.getShell();
        parent.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Composite composite = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(1, true);
        gLayout.horizontalSpacing = 0;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        composite.setLayout((Layout)gLayout);
        this.createUpperMenu(composite);
        Composite textComposite = new Composite(composite, 0);
        textComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        textComposite.setLayout((Layout)new FillLayout());
        SashForm sashHoriForm = null;
        if (this.isTable) {
            sashHoriForm = new SashForm(textComposite, 256);
            sashHoriForm.SASH_WIDTH = 3;
            Composite tableComposite = new Composite((Composite)sashHoriForm, 0);
            this.table = new Table(tableComposite, 68098);
            this.table.setLinesVisible(true);
            this.table.setLayoutData((Object)new GridData(4, 4, true, true));
            this.table.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem[] items = ObjectThreadDumpView.this.table.getSelection();
                    if (items != null && items.length > 0) {
                        TableItem first = items[0];
                        TableItem tableItem = items[items.length - 1];
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.table.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    TableItem[] items = ObjectThreadDumpView.this.table.getSelection();
                    if (items == null) {
                        return;
                    }
                    if (ObjectThreadDumpView.this.serverId != 0) {
                        long from = (Long)items[0].getData();
                        new FetchSingleStackJob(ObjectThreadDumpView.this.serverId, ObjectThreadDumpView.this.objName, from, null, ObjectThreadDumpView.this).schedule(500L);
                    } else {
                        ObjectThreadDumpView.this.loadBatchStackContents((Long)items[0].getData(), Integer.parseInt(items[0].getText()));
                    }
                }
            });
            TableColumn indexColumn = new TableColumn(this.table, 0);
            TableColumn timeColumn = new TableColumn(this.table, 0);
            TableColumnLayout tableColumnLayout = new TableColumnLayout();
            tableColumnLayout.setColumnData((Widget)indexColumn, (ColumnLayoutData)new ColumnWeightData(20));
            tableColumnLayout.setColumnData((Widget)timeColumn, (ColumnLayoutData)new ColumnWeightData(80));
            tableComposite.setLayout((Layout)tableColumnLayout);
            this.text = new StyledText((Composite)sashHoriForm, 2818);
        } else {
            this.text = new StyledText(textComposite, 2818);
        }
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144) {
                    if (e.keyCode == 97) {
                        ObjectThreadDumpView.this.text.selectAll();
                    } else if (e.keyCode == 102) {
                        ObjectThreadDumpView.this.searchText.setFocus();
                        ObjectThreadDumpView.this.searchText.selectAll();
                    }
                }
            }
        });
        this.listener = new CustomLineStyleListener(false, this.defaultHighlightings, false, true, 7);
        this.text.addLineStyleListener((LineStyleListener)this.listener);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Copy", ImageUtil.getImageDescriptor(Images.copy)){

            public void run() {
                Clipboard clipboard = new Clipboard(Display.getDefault());
                clipboard.setContents(new Object[]{ObjectThreadDumpView.this.text.getText()}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
                MessageDialog.openInformation((Shell)parent.getShell(), (String)"Copied", (String)"Copy all contents to clipboard");
            }
        });
        if (sashHoriForm != null) {
            sashHoriForm.setWeights(new int[]{10, 40});
        }
    }

    public void setInput(int serverId) {
        this.serverId = serverId;
        this.setPartName("ThreadDump[" + TextProxy.object.getLoadText(DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(serverId)), this.objHash, serverId) + "]");
        this.load();
    }

    public void setInput(String stackText) {
        this.text.setText(stackText);
    }

    public void setInput(String stackText, String objName, int serverId, long stackTime, List<Long> list) {
        this.setPartName("ThreadDump[" + objName + " " + DateUtil.yyyymmdd((long)stackTime) + "]");
        this.objName = objName;
        this.serverId = serverId;
        this.text.setText(stackText);
        this.loadAgentStackList(list);
    }

    public void setInput(String objName, String filename, List<Long>[] lists) {
        this.setPartName("ThreadDump[" + objName + " " + DateUtil.yyyymmdd((long)lists[0].get(0)) + "]");
        this.objName = objName;
        this.indexFilename = filename;
        this.loadBatchStackList(lists);
        if (lists != null) {
            if (lists[1].size() == 1) {
                this.loadThreadDump(0L, 0);
            } else {
                this.loadThreadDump(0L, lists[1].get(1).intValue());
            }
        }
    }

    public void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack mpack;
                block7: {
                    mpack = null;
                    TcpProxy tcp = TcpProxy.getTcpProxy(ObjectThreadDumpView.this.serverId);
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("objHash", (long)ObjectThreadDumpView.this.objHash);
                            mpack = (MapPack)tcp.getSingle("OBJECT_THREAD_DUMP", (Pack)param);
                        }
                        catch (Exception e) {
                            ConsoleProxy.errorSafe(e.toString());
                            TcpProxy.putTcpProxy(tcp);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (mpack != null) {
                    String error = mpack.getText("error");
                    if (error != null) {
                        ConsoleProxy.errorSafe(error);
                    }
                    final ListValue lv = mpack.getList("threadDump");
                    ExUtil.exec((Composite)ObjectThreadDumpView.this.text, new Runnable(){

                        @Override
                        public void run() {
                            StringBuilder sb = new StringBuilder();
                            int i = 0;
                            while (i < lv.size()) {
                                sb.append(String.valueOf(lv.getString(i)) + "\n");
                                ++i;
                            }
                            (this).ObjectThreadDumpView.this.text.setText(sb.toString());
                        }
                    });
                }
            }
        });
    }

    private void loadAgentStackList(final List<Long> list) {
        if (list == null) {
            return;
        }
        ExUtil.exec((Composite)this.table, new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < list.size()) {
                    long value = (Long)list.get(i);
                    TableItem item = new TableItem(ObjectThreadDumpView.this.table, 0);
                    item.setText(0, String.valueOf(i + 1));
                    item.setText(1, DateUtil.format((long)value, (String)"yyyy-MM-dd HH:mm:ss"));
                    item.setData((Object)value);
                    ++i;
                }
            }
        });
    }

    private void loadBatchStackList(final List<Long>[] lists) {
        if (lists == null) {
            return;
        }
        if (this.table.getItemCount() > 0) {
            this.table.removeAll();
        }
        ExUtil.exec((Composite)this.table, new Runnable(){

            @Override
            public void run() {
                List time = lists[0];
                List position = lists[1];
                int i = 0;
                while (i < time.size()) {
                    TableItem item = new TableItem(ObjectThreadDumpView.this.table, 0);
                    item.setText(0, String.valueOf(i + 1));
                    item.setText(1, DateUtil.format((long)((Long)time.get(i)), (String)"yyyy-MM-dd HH:mm:ss"));
                    item.setData(position.get(i));
                    ++i;
                }
            }
        });
    }

    public void setFocus() {
    }

    private void loadThreadDump(long position, int length) {
        String contents;
        block17: {
            File stackFile = null;
            if (this.indexFilename == null) {
                return;
            }
            stackFile = new File(String.valueOf(this.indexFilename.substring(0, this.indexFilename.length() - 4)) + ".log");
            contents = "";
            RandomAccessFile afr = null;
            try {
                try {
                    int readSize;
                    if (length == 0) {
                        length = (int)(stackFile.length() - position);
                    }
                    afr = new RandomAccessFile(stackFile, "r");
                    afr.seek(position);
                    byte[] buffer = new byte[length];
                    int totalSize = 0;
                    while ((readSize = afr.read(buffer, totalSize, length - totalSize)) > 0) {
                        if ((totalSize += readSize) >= length) break;
                    }
                    contents = new String(buffer, "UTF-8");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (afr != null) {
                        try {
                            afr.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (afr != null) {
                    try {
                        afr.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (afr != null) {
                try {
                    afr.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.text.setText(contents);
    }

    private void loadBatchStackContents(long position, int index) {
        TableItem item = null;
        if (index < this.table.getItemCount()) {
            item = this.table.getItem(index);
        }
        int length = 0;
        if (item != null) {
            length = ((Long)item.getData()).intValue();
            length = (int)((long)length - position);
        }
        this.loadThreadDump(position, length);
    }
}

