/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.HashMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.AgentDataProxy;
import scouter.client.model.RefreshThread;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.SortUtil;
import scouter.client.util.UIUtil;
import scouter.client.views.ObjectThreadDetailView;
import scouter.lang.pack.MapPack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.FormatUtil;
import scouter.util.StringUtil;

public class ObjectThreadListView
extends ViewPart
implements RefreshThread.Refreshable,
UIUtil.ViewWithTable {
    public static final String ID = ObjectThreadListView.class.getName();
    private Table table = null;
    public int objHash;
    public int serverId;
    Action actAutoRefresh;
    Action actFilter;
    protected RefreshThread thread = null;
    Display display = null;
    boolean refresh = false;
    boolean asc;
    int col_idx;
    boolean isNum;
    public HashMap<Long, Long> prevCpuMap = new HashMap();

    public void createPartControl(Composite parent) {
        this.display = this.getSite().getShell().getDisplay();
        parent.setLayout((Layout)ChartUtil.gridlayout(1));
        Composite area2 = new Composite(parent, 0);
        area2.setLayout((Layout)ChartUtil.gridlayout(1));
        area2.setLayoutData((Object)new GridData(1808));
        this.table = this.build(area2);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    ObjectThreadListView.this.reload();
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] item = ObjectThreadListView.this.table.getSelection();
                if (item == null || item.length == 0) {
                    return;
                }
                long threadId = CastUtil.clong((Object)item[0].getText(0));
                try {
                    IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    ObjectThreadDetailView view = (ObjectThreadDetailView)win.getActivePage().showView(ObjectThreadDetailView.ID, String.valueOf(ObjectThreadListView.this.serverId) + "&" + ObjectThreadListView.this.objHash, 1);
                    view.setInput(threadId, 0L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ObjectThreadListView.this.reload();
            }
        });
        man.add((IContributionItem)new Separator());
        this.actAutoRefresh = new Action("Auto Refresh in 5 sec.", 2){

            public void run() {
                if (ObjectThreadListView.this.actAutoRefresh.isChecked()) {
                    ObjectThreadListView.this.reload();
                }
            }
        };
        this.actAutoRefresh.setImageDescriptor(ImageUtil.getImageDescriptor(Images.refresh_auto));
        man.add((IAction)this.actAutoRefresh);
    }

    public void setInput(int objHash, int serverId) {
        this.objHash = objHash;
        this.serverId = serverId;
        this.reload();
        if (this.thread == null) {
            this.thread = new RefreshThread(this, 5000);
            this.thread.start();
        }
        this.thread.setName(String.valueOf(this.toString()) + " - " + "objHash:" + objHash + ", serverId:" + serverId);
    }

    public void reload() {
        if (this.table == null) {
            return;
        }
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                final MapPack mpack = AgentDataProxy.getThreadList(ObjectThreadListView.this.objHash, ObjectThreadListView.this.serverId);
                if (mpack == null) {
                    ObjectThreadListView.this.refresh = true;
                    return;
                }
                ObjectThreadListView.this.refresh = false;
                ExUtil.exec((Composite)ObjectThreadListView.this.table, new Runnable(){

                    @Override
                    public void run() {
                        TableItem[] tItem = (this).ObjectThreadListView.this.table.getItems();
                        ListValue idLv = mpack.getList("id");
                        ListValue nameLv = mpack.getList("name");
                        ListValue statLv = mpack.getList("stat");
                        ListValue cpuLv = mpack.getList("cpu");
                        ListValue txidLv = mpack.getList("txid");
                        ListValue elapsedLv = mpack.getList("elapsed");
                        ListValue serviceLv = mpack.getList("service");
                        int rows = idLv == null ? 0 : idLv.size();
                        int i = 0;
                        while (i < rows) {
                            TableItem t = null;
                            t = tItem != null && tItem.length > 0 && i < tItem.length && tItem[i] != null ? tItem[i] : new TableItem((this).ObjectThreadListView.this.table, 0, i);
                            long threadId = idLv.getLong(i);
                            long cputime = cpuLv.getLong(i);
                            long delta = 0L;
                            Long prevCpu = (this).ObjectThreadListView.this.prevCpuMap.get(threadId);
                            if (prevCpu != null) {
                                delta = cputime - prevCpu;
                            }
                            (this).ObjectThreadListView.this.prevCpuMap.put(threadId, cputime);
                            String[] datas = new String[]{FormatUtil.print((Object)threadId, (String)"000"), CastUtil.cString((Object)nameLv.get(i)), CastUtil.cString((Object)statLv.get(i)), FormatUtil.print((Object)cputime, (String)"#,##0"), FormatUtil.print((Object)delta, (String)"#,##0"), CastUtil.cString((Object)txidLv.get(i)), FormatUtil.print((Object)elapsedLv.get(i), (String)"#,##0"), CastUtil.cString((Object)serviceLv.get(i))};
                            int inx = 0;
                            while (inx < datas.length) {
                                datas[inx] = StringUtil.trimToEmpty((String)datas[inx]);
                                ++inx;
                            }
                            t.setText(datas);
                            ++i;
                        }
                        ObjectThreadListView.this.sortTable();
                    }
                });
            }
        });
    }

    public void setColor(TableItem t) {
        if (StringUtil.isNotEmpty((String)t.getText(7))) {
            int time = CastUtil.cint((Object)StringUtil.strip((String)t.getText(6), (String)","));
            if (time > 8000) {
                t.setForeground(ColorUtil.getInstance().getColor(3));
            } else if (time > 3000) {
                t.setForeground(ColorUtil.getInstance().getColor(11));
            } else {
                t.setForeground(ColorUtil.getInstance().getColor(9));
            }
        } else {
            t.setForeground(ColorUtil.getInstance().getColor(2));
        }
    }

    private Table build(Composite parent) {
        TableColumn[] cols;
        Table table = new Table(parent, 68416);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        cols = new TableColumn[]{UIUtil.create(table, 0x1000000, "No", cols.length, 0, true, 40, this), UIUtil.create(table, 16384, "Name", cols.length, 1, false, 250, this), UIUtil.create(table, 0x1000000, "Stat", cols.length, 2, false, 100, this), UIUtil.create(table, 131072, "Cpu", cols.length, 3, true, 60, this), UIUtil.create(table, 131072, "\u0394 Cpu", cols.length, 4, true, 60, this), UIUtil.create(table, 16384, "Txid", cols.length, 5, false, 70, this), UIUtil.create(table, 131072, "Elapsed", cols.length, 6, true, 60, this), UIUtil.create(table, 16384, "Service Name", cols.length, 7, false, 200, this)};
        return table;
    }

    @Override
    public void setSortCriteria(boolean asc, int col_idx, boolean isNum) {
        this.asc = asc;
        this.col_idx = col_idx;
        this.isNum = isNum;
    }

    @Override
    public void setTableItem(TableItem t) {
        this.setColor(t);
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.shutdown();
            this.thread = null;
        }
    }

    @Override
    public void refresh() {
        if (this.refresh || this.actAutoRefresh.isChecked()) {
            this.reload();
        }
    }

    public void sortTable() {
        int col_count = this.table.getColumnCount();
        TableItem[] items = this.table.getItems();
        if (this.isNum) {
            new SortUtil(this.asc).sort_num(items, this.col_idx, col_count);
        } else {
            new SortUtil(this.asc).sort_str(items, this.col_idx, col_count);
        }
        int i = 0;
        while (i < items.length) {
            this.setColor(items[i]);
            ++i;
        }
    }
}

