/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.lang.counters.CounterEngine;

public class ScouterViewPart
extends ViewPart {
    public String titleName;
    public String desc = "";
    public String statusMessage = "";

    public void setViewTab(String objType, String counter, int serverId) throws Exception {
        this.setViewTab(objType, counter, serverId, true);
    }

    public void setViewTab(String objType, String counter, int serverId, boolean showDescription) throws Exception {
        String counterDisplay = "";
        String objectDisplay = "";
        Server server = ServerManager.getInstance().getServer(serverId);
        CounterEngine counterEngine = null;
        if (server != null && (counterEngine = server.getCounterEngine()) != null) {
            counterDisplay = counterEngine.getCounterDisplayName(objType, counter);
            objectDisplay = counterEngine.getDisplayNameObjectType(objType);
        }
        this.titleName = String.valueOf(counterDisplay) + " - " + objectDisplay;
        this.setPartName(this.titleName);
        this.setTitleImage(Images.getCounterImage(objType, counter, serverId));
        if (showDescription) {
            this.setContentDescription(this.desc);
        }
    }

    public void setDesc() {
        this.setContentDescription(this.desc);
    }

    public void setActive() {
        this.setTitleImage(Images.active);
    }

    public void setInactive() {
        this.setTitleImage(Images.inactive);
    }

    public void createPartControl(Composite parent) {
    }

    public void setFocus() {
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        slManager.setMessage(this.statusMessage);
    }
}

