/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.net.TcpProxy;
import scouter.client.server.ServerManager;
import scouter.client.sorter.TreeLabelSorter;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.ScouterUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.DateUtil;

public class ServerFileManagementView
extends ViewPart {
    public static final String ID = ServerFileManagementView.class.getName();
    public TreeViewer viewer;
    public Tree tree;
    Composite labelComp;
    Label totalLabel;
    private int serverId;
    Map<String, DirObject> dirMap = new TreeMap<String, DirObject>();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        if (secId != null) {
            this.serverId = Integer.parseInt(secId);
        }
    }

    public void createPartControl(Composite parent) {
        this.setPartName("DataManagement[" + ServerManager.getInstance().getServer(this.serverId).getName() + "]");
        parent.setLayout((Layout)new GridLayout(1, true));
        this.labelComp = new Composite(parent, 0);
        this.labelComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.labelComp.setLayout((Layout)new RowLayout());
        this.totalLabel = new Label(parent, 0);
        this.totalLabel.setText("                                                ");
        Composite treeComp = new Composite(parent, 2048);
        treeComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree = new Tree(treeComp, 66306);
        this.tree.setHeaderVisible(true);
        this.viewer = new TreeViewer(this.tree);
        this.tree.setLinesVisible(true);
        final TreeColumn nameColumn = new TreeColumn(this.tree, 16384);
        nameColumn.setAlignment(16384);
        nameColumn.setText("Name");
        nameColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeLabelSorter sorter = (TreeLabelSorter)ServerFileManagementView.this.viewer.getComparator();
                sorter.setColumn(nameColumn);
            }
        });
        final TreeColumn sizeColumn = new TreeColumn(this.tree, 131072);
        sizeColumn.setAlignment(131072);
        sizeColumn.setText("Size");
        sizeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeLabelSorter sorter = (TreeLabelSorter)ServerFileManagementView.this.viewer.getComparator();
                sorter.setColumn(sizeColumn);
            }
        });
        final TreeColumn timeColumn = new TreeColumn(this.tree, 0x1000000);
        timeColumn.setAlignment(0x1000000);
        timeColumn.setText("Last Modified");
        timeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeLabelSorter sorter = (TreeLabelSorter)ServerFileManagementView.this.viewer.getComparator();
                sorter.setColumn(timeColumn);
            }
        });
        TreeColumnLayout layout = new TreeColumnLayout();
        treeComp.setLayout((Layout)layout);
        layout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(30));
        layout.setColumnData((Widget)sizeColumn, (ColumnLayoutData)new ColumnWeightData(20));
        layout.setColumnData((Widget)timeColumn, (ColumnLayoutData)new ColumnWeightData(20));
        this.viewer.setContentProvider((IContentProvider)new DirContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LockLabelProvider());
        this.viewer.setComparator((ViewerComparator)new TreeLabelSorter(this.viewer).setCustomCompare(new TreeLabelSorter.ICustomCompare(){

            @Override
            public int doCompare(TreeColumn col, int index, Object o1, Object o2) {
                if (o1 instanceof DirObject && o2 instanceof DirObject) {
                    DirObject dirObj1 = (DirObject)o1;
                    DirObject dirObj2 = (DirObject)o2;
                    switch (index) {
                        case 0: {
                            return dirObj1.name.compareTo(dirObj2.name);
                        }
                        case 1: {
                            long gap = dirObj1.size - dirObj2.size;
                            if (gap > 0L) {
                                return 1;
                            }
                            if (gap < 0L) {
                                return -1;
                            }
                            return 0;
                        }
                        case 2: {
                            long gap = dirObj1.lastModified - dirObj2.lastModified;
                            if (gap > 0L) {
                                return 1;
                            }
                            if (gap < 0L) {
                                return -1;
                            }
                            return 0;
                        }
                    }
                }
                return 0;
            }
        }));
        this.viewer.setInput(this.dirMap);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Collapse All", ImageUtil.getImageDescriptor(Images.collapse)){

            public void run() {
                ServerFileManagementView.this.viewer.collapseAll();
            }
        });
        man.add((IContributionItem)new Separator());
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ServerFileManagementView.this.load();
            }
        });
        this.load();
        this.createContextMenu((Viewer)this.viewer, new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ServerFileManagementView.this.fillTreeViewerContextMenu(manager);
            }
        });
    }

    private void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                TcpProxy tcpProxy = TcpProxy.getTcpProxy(ServerFileManagementView.this.serverId);
                try {
                    MapPack pack = (MapPack)tcpProxy.getSingle("SERVER_DB_LIST", null);
                    if (pack == null) {
                        return;
                    }
                    try {
                        final long totalSize = pack.getLong("total");
                        final long freeSize = pack.getLong("free");
                        ListValue nameLv = pack.getList("name");
                        ListValue sizeLv = pack.getList("size");
                        ListValue lastModifiedLv = pack.getList("lastModified");
                        ServerFileManagementView.this.dirMap.clear();
                        HashMap<String, DirObject> tempMap = new HashMap<String, DirObject>();
                        int i = 0;
                        while (i < nameLv.size()) {
                            DirObject dirObj = new DirObject();
                            dirObj.name = nameLv.getString(i);
                            dirObj.size = sizeLv.getLong(i);
                            dirObj.lastModified = lastModifiedLv.getLong(i);
                            tempMap.put(dirObj.name, dirObj);
                            ++i;
                        }
                        for (String name : tempMap.keySet()) {
                            DirObject dirObj = (DirObject)tempMap.get(name);
                            int lastIndex = name.lastIndexOf("/");
                            if (lastIndex < 0) {
                                lastIndex = name.lastIndexOf("\\");
                            }
                            if (lastIndex > 1) {
                                String parentName = name.substring(0, lastIndex);
                                DirObject parentObj = (DirObject)tempMap.get(parentName);
                                parentObj.addChild(dirObj);
                                dirObj.parent = parentObj;
                                continue;
                            }
                            ServerFileManagementView.this.dirMap.put(name, dirObj);
                        }
                        ExUtil.exec(ServerFileManagementView.this.labelComp, new Runnable(){

                            @Override
                            public void run() {
                                StringBuffer sb = new StringBuffer();
                                sb.append("Size : ");
                                sb.append(ScouterUtil.humanReadableByteCount(totalSize, true));
                                if (freeSize > 0L) {
                                    sb.append(" / Available : ");
                                    sb.append(ScouterUtil.humanReadableByteCount(freeSize, true));
                                }
                                (this).ServerFileManagementView.this.totalLabel.setText(sb.toString());
                                (this).ServerFileManagementView.this.totalLabel.update();
                                (this).ServerFileManagementView.this.labelComp.layout(true, true);
                            }
                        });
                        ExUtil.exec((Composite)ServerFileManagementView.this.viewer.getTree(), new Runnable(){

                            @Override
                            public void run() {
                                (this).ServerFileManagementView.this.viewer.refresh();
                            }
                        });
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                    }
                }
                finally {
                    TcpProxy.putTcpProxy(tcpProxy);
                }
            }
        });
    }

    public void setFocus() {
    }

    private void createContextMenu(Viewer viewer, IMenuListener listener) {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(listener);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
    }

    private void fillTreeViewerContextMenu(IMenuManager mgr) {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object[] elements = sel.toArray();
            if (elements == null || elements.length < 1) {
                return;
            }
            DeleteAction action = new DeleteAction(elements);
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                try {
                    DirObject dirObj = (DirObject)obj;
                    if (dirObj.name.contains("00000000")) {
                        action.setEnabled(false);
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            mgr.add((IAction)action);
        }
    }

    public class DeleteAction
    extends Action {
        Object[] elements;

        public DeleteAction(Object[] elements) {
            super("&Delete");
            this.elements = elements;
        }

        public void run() {
            int length = this.elements.length;
            if (MessageDialog.openConfirm((Shell)ServerFileManagementView.this.getViewSite().getShell(), (String)"Permanently Delete", (String)(String.valueOf(length) + " directories are deleted permanently with subdirectories. Continue?"))) {
                new DeleteJob("Delete Files", this.elements).schedule();
            }
        }
    }

    public class DeleteJob
    extends Job {
        Object[] elements;

        public DeleteJob(String name, Object[] elements) {
            super(name);
            this.elements = elements;
        }

        protected IStatus run(IProgressMonitor monitor) {
            TcpProxy tcp = TcpProxy.getTcpProxy(ServerFileManagementView.this.serverId);
            try {
                try {
                    monitor.beginTask("Delete Server Files.....", -1);
                    MapPack param = new MapPack();
                    ListValue fileLv = param.newList("file");
                    int i = 0;
                    while (i < this.elements.length) {
                        if (this.elements[i] instanceof DirObject) {
                            DirObject obj = (DirObject)this.elements[i];
                            fileLv.add(obj.name);
                        }
                        ++i;
                    }
                    MapPack m = (MapPack)tcp.getSingle("SERVER_DB_DELETE", (Pack)param);
                    monitor.done();
                    int size = m.getInt("size");
                    ConsoleProxy.infoSafe(String.valueOf(size) + " directories is deleted.");
                    ServerFileManagementView.this.load();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
            return Status.OK_STATUS;
        }
    }

    class DirContentProvider
    implements ITreeContentProvider {
        DirContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                return ((Map)inputElement).values().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof DirObject && ((DirObject)parentElement).childList != null) {
                return ((DirObject)parentElement).childList.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof DirObject) {
                return ((DirObject)element).parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof DirObject) {
                return ((DirObject)element).childList != null;
            }
            return false;
        }
    }

    class DirObject {
        String name;
        long size;
        long lastModified;
        DirObject parent;
        List<DirObject> childList;

        DirObject() {
        }

        public void addChild(DirObject child) {
            if (this.childList == null) {
                this.childList = new ArrayList<DirObject>();
            }
            this.childList.add(child);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DirObject other = (DirObject)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        private ServerFileManagementView getOuterType() {
            return ServerFileManagementView.this;
        }
    }

    class LockLabelProvider
    implements ITableLabelProvider {
        LockLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof DirObject) {
                return Images.folder;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof DirObject) {
                DirObject obj = (DirObject)element;
                switch (columnIndex) {
                    case 0: {
                        int lastIndex = obj.name.lastIndexOf("/");
                        if (lastIndex < 0) {
                            lastIndex = obj.name.lastIndexOf("\\");
                        }
                        if (lastIndex > -1) {
                            return obj.name.substring(lastIndex + 1);
                        }
                        return obj.name;
                    }
                    case 1: {
                        return ScouterUtil.humanReadableByteCount(obj.size, true);
                    }
                    case 2: {
                        return DateUtil.format((long)obj.lastModified, (String)"yyyy-MM-dd HH:mm:ss");
                    }
                }
            }
            return null;
        }
    }
}

