/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.net.TcpProxy;
import scouter.client.server.ServerManager;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.views.WhiteBoardView;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.TextValue;
import scouter.lang.value.Value;
import scouter.util.DateUtil;

public class ServerLogsView
extends ViewPart {
    public static final String ID = ServerLogsView.class.getName();
    public TableViewer viewer;
    public Table table;
    private int serverId;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        if (secId != null) {
            this.serverId = Integer.parseInt(secId);
        }
    }

    public void createPartControl(Composite parent) {
        this.setPartName("Logs[" + ServerManager.getInstance().getServer(this.serverId).getName() + "]");
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite tableComp = new Composite(parent, 2048);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new Table(tableComp, 66304);
        this.table.setHeaderVisible(true);
        this.viewer = new TableViewer(this.table);
        this.table.setLinesVisible(true);
        final TableColumn nameColumn = new TableColumn(this.table, 16384);
        nameColumn.setAlignment(16384);
        nameColumn.setText("Name");
        nameColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)ServerLogsView.this.viewer.getComparator();
                sorter.setColumn(nameColumn);
            }
        });
        final TableColumn sizeColumn = new TableColumn(this.table, 131072);
        sizeColumn.setAlignment(131072);
        sizeColumn.setText("Size");
        sizeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)ServerLogsView.this.viewer.getComparator();
                sorter.setColumn(sizeColumn);
            }
        });
        final TableColumn timeColumn = new TableColumn(this.table, 0x1000000);
        timeColumn.setAlignment(0x1000000);
        timeColumn.setText("Last Modified");
        timeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)ServerLogsView.this.viewer.getComparator();
                sorter.setColumn(timeColumn);
            }
        });
        TableColumnLayout layout = new TableColumnLayout();
        tableComp.setLayout((Layout)layout);
        layout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(30));
        layout.setColumnData((Widget)sizeColumn, (ColumnLayoutData)new ColumnWeightData(20));
        layout.setColumnData((Widget)timeColumn, (ColumnLayoutData)new ColumnWeightData(20));
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.viewer).setCustomCompare(new ColumnLabelSorter.ICustomCompare(){

            @Override
            public int doCompare(TableColumn col, int index, Object o1, Object o2) {
                if (o1 instanceof LogFileObject && o2 instanceof LogFileObject) {
                    LogFileObject dirObj1 = (LogFileObject)o1;
                    LogFileObject dirObj2 = (LogFileObject)o2;
                    switch (index) {
                        case 0: {
                            return dirObj1.name.compareTo(dirObj2.name);
                        }
                        case 1: {
                            long gap = dirObj1.size - dirObj2.size;
                            if (gap > 0L) {
                                return 1;
                            }
                            if (gap < 0L) {
                                return -1;
                            }
                            return 0;
                        }
                        case 2: {
                            long gap = dirObj1.lastModified - dirObj2.lastModified;
                            if (gap > 0L) {
                                return 1;
                            }
                            if (gap < 0L) {
                                return -1;
                            }
                            return 0;
                        }
                    }
                }
                return 0;
            }
        }));
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ServerLogsView.this.load();
            }
        });
        this.createContextMenu((Viewer)this.viewer, new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ServerLogsView.this.fillTreeViewerContextMenu(manager);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object o;
                StructuredSelection sel = (StructuredSelection)ServerLogsView.this.viewer.getSelection();
                if (sel != null && (o = sel.getFirstElement()) instanceof LogFileObject) {
                    LogFileObject lfo = (LogFileObject)o;
                    new FileOpenJob(lfo.name).schedule();
                }
            }
        });
        this.load();
    }

    private void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                TcpProxy tcpProxy = TcpProxy.getTcpProxy(ServerLogsView.this.serverId);
                try {
                    MapPack pack = (MapPack)tcpProxy.getSingle("SERVER_LOG_LIST", null);
                    if (pack == null) {
                        ConsoleProxy.errorSafe("Cannot load logs");
                        return;
                    }
                    try {
                        final ArrayList<LogFileObject> fileList = new ArrayList<LogFileObject>();
                        ListValue nameLv = pack.getList("name");
                        ListValue sizeLv = pack.getList("size");
                        ListValue lastModifiedLv = pack.getList("lastModified");
                        int i = 0;
                        while (i < nameLv.size()) {
                            LogFileObject fileObj = new LogFileObject();
                            fileObj.name = nameLv.getString(i);
                            fileObj.size = sizeLv.getLong(i);
                            fileObj.lastModified = lastModifiedLv.getLong(i);
                            fileList.add(fileObj);
                            ++i;
                        }
                        ExUtil.exec((Composite)ServerLogsView.this.table, new Runnable(){

                            @Override
                            public void run() {
                                (this).ServerLogsView.this.viewer.setInput((Object)fileList);
                            }
                        });
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                    }
                }
                finally {
                    TcpProxy.putTcpProxy(tcpProxy);
                }
            }
        });
    }

    public void setFocus() {
    }

    private void createContextMenu(Viewer viewer, IMenuListener listener) {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(listener);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
    }

    private void fillTreeViewerContextMenu(IMenuManager mgr) {
        IStructuredSelection sel;
        Object obj;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && (obj = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof LogFileObject) {
            LogFileObject lfo = (LogFileObject)obj;
            OpenAction action = new OpenAction(lfo.name);
            mgr.add((IAction)action);
        }
    }

    class ContentProvider
    implements IStructuredContentProvider {
        List<LogFileObject> objList;

        ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.objList = (List)newInput;
        }

        public Object[] getElements(Object inputElement) {
            if (this.objList == null) {
                return null;
            }
            return this.objList.toArray(new LogFileObject[this.objList.size()]);
        }
    }

    public class FileOpenJob
    extends Job {
        String name;

        public FileOpenJob(String name) {
            super("Open Files");
            this.name = name;
        }

        protected IStatus run(IProgressMonitor monitor) {
            TcpProxy tcp = TcpProxy.getTcpProxy(ServerLogsView.this.serverId);
            try {
                try {
                    monitor.beginTask("Open " + this.name + "...", -1);
                    MapPack param = new MapPack();
                    param.put("name", this.name);
                    Value v = tcp.getSingleValue("SERVER_LOG_DETAIL", (Pack)param);
                    if (v != null && v.getValueType() == 50) {
                        final TextValue tv = (TextValue)v;
                        ExUtil.exec(Display.getDefault(), new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    WhiteBoardView view = (WhiteBoardView)ServerLogsView.this.getSite().getWorkbenchWindow().getActivePage().showView(WhiteBoardView.ID);
                                    if (view != null) {
                                        view.setInput(FileOpenJob.this.name, tv.value);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                    monitor.done();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
            return Status.OK_STATUS;
        }
    }

    class LabelProvider
    implements ITableLabelProvider {
        LabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof LogFileObject) {
                LogFileObject obj = (LogFileObject)element;
                switch (columnIndex) {
                    case 0: {
                        return obj.name;
                    }
                    case 1: {
                        return ScouterUtil.humanReadableByteCount(obj.size, true);
                    }
                    case 2: {
                        return DateUtil.format((long)obj.lastModified, (String)"yyyy-MM-dd HH:mm:ss");
                    }
                }
            }
            return null;
        }
    }

    class LogFileObject {
        String name;
        long size;
        long lastModified;

        LogFileObject() {
        }
    }

    public class OpenAction
    extends Action {
        String name;

        public OpenAction(String name) {
            super("&Open");
            this.name = name;
        }

        public void run() {
            new FileOpenJob(this.name).schedule();
        }
    }
}

