/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.StringUtil;

public class ServerStatusView
extends ViewPart {
    public static final String ID = ServerStatusView.class.getName();
    private int objHash;
    private int serverId;
    Browser browser;
    Shell shell;
    boolean loaded = false;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secondId = site.getSecondaryId();
        if (secondId != null) {
            String[] tokens = StringUtil.tokenizer((String)secondId, (String)"&");
            this.objHash = CastUtil.cint((Object)tokens[0]);
        }
    }

    public void createPartControl(Composite parent) {
        this.shell = parent.getShell();
        Composite composite = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(1, true);
        gLayout.horizontalSpacing = 0;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        composite.setLayout((Layout)gLayout);
        Composite textComposite = new Composite(composite, 0);
        textComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        textComposite.setLayout((Layout)new FillLayout());
        this.browser = new Browser(textComposite, 2048);
    }

    public void setInput(int serverId) {
        this.serverId = serverId;
        this.setPartName("Server Status[" + TextProxy.object.getLoadText(DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(serverId)), this.objHash, serverId) + "]");
        this.load();
    }

    public void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack mpack;
                block7: {
                    mpack = null;
                    TcpProxy tcp = TcpProxy.getTcpProxy(ServerStatusView.this.serverId);
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("objHash", (long)ServerStatusView.this.objHash);
                            mpack = (MapPack)tcp.getSingle("APACHE_SERVER_STATUS", (Pack)param);
                        }
                        catch (Exception e) {
                            ConsoleProxy.errorSafe(e.toString());
                            TcpProxy.putTcpProxy(tcp);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (mpack != null) {
                    String error = mpack.getText("error");
                    if (error != null) {
                        ConsoleProxy.errorSafe(error);
                    }
                    final ListValue lv = mpack.getList("serverStatus");
                    ExUtil.exec((Composite)ServerStatusView.this.browser, new Runnable(){

                        @Override
                        public void run() {
                            StringBuilder sb = new StringBuilder();
                            int i = 0;
                            while (i < lv.size()) {
                                sb.append(lv.getString(i));
                                ++i;
                            }
                            (this).ServerStatusView.this.browser.setText(sb.toString());
                        }
                    });
                }
            }
        });
    }

    public void setFocus() {
    }
}

