/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.ServerDataProxy;
import scouter.client.util.ChartUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.SortUtil;
import scouter.client.util.TableControlAdapter;
import scouter.client.util.UIUtil;
import scouter.client.views.ServerThreadDetailView;
import scouter.lang.pack.MapPack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.FormatUtil;

public class ServerThreadListView
extends ViewPart
implements UIUtil.ViewWithTable {
    public static final String ID = ServerThreadListView.class.getName();
    private Table table = null;
    private int serverId;
    IToolBarManager man;
    TableColumn[] cols;
    boolean asc;
    int col_idx;
    boolean isNum;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)ChartUtil.gridlayout(1));
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)ChartUtil.gridlayout(1));
        comp.setLayoutData((Object)new GridData(1808));
        this.table = this.build(comp);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    ServerThreadListView.this.reload();
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] item = ServerThreadListView.this.table.getSelection();
                if (item == null || item.length == 0) {
                    return;
                }
                long threadId = CastUtil.clong((Object)item[0].getText(0));
                try {
                    IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    ServerThreadDetailView view = (ServerThreadDetailView)win.getActivePage().showView(ServerThreadDetailView.ID, "" + threadId, 1);
                    view.setInput("[" + threadId + "]", threadId, ServerThreadListView.this.serverId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.man = this.getViewSite().getActionBars().getToolBarManager();
        this.man.add((IAction)new Action("reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ServerThreadListView.this.reload();
            }
        });
        comp.addControlListener((ControlListener)new TableControlAdapter(this.table, this.cols, new int[]{20, -1, 10, 10}));
    }

    public void setInput(int serverId) {
        this.serverId = serverId;
        ExUtil.exec(new Runnable(){

            @Override
            public void run() {
                ServerThreadListView.this.reload();
            }
        });
    }

    public void reload() {
        if (this.table == null) {
            return;
        }
        this.table.removeAll();
        MapPack mpack = ServerDataProxy.getThreadList(this.serverId);
        ListValue idLv = mpack.getList("id");
        ListValue nameLv = mpack.getList("name");
        ListValue statLv = mpack.getList("stat");
        ListValue cpuLv = mpack.getList("cpu");
        int rows = idLv == null ? 0 : idLv.size();
        int i = 0;
        while (i < rows) {
            TableItem t = new TableItem(this.table, 0, i);
            t.setText(new String[]{FormatUtil.print((Object)idLv.get(i), (String)"000"), CastUtil.cString((Object)nameLv.get(i)), CastUtil.cString((Object)statLv.get(i)), FormatUtil.print((Object)cpuLv.get(i), (String)"#,##0")});
            ++i;
        }
        this.sortTable();
    }

    private Table build(Composite parent) {
        Table table = new Table(parent, 68416);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.cols = new TableColumn[4];
        this.cols[0] = UIUtil.create(table, 0x1000000, "No", this.cols.length, 0, true, 40, this);
        this.cols[1] = UIUtil.create(table, 16384, "Name", this.cols.length, 1, false, 250, this);
        this.cols[2] = UIUtil.create(table, 0x1000000, "Stat", this.cols.length, 2, false, 100, this);
        this.cols[3] = UIUtil.create(table, 131072, "Cpu", this.cols.length, 3, true, 60, this);
        return table;
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    public void setSortCriteria(boolean asc, int col_idx, boolean isNum) {
        this.asc = asc;
        this.col_idx = col_idx;
        this.isNum = isNum;
    }

    @Override
    public void setTableItem(TableItem t) {
    }

    public void sortTable() {
        int col_count = this.table.getColumnCount();
        TableItem[] items = this.table.getItems();
        if (this.isNum) {
            new SortUtil(this.asc).sort_num(items, this.col_idx, col_count);
        } else {
            new SortUtil(this.asc).sort_str(items, this.col_idx, col_count);
        }
    }
}

