/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.TimeUtil;
import scouter.client.views.AbstractServiceGroupTPSView;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;

public class ServiceGroupTPSView
extends AbstractServiceGroupTPSView {
    public static final String ID = ServiceGroupTPSView.class.getName();
    int serverId;
    String objType;
    String displayObjType;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = Integer.valueOf(ids[0]);
        this.objType = ids[1];
    }

    @Override
    public void createPartControl(Composite parent) {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        if (server != null) {
            this.displayObjType = server.getCounterEngine().getDisplayNameObjectType(this.objType);
        }
        this.setPartName("Service[Throughput] - " + this.displayObjType);
        super.createPartControl(parent);
    }

    @Override
    public MapPack fetch() {
        Pack pack;
        block7: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            pack = null;
            try {
                try {
                    MapPack param = new MapPack();
                    ListValue objLv = param.newList("objHash");
                    Map<Integer, AgentObject> agentMap = AgentModelThread.getInstance().getAgentObjectMap();
                    for (AgentObject p : agentMap.values()) {
                        if (!p.getObjType().equals(this.objType)) continue;
                        objLv.add((long)p.getObjHash());
                    }
                    pack = tcp.getSingle("REALTIME_SERVICE_GROUP", (Pack)param);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        MapPack m = null;
        if (pack != null) {
            m = (MapPack)pack;
            long time = TimeUtil.getCurrentTime(this.serverId);
            m.put("time", time);
        }
        return m;
    }
}

