/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.csstudio.swt.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.part.ViewPart;
import scouter.client.context.actions.OpenCxtmenuActiveServiceListAction;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.model.RefreshThread;
import scouter.client.threads.ObjectSelectManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.client.xlog.views.XLogViewPainter;

public abstract class VerticalEQCommonView
extends ViewPart
implements RefreshThread.Refreshable {
    private static final int MARGIN = 10;
    private static final int BAR_HEIGHT = 7;
    private static final int BAR_PADDING_WIDTH = 2;
    private static final int AXIS_PADDING = 16;
    private static final int REFRESH_INTERVAL = 200;
    private static final int FETCH_INTERVAL = 2000;
    public static double CYCLE_INTERVAL = 1000.0;
    private static int MINIMUM_UNIT_WIDTH = 20;
    protected RefreshThread thread;
    protected Canvas canvas;
    private long lastFetchedTime;
    protected Set<EqData> valueSet = new TreeSet<EqData>(new EqDataComparator());
    private int unitWidth;
    private Image ibuffer;
    private ScrolledComposite scroll;
    int winXSize;
    Rectangle area;
    static Font verdana12Bold = new Font(null, "Verdana", 12, 1);
    static Font verdana10Bold = new Font(null, "Verdana", 10, 0);
    static Font verdana10Italic = new Font(null, "Verdana", 10, 2);
    static Font verdana7 = new Font(null, "Verdana", 7, 0);
    long lastDrawTime;
    boolean onGoing = false;
    int size;
    EqData[] datas;
    ObjectSelectManager objSelMgr = ObjectSelectManager.getInstance();
    static Color black = ColorUtil.getInstance().getColor(2);
    static Color red = ColorUtil.getInstance().getColor(3);
    static Color dark_gary = ColorUtil.getInstance().getColor(15);
    private Map<String, Image> objectNameImageMap = new HashMap<String, Image>();

    public void createPartControl(final Composite parent) {
        parent.setBackground(ColorUtil.getInstance().getColor(1));
        parent.setBackgroundMode(2);
        parent.setLayout((Layout)UIUtil.formLayout(0, 0));
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        this.scroll = new ScrolledComposite(parent, 768);
        this.scroll.setLayoutData((Object)UIUtil.formData(0, 0, 0, 0, 100, 0, 100, 0));
        this.canvas = new Canvas((Composite)this.scroll, 0x20000000);
        this.canvas.setLayout((Layout)layout);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                try {
                    VerticalEQCommonView.this.area = VerticalEQCommonView.this.canvas.getClientArea();
                    VerticalEQCommonView.this.winXSize = parent.getSize().x;
                    VerticalEQCommonView.this.drawEQImage(e.gc);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (VerticalEQCommonView.this.unitWidth == 0 || VerticalEQCommonView.this.datas == null) {
                    return;
                }
                if (e.x <= 16) {
                    return;
                }
                int index = (e.x - 16) / VerticalEQCommonView.this.unitWidth;
                if (VerticalEQCommonView.this.datas.length < index + 1 || !VerticalEQCommonView.this.datas[index].isAlive) {
                    return;
                }
                AgentObject agent = AgentModelThread.getInstance().getAgentObject(VerticalEQCommonView.this.datas[index].objHash);
                new OpenCxtmenuActiveServiceListAction(VerticalEQCommonView.this.getSite().getWorkbenchWindow(), "Active Service List", VerticalEQCommonView.this.datas[index].objHash, agent.getObjType(), agent.getServerId()).run();
            }
        });
        this.scroll.setContent((Control)this.canvas);
        this.scroll.setExpandVertical(true);
        this.scroll.setExpandHorizontal(true);
        this.scroll.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                Point origin = VerticalEQCommonView.this.scroll.getOrigin();
                origin.y += event.count * -1 * 10;
                VerticalEQCommonView.this.scroll.setOrigin(origin);
            }
        });
        this.thread = new RefreshThread(this, 200);
        this.thread.start();
    }

    private void drawEQImage(GC gc) {
        if (this.ibuffer != null) {
            if (16 + MINIMUM_UNIT_WIDTH * this.size > this.winXSize) {
                this.scroll.setMinSize(this.canvas.computeSize(16 + MINIMUM_UNIT_WIDTH * this.size, -1));
            } else {
                this.scroll.setMinSize(this.canvas.computeSize(this.winXSize, -1));
            }
            if (!this.ibuffer.isDisposed()) {
                gc.drawImage(this.ibuffer, 0, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildBars() {
        long now = TimeUtil.getCurrentTime();
        if (now - this.lastDrawTime < 200L || this.area == null) {
            return;
        }
        if (this.onGoing) {
            return;
        }
        this.onGoing = true;
        int width = this.area.width > 100 ? this.area.width : 100;
        int height = this.area.height > 50 ? this.area.height : 50;
        Image img = new Image(null, width, height);
        GC gc = new GC((Drawable)img);
        try {
            this.lastDrawTime = now;
            double maxValue = 0.0;
            ArrayList<EqData> list = new ArrayList<EqData>();
            Set<EqData> set = this.valueSet;
            synchronized (set) {
                for (EqData e : this.valueSet) {
                    if (this.objSelMgr.isUnselectedObject(e.objHash)) continue;
                    double max = ChartUtil.getEqMaxValue(e.asd.act1 + e.asd.act2 + e.asd.act3);
                    if (max > maxValue) {
                        maxValue = max;
                    }
                    list.add(e);
                }
            }
            this.size = list.size();
            if (this.size < 1) {
                this.datas = new EqData[0];
                return;
            }
            try {
                this.datas = list.toArray(new EqData[this.size]);
                this.unitWidth = (width - 16) / this.size;
                if (this.unitWidth < MINIMUM_UNIT_WIDTH) {
                    this.unitWidth = MINIMUM_UNIT_WIDTH;
                }
                gc.setForeground(XLogViewPainter.color_grid_narrow);
                gc.setLineStyle(3);
                int i = 16 + this.unitWidth;
                while (i <= width - this.unitWidth) {
                    gc.drawLine(i, 0, i, height);
                    i += this.unitWidth;
                }
                gc.setForeground(black);
                gc.setLineStyle(1);
                int verticalLineX = 6;
                int verticalLineY = 6;
                gc.drawLine(16, verticalLineY, 16, height - verticalLineY);
                gc.drawLine(16, height - verticalLineY, width, height - verticalLineY);
                int groundWidth = this.area.width - verticalLineX;
                int barSpace = height - verticalLineY - 21;
                int imgWidth = this.unitWidth - 4;
                int mod = (int)((double)TimeUtil.getCurrentTime() % CYCLE_INTERVAL);
                int i2 = 0;
                while (i2 < this.datas.length) {
                    String objName = this.datas[i2].displayName;
                    gc.setForeground(dark_gary);
                    gc.setFont(verdana10Italic);
                    int strWidth = gc.stringExtent((String)objName).x;
                    while (groundWidth <= strWidth + 5) {
                        objName = objName.substring(1);
                        strWidth = gc.stringExtent((String)objName).x;
                    }
                    int x = this.unitWidth * (i2 + 1) - 1;
                    int y = verticalLineY;
                    if (this.objectNameImageMap.get(objName) == null) {
                        this.objectNameImageMap.put(objName, this.createVerticalTextImage(objName, gc.stringExtent((String)objName).y, gc.stringExtent((String)objName).x, gc.getFont(), dark_gary.getRGB(), false));
                    }
                    gc.drawImage(this.objectNameImageMap.get(objName), x, y);
                    if (!this.datas[i2].isAlive) {
                        gc.setForeground(dark_gary);
                        gc.setLineWidth(2);
                        gc.drawLine(x + gc.stringExtent((String)objName).y / 2, y - 1, x + gc.stringExtent((String)objName).y / 2, y + gc.stringExtent((String)objName).x + 1);
                    }
                    gc.setLineWidth(1);
                    ActiveSpeedData asd = this.datas[i2].asd;
                    long total = asd.act1 + asd.act2 + asd.act3;
                    double reach = (double)barSpace * ((double)total / maxValue);
                    int barY = height - verticalLineY - 8;
                    if (total > 0L) {
                        try {
                            int noOfBars = (int)reach / 7;
                            int noOfAct1 = (int)((double)noOfBars * ((double)asd.act1 / (double)total));
                            int noOfAct2 = (int)((double)noOfBars * ((double)asd.act2 / (double)total));
                            int noOfAct3 = (int)((double)noOfBars * ((double)asd.act3 / (double)total));
                            int sediments = noOfBars - (noOfAct1 + noOfAct2 + noOfAct3);
                            while (sediments >= 0) {
                                if (asd.act3 > 0) {
                                    ++noOfAct3;
                                    --sediments;
                                }
                                if (sediments >= 0 && asd.act2 > 0) {
                                    ++noOfAct2;
                                    --sediments;
                                }
                                if (sediments < 0 || asd.act1 <= 0) continue;
                                ++noOfAct1;
                                --sediments;
                            }
                            int barX = 16 + (this.unitWidth * i2 + 2);
                            Color lastColor = null;
                            int j = 0;
                            while (j < noOfAct3) {
                                this.drawNemo(gc, ColorUtil.getInstance().ac3, barX + 1, barY + 1, imgWidth - 2, 5);
                                barY -= 7;
                                lastColor = ColorUtil.getInstance().ac3;
                                ++j;
                            }
                            j = 0;
                            while (j < noOfAct2) {
                                this.drawNemo(gc, ColorUtil.getInstance().ac2, barX + 1, barY + 1, imgWidth - 2, 5);
                                barY -= 7;
                                lastColor = ColorUtil.getInstance().ac2;
                                ++j;
                            }
                            j = 0;
                            while (j < noOfAct1) {
                                this.drawNemo(gc, ColorUtil.getInstance().ac1, barX + 1, barY + 1, imgWidth - 2, 5);
                                barY -= 7;
                                lastColor = ColorUtil.getInstance().ac1;
                                ++j;
                            }
                            if (lastColor != null) {
                                this.drawNemo(gc, lastColor, barX + 1, barY + 1 - (int)this.calculateReach(mod, 4.8999999999999995), imgWidth - 2, 5);
                            }
                        }
                        catch (Throwable th) {
                            th.printStackTrace();
                        }
                    }
                    if (this.datas[i2].isAlive) {
                        gc.setFont(verdana10Bold);
                        gc.setForeground(black);
                        String v = Long.toString(total);
                        String all = "(" + Long.toString(asd.act3) + " / " + Long.toString(asd.act2) + " / " + Long.toString(asd.act1) + ")";
                        int xaxis = 16 + this.unitWidth * i2 + (this.unitWidth - gc.stringExtent((String)v).x) / 2;
                        int yaxis = barY - 14 - 4;
                        if (total > 0L && this.unitWidth >= 52) {
                            yaxis -= gc.stringExtent((String)all).y - 2;
                        }
                        gc.drawString(v, xaxis, yaxis, true);
                        if (total > 0L && this.unitWidth >= 52) {
                            gc.setFont(verdana7);
                            xaxis = 16 + this.unitWidth * i2 + (this.unitWidth - gc.stringExtent((String)all).x) / 2 - Long.toString(total).length() * 2;
                            v = "(";
                            gc.drawString(v, xaxis, yaxis += gc.stringExtent((String)all).y + 2, true);
                            gc.setForeground(ColorUtil.getInstance().ac3);
                            v = Long.toString(asd.act3);
                            gc.drawString(v, xaxis += gc.stringExtent((String)v).x + 1, yaxis, true);
                            gc.setForeground(black);
                            v = " / ";
                            gc.drawString(v, xaxis += gc.stringExtent((String)v).x + 1, yaxis, true);
                            gc.setForeground(ColorUtil.getInstance().ac2);
                            v = Long.toString(asd.act2);
                            gc.drawString(v, xaxis += gc.stringExtent((String)v).x + 1, yaxis, true);
                            gc.setForeground(black);
                            v = " / ";
                            gc.drawString(v, xaxis += gc.stringExtent((String)v).x + 1, yaxis, true);
                            gc.setForeground(ColorUtil.getInstance().ac1);
                            v = Long.toString(asd.act1);
                            gc.drawString(v, xaxis += gc.stringExtent((String)v).x + 1, yaxis, true);
                            gc.setForeground(black);
                            v = ")";
                            gc.drawString(v, xaxis += gc.stringExtent((String)v).x + 1, yaxis, true);
                        }
                    }
                    ++i2;
                }
                gc.setForeground(black);
                gc.setFont(verdana7);
                int max = (int)maxValue;
                String v = Integer.toString(max);
                String v2 = Integer.toString(max / 2);
                gc.drawString(v, 2, 4, true);
                gc.drawString(v2, 2, verticalLineY + (height - verticalLineY) / 2 - gc.stringExtent((String)v2).y, true);
                gc.drawString("0", 2, height - gc.stringExtent((String)v).y - 4, true);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        finally {
            gc.dispose();
            Image old = this.ibuffer;
            this.ibuffer = img;
            if (old != null) {
                old.dispose();
            }
            this.onGoing = false;
        }
    }

    private void drawNemo(GC gc, Color background, int x, int y, int width, int height) {
        gc.setBackground(background);
        gc.fillRectangle(x, y, width, height);
        gc.setForeground(black);
        gc.drawRectangle(x, y, width, height);
    }

    public void setFocus() {
        this.scroll.setFocus();
    }

    private double calculateReach(int mod, double weight) {
        return (Math.cos((double)mod * (Math.PI / (CYCLE_INTERVAL / 2.0)) + Math.PI) + 1.0) / 2.0 * weight;
    }

    @Override
    public void refresh() {
        this.buildBars();
        long now = TimeUtil.getCurrentTime();
        if (now >= this.lastFetchedTime + 2000L) {
            this.lastFetchedTime = now;
            this.valueSet.clear();
            this.fetch();
        }
        ExUtil.syncExec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                VerticalEQCommonView.this.canvas.redraw();
            }
        });
    }

    public abstract void fetch();

    public void dispose() {
        super.dispose();
        if (this.ibuffer != null && !this.ibuffer.isDisposed()) {
            this.ibuffer.dispose();
        }
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    private Image createVerticalTextImage(String text, int w, int h, Font font, RGB color, boolean upToDown) {
        Image image = new Image((Device)Display.getCurrent(), w, h);
        GC gc = new GC((Drawable)image);
        Color titleColor = new Color((Device)Display.getCurrent(), color);
        RGB transparentRGB = new RGB(240, 240, 240);
        gc.setBackground(XYGraphMediaFactory.getInstance().getColor(transparentRGB));
        gc.fillRectangle(image.getBounds());
        gc.setForeground(titleColor);
        gc.setFont(font);
        Transform tr = new Transform((Device)Display.getCurrent());
        if (!upToDown) {
            tr.translate(0.0f, (float)h);
            tr.rotate(-90.0f);
            gc.setTransform(tr);
        } else {
            tr.translate((float)w, 0.0f);
            tr.rotate(90.0f);
            gc.setTransform(tr);
        }
        gc.drawText(text, 0, 0);
        tr.dispose();
        gc.dispose();
        ImageData imageData = image.getImageData();
        image.dispose();
        titleColor.dispose();
        imageData.transparentPixel = imageData.palette.getPixel(transparentRGB);
        image = new Image((Device)Display.getCurrent(), imageData);
        return image;
    }

    public static class ActiveSpeedData {
        public int act1;
        public int act2;
        public int act3;
    }

    public static class EqData {
        public int objHash;
        public boolean isAlive;
        public String displayName;
        public ActiveSpeedData asd;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.objHash;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EqData other = (EqData)obj;
            return this.objHash == other.objHash;
        }

        public String toString() {
            return "EqData [objHash=" + this.objHash + ", displayName=" + this.displayName + "]";
        }
    }

    public class EqDataComparator
    implements Comparator<EqData> {
        @Override
        public int compare(EqData o1, EqData o2) {
            int comp = o1.displayName.compareTo(o2.displayName);
            if (comp == 0) {
                return o1.objHash - o2.objHash;
            }
            return comp;
        }
    }
}

