/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.stack.base.MainProcessor;
import scouter.client.util.ImageUtil;
import scouter.client.util.RCPUtil;
import scouter.client.xlog.SaveProfileJob;
import scouter.client.xlog.views.XLogFullProfileView;

public class WorkspaceExplorer
extends ViewPart {
    private TreeViewer viewer;
    private int serverId;
    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    File workingDir = RCPUtil.getWorkingDirectory();
    public static final String ID = WorkspaceExplorer.class.getName();

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new WorkspaceContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkspaceLabelProvider());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element != null && element instanceof File && ((File)element).isFile()) {
                    File selectedFile = (File)element;
                    WorkspaceExplorer.this.openFile(selectedFile);
                } else if (element != null && element instanceof File && ((File)element).isDirectory()) {
                    IStructuredSelection thisSelection;
                    Object selectedNode;
                    TreeViewer viewer;
                    viewer.setExpandedState(selectedNode, !(viewer = (TreeViewer)event.getViewer()).getExpandedState(selectedNode = (thisSelection = (IStructuredSelection)event.getSelection()).getFirstElement()));
                }
            }
        });
        this.viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && (e.keyCode == 99 || e.keyCode == 67)) {
                    new CopySelectedFilesAction().run();
                }
            }
        });
        this.viewer.setInput((Object)this.sortDirectoriesAndFiles(this.workingDir.listFiles(new ContentFilter())));
        this.fillTreeViewerCoolbar();
        this.createContextMenu((Viewer)this.viewer, new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                WorkspaceExplorer.this.fillTreeViewerContextMenu(manager);
            }
        });
    }

    public void setInput(int serverId) {
        this.serverId = serverId;
        this.refreshViewer();
    }

    private void fillTreeViewerCoolbar() {
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Expand All", ImageUtil.getImageDescriptor(Images.expand)){

            public void run() {
                WorkspaceExplorer.this.viewer.expandAll();
            }
        });
        man.add((IAction)new Action("Collapse All", ImageUtil.getImageDescriptor(Images.collapse)){

            public void run() {
                WorkspaceExplorer.this.viewer.collapseAll();
            }
        });
        man.add((IContributionItem)new Separator());
        man.add((IAction)new Action("Refresh", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                WorkspaceExplorer.this.refreshViewer();
            }
        });
    }

    public void refreshViewer() {
        Object[] elements = this.viewer.getExpandedElements();
        TreePath[] treePaths = this.viewer.getExpandedTreePaths();
        this.viewer.getTree().clearAll(true);
        this.viewer.setInput((Object)this.sortDirectoriesAndFiles(this.workingDir.listFiles(new ContentFilter())));
        this.viewer.refresh();
        this.viewer.setExpandedElements(elements);
        this.viewer.setExpandedTreePaths(treePaths);
    }

    public void openFile(File selectedFile) {
        if (SaveProfileJob.xLogFileName.equals(selectedFile.getName()) || SaveProfileJob.profileFileName.equals(selectedFile.getName())) {
            try {
                XLogFullProfileView view = (XLogFullProfileView)this.window.getActivePage().showView(XLogFullProfileView.ID, selectedFile.getParentFile().getName(), 1);
                if (view != null) {
                    view.setInput(selectedFile.getParentFile(), this.serverId, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (SaveProfileJob.profileSummaryFileName.equals(selectedFile.getName())) {
            try {
                XLogFullProfileView view = (XLogFullProfileView)this.window.getActivePage().showView(XLogFullProfileView.ID, selectedFile.getParentFile().getName(), 1);
                if (view != null) {
                    view.setInput(selectedFile.getParentFile(), this.serverId, true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (selectedFile.getName().endsWith(".stack")) {
            MainProcessor.instance().processStackFile(selectedFile.getAbsolutePath());
        } else {
            Program.launch((String)selectedFile.getAbsolutePath());
        }
    }

    public Object[] sortDirectoriesAndFiles(File[] files) {
        List<File> fileList = Arrays.asList(files);
        Collections.sort(fileList, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                if (f1.isDirectory() && !f2.isDirectory()) {
                    return -1;
                }
                if (!f1.isDirectory() && f2.isDirectory()) {
                    return 1;
                }
                return f1.getName().compareTo(f2.getName());
            }
        });
        ArrayList<File> arr = new ArrayList<File>();
        int inx = 0;
        while (inx < fileList.size()) {
            File f = fileList.get(inx);
            if (!f.isFile() || !f.getName().equals(SaveProfileJob.xLogFileName)) {
                arr.add(f);
            }
            ++inx;
        }
        return arr.toArray(new File[arr.size()]);
    }

    private void fillTreeViewerContextMenu(IMenuManager mgr) {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object[] elements = sel.toArray();
            if (elements == null || elements.length < 1) {
                return;
            }
            Object lastElement = elements[elements.length - 1];
            if (lastElement instanceof File) {
                if (((File)lastElement).isFile()) {
                    mgr.add((IAction)new OpenSelectedFileAction((File)lastElement));
                    mgr.add((IContributionItem)new Separator());
                    mgr.add((IAction)new CopySelectedFilesAction());
                    mgr.add((IAction)new CopyWSPathSelectedFilesAction());
                    mgr.add((IContributionItem)new Separator());
                    mgr.add((IAction)new DeleteSelectedFileAction());
                } else if (((File)lastElement).isDirectory()) {
                    mgr.add((IAction)new DeleteSelectedFileAction());
                }
            }
        }
    }

    private void createContextMenu(Viewer viewer, IMenuListener listener) {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(listener);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
    }

    public void setFocus() {
    }

    public void afterDescriptionCreated() {
        this.refreshViewer();
    }

    public class ContentFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            String fileName = file.getName();
            if (fileName.endsWith(".index") || fileName.endsWith(".zip") || fileName.endsWith(".threads")) {
                return false;
            }
            return file.isFile() || !fileName.startsWith(".");
        }
    }

    public class CopySelectedFilesAction
    extends Action {
        public CopySelectedFilesAction() {
            super("&Copy");
        }

        public void run() {
            ISelection sel = WorkspaceExplorer.this.viewer.getSelection();
            if (sel instanceof StructuredSelection) {
                if (sel.isEmpty()) {
                    return;
                }
                ArrayList<String> paths = new ArrayList<String>();
                for (File file : (StructuredSelection)sel) {
                    if (file.isDirectory()) continue;
                    paths.add(file.getAbsolutePath());
                }
                Clipboard clipboard = new Clipboard(Display.getDefault());
                clipboard.setContents(new Object[]{paths.toArray(new String[paths.size()])}, new Transfer[]{FileTransfer.getInstance()});
                clipboard.dispose();
            }
        }
    }

    public class CopyWSPathSelectedFilesAction
    extends Action {
        private String sep;

        public CopyWSPathSelectedFilesAction() {
            super("&Copy Path");
            this.sep = System.getProperty("line.separator").toString();
        }

        public void run() {
            ISelection sel = WorkspaceExplorer.this.viewer.getSelection();
            if (sel instanceof StructuredSelection) {
                StringBuilder sb = new StringBuilder();
                Iterator i = ((StructuredSelection)sel).iterator();
                while (i.hasNext()) {
                    File file = (File)i.next();
                    sb.append(file.getAbsolutePath().replace("\\", "/"));
                    if (!i.hasNext()) continue;
                    sb.append(this.sep);
                }
                Clipboard clipboard = new Clipboard(Display.getDefault());
                clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
            }
        }
    }

    public class DeleteSelectedFileAction
    extends Action {
        public DeleteSelectedFileAction() {
            super("&Delete");
        }

        public void run() {
            ISelection sel = WorkspaceExplorer.this.viewer.getSelection();
            if (sel instanceof StructuredSelection) {
                for (File file : (StructuredSelection)sel) {
                    if (file.isDirectory()) {
                        this.deleteDirectory(file);
                        continue;
                    }
                    file.delete();
                }
            }
            WorkspaceExplorer.this.refreshViewer();
        }

        public void deleteDirectory(File path) {
            File[] files;
            File[] fileArray = files = path.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                } else {
                    file.delete();
                }
                ++n2;
            }
            path.delete();
        }
    }

    public class OpenSelectedFileAction
    extends Action {
        File file;

        public OpenSelectedFileAction(File file) {
            super("&Open");
            this.file = file;
        }

        public void run() {
            WorkspaceExplorer.this.openFile(this.file);
        }
    }

    public class WorkspaceContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parent) {
            if (parent instanceof File) {
                File file = (File)parent;
                return WorkspaceExplorer.this.sortDirectoriesAndFiles(file.listFiles(new ContentFilter()));
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public Object getParent(Object element) {
            File file = (File)element;
            return file.getParentFile();
        }

        public boolean hasChildren(Object parent) {
            File file = (File)parent;
            return file.isDirectory();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    public class WorkspaceLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof File) {
                ImageDescriptor ds;
                File file = (File)element;
                if (file.isDirectory()) {
                    return Images.folder;
                }
                String fileName = ((File)element).getName();
                if (fileName.length() > 0) {
                    if (SaveProfileJob.profileFileName.equals(fileName)) {
                        return Images.PROFILE_FULL;
                    }
                    if (SaveProfileJob.profileSummaryFileName.equals(fileName)) {
                        return Images.PROFILE_SUMMARY;
                    }
                }
                if ((ds = PlatformUI.getWorkbench().getEditorRegistry().getSystemExternalEditorImageDescriptor(file.getName())) != null) {
                    return ds.createImage();
                }
                return Images.unknown;
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            String fileName = ((File)element).getName();
            if (fileName.length() > 0) {
                if (SaveProfileJob.profileFileName.equals(fileName)) {
                    return "Full Profiles";
                }
                if (SaveProfileJob.profileSummaryFileName.equals(fileName)) {
                    return "Profile Summary";
                }
                if (SaveProfileJob.xLogFileName.equals(fileName)) {
                    return null;
                }
                return fileName;
            }
            return ((File)element).getPath();
        }
    }
}

