/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.visitor.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.Images;
import scouter.client.counter.actions.OpenVisitorLoadAction;
import scouter.client.counter.actions.OpenVisitorTotalLoadAction;
import scouter.client.net.TcpProxy;
import scouter.client.popup.CalendarDialog;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.views.DigitalCountView;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;

public class VisitorLoadView
extends DigitalCountView
implements CalendarDialog.ILoadCalendarDialog {
    public static final String ID = VisitorLoadView.class.getName();
    private int serverId;
    String requestCmd;
    MapPack param;
    String date;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.date = ids[1];
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Load", ImageUtil.getImageDescriptor(Images.calendar)){

            public void run() {
                CalendarDialog dialog = new CalendarDialog(VisitorLoadView.this.getSite().getShell().getDisplay(), VisitorLoadView.this);
                dialog.show(-1, -1, DateUtil.getTime((String)VisitorLoadView.this.date, (String)"yyyyMMdd"));
            }
        });
        Menu contextMenu = new Menu((Control)this.canvas);
        MenuItem loadCalendaer = new MenuItem(contextMenu, 8);
        loadCalendaer.setText("&Load");
        loadCalendaer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarDialog dialog = new CalendarDialog(VisitorLoadView.this.getSite().getShell().getDisplay(), VisitorLoadView.this);
                dialog.show();
            }
        });
        this.canvas.setMenu(contextMenu);
    }

    public void setInput(String title, String requestCmd, MapPack param) {
        this.title = title == null ? this.title : title;
        this.requestCmd = requestCmd;
        this.param = param;
        this.load();
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    public void setFocus() {
    }

    public void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                Value v;
                block7: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(VisitorLoadView.this.serverId);
                    v = null;
                    try {
                        try {
                            v = tcp.getSingleValue(VisitorLoadView.this.requestCmd, (Pack)VisitorLoadView.this.param);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (v != null) {
                    VisitorLoadView.this.value = FormatUtil.print((Object)CastUtil.clong((Object)v), (String)"#,##0");
                } else {
                    VisitorLoadView.this.value = "unavailable";
                }
                ExUtil.exec((Composite)VisitorLoadView.this.canvas, new Runnable(){

                    @Override
                    public void run() {
                        VisitorLoadView.this.canvas.redraw();
                    }
                });
            }
        });
    }

    @Override
    public void onPressedOk(String date) {
        if (this.param.getText("objType") == null) {
            new OpenVisitorLoadAction(this.getSite().getWorkbenchWindow(), this.serverId, date, this.param.getInt("objHash")).run();
        } else {
            new OpenVisitorTotalLoadAction(this.getSite().getWorkbenchWindow(), this.serverId, date, this.param.getText("objType")).run();
        }
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
    }

    @Override
    public void onPressedCancel() {
    }
}

