/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.visitor.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import scouter.client.Images;
import scouter.client.counter.actions.OpenVisitorLoadAction;
import scouter.client.counter.actions.OpenVisitorTotalLoadAction;
import scouter.client.model.RefreshThread;
import scouter.client.net.TcpProxy;
import scouter.client.popup.CalendarDialog;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.views.DigitalCountView;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.ref.BOOLEAN;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.FormatUtil;
import scouter.util.StringUtil;

public class VisitorRealtimeView
extends DigitalCountView
implements RefreshThread.Refreshable,
CalendarDialog.ILoadCalendarDialog {
    public static final String ID = VisitorRealtimeView.class.getName();
    protected RefreshThread thread;
    IMemento memento;
    private int serverId;
    String requestCmd;
    MapPack param;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = CastUtil.cint((Object)ids[0]);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Load", ImageUtil.getImageDescriptor(Images.calendar)){

            public void run() {
                CalendarDialog dialog = new CalendarDialog(VisitorRealtimeView.this.getSite().getShell().getDisplay(), VisitorRealtimeView.this);
                dialog.show();
            }
        });
        Menu contextMenu = new Menu((Control)this.canvas);
        MenuItem loadCalendaer = new MenuItem(contextMenu, 8);
        loadCalendaer.setText("&Load");
        loadCalendaer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarDialog dialog = new CalendarDialog(VisitorRealtimeView.this.getSite().getShell().getDisplay(), VisitorRealtimeView.this);
                dialog.show();
            }
        });
        this.canvas.setMenu(contextMenu);
        this.restoreState();
    }

    public void setInput(String title, String requestCmd, MapPack param) {
        this.title = title != null ? title : this.title;
        this.requestCmd = requestCmd;
        this.param = param;
        if (this.thread == null) {
            this.thread = new RefreshThread(this, 2000);
            this.thread.start();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.shutdown();
        }
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void refresh() {
        Value v;
        block7: {
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            v = null;
            try {
                try {
                    v = tcp.getSingleValue(this.requestCmd, (Pack)this.param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        final BOOLEAN result = new BOOLEAN();
        if (v != null) {
            result.value = true;
            this.value = FormatUtil.print((Object)CastUtil.clong((Object)v), (String)"#,##0");
        } else {
            result.value = false;
            this.value = "unavailable";
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                if (result.value) {
                    VisitorRealtimeView.this.setTitleImage(Images.active);
                } else {
                    VisitorRealtimeView.this.setTitleImage(Images.inactive);
                }
                VisitorRealtimeView.this.canvas.redraw();
            }
        });
    }

    @Override
    public void onPressedOk(String date) {
        if (this.param.getText("objType") == null) {
            new OpenVisitorLoadAction(this.getSite().getWorkbenchWindow(), this.serverId, date, this.param.getInt("objHash")).run();
        } else {
            new OpenVisitorTotalLoadAction(this.getSite().getWorkbenchWindow(), this.serverId, date, this.param.getText("objType")).run();
        }
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
    }

    @Override
    public void onPressedCancel() {
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.memento = memento.createChild(ID);
        this.memento.putString("title", this.title);
        this.memento.putString("requestCmd", this.requestCmd);
        if (this.param.containsKey("objType")) {
            this.memento.putString("objType", this.param.getText("objType"));
        } else {
            this.memento.putInteger("objHash", this.param.getInt("objHash"));
        }
    }

    public void restoreState() {
        if (this.memento == null) {
            return;
        }
        IMemento memento = this.memento.getChild(ID);
        if (memento == null) {
            return;
        }
        String title = memento.getString("title");
        String requestCmd = memento.getString("requestCmd");
        MapPack param = new MapPack();
        if (StringUtil.isNotEmpty((String)memento.getString("objType"))) {
            param.put("objType", memento.getString("objType"));
        } else {
            param.put("objHash", (long)memento.getInteger("objHash").intValue());
        }
        this.setInput(title, requestCmd, param);
    }
}

