/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import scouter.client.model.AgentColorManager;
import scouter.client.util.ColorUtil;

public class ImageCache {
    private static ImageCache instance;
    private Map<RGB, Image> xLogDotMap = new HashMap<RGB, Image>();
    private Image errorXpDot = null;
    private Image errorXpDotLight = null;

    public static synchronized ImageCache getInstance() {
        if (instance == null) {
            instance = new ImageCache();
        }
        return instance;
    }

    public synchronized Image getXPImage(int objHash, byte xtype) {
        RGB rgb;
        Image xp;
        Color agentColor = AgentColorManager.getInstance().getColor(objHash);
        if (agentColor == null) {
            agentColor = ColorUtil.getInstance().getColor("blue");
        }
        if (xtype == 3 || xtype == 4) {
            agentColor = ColorUtil.getInstance().getColor("light2 gray");
        }
        if ((xp = this.xLogDotMap.get(rgb = agentColor.getRGB())) == null) {
            xp = this.createXPImage(rgb);
            this.xLogDotMap.put(rgb, xp);
        }
        return xp;
    }

    private Image createXPImage(RGB rgb) {
        return this.createXPImage5(rgb);
    }

    private Image createXPImage4(RGB rgb) {
        Image xp = new Image(null, 4, 4);
        GC gcc = new GC((Drawable)xp);
        gcc.setForeground(new Color(null, rgb));
        int i = 0;
        while (i < 4) {
            gcc.drawLine(i, 0, i, 3);
            ++i;
        }
        gcc.setForeground(ColorUtil.getInstance().getColor("white"));
        gcc.drawPoint(1, 0);
        gcc.drawPoint(3, 1);
        gcc.drawPoint(0, 2);
        gcc.drawPoint(2, 3);
        gcc.dispose();
        return xp;
    }

    private Image createXPImage5(RGB rgb) {
        Image xp = new Image(null, 5, 5);
        GC gcc = new GC((Drawable)xp);
        gcc.setForeground(new Color(null, rgb));
        int i = 0;
        while (i < 5) {
            gcc.drawLine(i, 0, i, 4);
            ++i;
        }
        gcc.setForeground(ColorUtil.getInstance().getColor("white"));
        gcc.drawPoint(1, 0);
        gcc.drawPoint(4, 1);
        gcc.drawPoint(0, 3);
        gcc.drawPoint(3, 4);
        gcc.dispose();
        return xp;
    }

    public synchronized Image getXPErrorImage(byte xtype) {
        if (this.errorXpDot == null) {
            this.errorXpDot = this.createXPImage(ColorUtil.getInstance().getColor("red").getRGB());
        }
        if (this.errorXpDotLight == null) {
            this.errorXpDotLight = this.createXPImage(ColorUtil.getInstance().getColor("light2 red").getRGB());
        }
        if (xtype == 3 || xtype == 4) {
            return this.errorXpDotLight;
        }
        return this.errorXpDot;
    }

    private Image createObjectImage(RGB rgb) {
        Image xp = new Image(null, 3, 3);
        GC gcc = new GC((Drawable)xp);
        gcc.setForeground(new Color(null, rgb));
        gcc.drawPoint(1, 1);
        gcc.dispose();
        return xp;
    }
}

