/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import scouter.client.model.TextProxy;
import scouter.client.model.XLogData;
import scouter.client.model.XLogProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.SqlMakerUtil;
import scouter.client.xlog.XLogUtil;
import scouter.client.xlog.views.XLogProfileView;
import scouter.lang.CountryCode;
import scouter.lang.enumeration.ParameterizedMessageLevel;
import scouter.lang.step.ApiCallStep;
import scouter.lang.step.ApiCallStep2;
import scouter.lang.step.ApiCallSum;
import scouter.lang.step.CommonSpanStep;
import scouter.lang.step.DispatchStep;
import scouter.lang.step.DumpStep;
import scouter.lang.step.HashedMessageStep;
import scouter.lang.step.MessageStep;
import scouter.lang.step.MethodStep;
import scouter.lang.step.MethodStep2;
import scouter.lang.step.MethodSum;
import scouter.lang.step.ParameterizedMessageStep;
import scouter.lang.step.SocketStep;
import scouter.lang.step.SocketSum;
import scouter.lang.step.SpanCallStep;
import scouter.lang.step.SpanStep;
import scouter.lang.step.SqlStep;
import scouter.lang.step.SqlStep2;
import scouter.lang.step.SqlStep3;
import scouter.lang.step.SqlSum;
import scouter.lang.step.SqlXType;
import scouter.lang.step.Step;
import scouter.lang.step.StepControl;
import scouter.lang.step.StepSingle;
import scouter.lang.step.StepSummary;
import scouter.lang.step.ThreadCallPossibleStep;
import scouter.lang.step.ThreadSubmitStep;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.Hexa32;
import scouter.util.IPUtil;
import scouter.util.SortUtil;
import scouter.util.StringUtil;

public class ProfileText {
    public static void build(String date, StyledText text, XLogData xperf, Step[] profiles, int spaceCnt, int serverId) {
        ProfileText.build(date, text, xperf, profiles, serverId, false);
    }

    public static void build(String date, StyledText text, XLogData xperf, Step[] profiles, int serverId, boolean bindSqlParam) {
        ProfileText.build(date, text, xperf, profiles, serverId, bindSqlParam, false);
    }

    public static Color getColor(ParameterizedMessageLevel level) {
        switch (level) {
            case DEBUG: {
                return ColorUtil.getInstance().getColor("gray3");
            }
            case INFO: {
                return ColorUtil.getInstance().getColor("gunlee2");
            }
            case WARN: {
                return ColorUtil.getInstance().getColor("dark orange");
            }
            case ERROR: {
                return ColorUtil.getInstance().getColor("light red2");
            }
            case FATAL: {
                return ColorUtil.getInstance().getColor("red");
            }
        }
        return ColorUtil.getInstance().getColor("dark gray");
    }

    public static void build(String date, StyledText text, XLogData xperf, Step[] profiles, int serverId, boolean bindSqlParam, boolean isSimplified) {
        long stime;
        String t;
        boolean truncated = false;
        if (profiles == null) {
            profiles = new Step[]{};
        }
        profiles = SortUtil.sort((Step[])profiles);
        XLogUtil.loadStepText(serverId, date, profiles);
        String error = TextProxy.error.getLoadText(date, xperf.p.error, serverId);
        Color blue = text.getDisplay().getSystemColor(9);
        Color dmagenta = text.getDisplay().getSystemColor(12);
        Color red = text.getDisplay().getSystemColor(3);
        Color dred = text.getDisplay().getSystemColor(4);
        Color dgreen = text.getDisplay().getSystemColor(6);
        Color dblue = text.getDisplay().getSystemColor(10);
        Color dcyan = text.getDisplay().getSystemColor(14);
        Color dyellow = text.getDisplay().getSystemColor(8);
        Color dgray = text.getDisplay().getSystemColor(16);
        ArrayList<StyleRange> sr = new ArrayList<StyleRange>();
        int slen = 0;
        StringBuffer sb = new StringBuffer();
        sb.append("\u25ba txid    = ");
        slen = sb.length();
        sb.append(Hexa32.toString32((long)xperf.p.txid)).append("\n");
        sr.add(ProfileText.underlineStyle(slen, sb.length() - slen, dmagenta, 0, 4));
        if (xperf.p.gxid != 0L) {
            sb.append("\u25ba gxid    = ");
            slen = sb.length();
            sb.append(Hexa32.toString32((long)xperf.p.gxid));
            sr.add(ProfileText.underlineStyle(slen, sb.length() - slen, dmagenta, 0, 4));
            slen = sb.length();
            sb.append(" <<- click to open XLog flow map").append("\n");
            sr.add(ProfileText.style(slen, sb.length() - slen, dyellow, 0));
        }
        if (xperf.p.caller != 0L) {
            sb.append("\u25ba caller  = ");
            slen = sb.length();
            sb.append(Hexa32.toString32((long)xperf.p.caller)).append("\n");
            sr.add(ProfileText.underlineStyle(slen, sb.length() - slen, dmagenta, 0, 4));
        }
        sb.append("\u25ba objName = ").append(xperf.objName).append("\n");
        sb.append("\u25ba thread  = ").append(TextProxy.hashMessage.getLoadText(date, xperf.p.threadNameHash, serverId)).append("\n");
        sb.append("\u25ba endtime = ").append(FormatUtil.print((Object)new Date(xperf.p.endTime), (String)"yyyyMMdd HH:mm:ss.SSS")).append("\n");
        sb.append("\u25ba elapsed = ").append(FormatUtil.print((Object)xperf.p.elapsed, (String)"#,##0")).append(" ms\n");
        sb.append("\u25ba service = ").append(TextProxy.service.getText(xperf.p.service)).append("\n");
        if (error != null) {
            sb.append("\u25ba error   = ");
            slen = sb.length();
            sb.append(error).append("\n");
            sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
        }
        sb.append("\u25ba ipaddr=" + IPUtil.toString((byte[])xperf.p.ipaddr) + ", ");
        sb.append("userid=" + xperf.p.userid);
        sb.append("\n\u25ba cpu=" + FormatUtil.print((Object)xperf.p.cpu, (String)"#,##0") + " ms, ");
        sb.append("kbytes=" + xperf.p.kbytes);
        if (xperf.p.sqlCount > 0) {
            sb.append("\n\u25ba sqlCount=" + xperf.p.sqlCount + ", ");
            sb.append("sqlTime=" + FormatUtil.print((Object)xperf.p.sqlTime, (String)"#,##0") + " ms");
        }
        if (xperf.p.apicallCount > 0) {
            sb.append("\n\u25ba ApiCallCount=" + xperf.p.apicallCount + ", ");
            sb.append("ApiCallTime=" + FormatUtil.print((Object)xperf.p.apicallTime, (String)"#,##0") + " ms");
        }
        if (StringUtil.isNotEmpty((String)(t = TextProxy.userAgent.getLoadText(date, xperf.p.userAgent, serverId)))) {
            sb.append("\n\u25ba userAgent=" + t);
        }
        if (StringUtil.isNotEmpty((String)(t = TextProxy.referer.getLoadText(date, xperf.p.referer, serverId)))) {
            sb.append("\n\u25ba referer=" + t);
        }
        if (StringUtil.isNotEmpty((String)(t = TextProxy.group.getLoadText(date, xperf.p.group, serverId)))) {
            sb.append("\n\u25ba group=" + t);
        }
        if (StringUtil.isNotEmpty((String)xperf.p.countryCode)) {
            sb.append("\n\u25ba country=" + CountryCode.getCountryName((String)xperf.p.countryCode));
        }
        if (StringUtil.isNotEmpty((String)(t = TextProxy.city.getLoadText(date, xperf.p.city, serverId)))) {
            sb.append("\n\u25ba city=" + t);
        }
        if (StringUtil.isNotEmpty((String)(t = TextProxy.web.getLoadText(date, xperf.p.webHash, serverId)))) {
            sb.append("\n\u25ba webName=" + t).append("  webTime=" + xperf.p.webTime + " ms");
        }
        if (StringUtil.isNotEmpty((String)(t = TextProxy.web.getLoadText(date, xperf.p.queuingHostHash, serverId)))) {
            sb.append("\n\u25ba queuing=" + t).append("  time=" + xperf.p.queuingTime + " ms");
        }
        if (StringUtil.isNotEmpty((String)(t = TextProxy.web.getLoadText(date, xperf.p.queuing2ndHostHash, serverId)))) {
            sb.append("\n\u25ba 2nd-queuing=" + t).append("  time=" + xperf.p.queuing2ndTime + " ms");
        }
        if (StringUtil.isNotEmpty((String)(t = TextProxy.login.getLoadText(date, xperf.p.login, serverId)))) {
            sb.append("\n\u25ba login=" + t);
        }
        if (StringUtil.isNotEmpty((String)(t = TextProxy.desc.getLoadText(date, xperf.p.desc, serverId)))) {
            sb.append("\n\u25ba desc=" + t);
        }
        if (StringUtil.isNotEmpty((String)xperf.p.text1)) {
            sb.append("\n\u25ba text1=" + xperf.p.text1);
        }
        if (StringUtil.isNotEmpty((String)xperf.p.text2)) {
            sb.append("\n\u25ba text2=" + xperf.p.text2);
        }
        if (StringUtil.isNotEmpty((String)xperf.p.text3)) {
            sb.append("\n\u25ba text3=" + xperf.p.text3);
        }
        if (StringUtil.isNotEmpty((String)xperf.p.text4)) {
            sb.append("\n\u25ba text4=" + xperf.p.text4);
        }
        if (StringUtil.isNotEmpty((String)xperf.p.text5)) {
            sb.append("\n\u25ba text5=" + xperf.p.text5);
        }
        sb.append("\n\u25ba profileCount=" + xperf.p.profileCount);
        sb.append("\n\u25ba profileSize=" + xperf.p.profileSize);
        if (xperf.p.hasDump == 1) {
            sb.append("\n\u25ba dump=Y");
        }
        sb.append("\n");
        sb.append("------------------------------------------------------------------------------------------\n");
        sb.append("    p#      #    \t  TIME         T-GAP   CPU          CONTENTS\n");
        sb.append("------------------------------------------------------------------------------------------\n");
        if (profiles.length == 0) {
            sb.append("\n                     ( No xlog profile collected ) ");
            text.setText(sb.toString());
            text.setStyleRanges(sr.toArray(new StyleRange[sr.size()]));
            return;
        }
        long prev_tm = stime = xperf.p.endTime - (long)xperf.p.elapsed;
        long prev_cpu = 0L;
        sb.append("        ");
        sb.append(" ");
        sb.append("[******]");
        sb.append(" ");
        sb.append(FormatUtil.print((Object)new Date(stime), (String)"HH:mm:ss.SSS"));
        sb.append("   ");
        sb.append(String.format("%6s", "0"));
        sb.append(" ");
        sb.append(String.format("%6s", "0"));
        sb.append("  start transaction \n");
        long tm = xperf.p.endTime;
        long cpu = xperf.p.cpu;
        int sumCnt = 1;
        HashMap<Integer, Integer> indent = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < profiles.length) {
            block73: {
                int elapsedRate;
                StepSingle stepSingle;
                block74: {
                    block72: {
                        if (truncated) break;
                        if (!(profiles[i] instanceof StepSummary)) break block72;
                        sb.append("        ").append(" ");
                        sb.append(String.format("[%06d]", sumCnt++));
                        sb.append(" ");
                        StepSummary sum = (StepSummary)profiles[i];
                        switch (sum.getStepType()) {
                            case 11: {
                                XLogProfileView.isSummary = true;
                                MethodSum p = (MethodSum)sum;
                                slen = sb.length();
                                String m = TextProxy.method.getText(p.hash);
                                if (m == null) {
                                    m = Hexa32.toString32((long)p.hash);
                                }
                                sb.append(m).append(" ");
                                sr.add(ProfileText.style(slen, sb.length() - slen, blue, 0));
                                sb.append(" count=").append(FormatUtil.print((Object)p.count, (String)"#,##0"));
                                sb.append(" time=").append(FormatUtil.print((Object)p.elapsed, (String)"#,##0")).append(" ms");
                                sb.append(" cpu=").append(FormatUtil.print((Object)p.cputime, (String)"#,##0"));
                                sb.append("\n");
                                break;
                            }
                            case 21: {
                                XLogProfileView.isSummary = true;
                                SqlSum sql = (SqlSum)sum;
                                slen = sb.length();
                                ProfileText.toString(sb, sql, serverId);
                                sr.add(ProfileText.style(slen, sb.length() - slen, blue, 0));
                                sb.append("\n");
                                break;
                            }
                            case 43: {
                                XLogProfileView.isSummary = true;
                                ApiCallSum apicall = (ApiCallSum)sum;
                                slen = sb.length();
                                ProfileText.toString(sb, apicall);
                                sr.add(ProfileText.style(slen, sb.length() - slen, dmagenta, 0));
                                sb.append("\n");
                                break;
                            }
                            case 42: {
                                XLogProfileView.isSummary = true;
                                SocketSum socketSum = (SocketSum)sum;
                                slen = sb.length();
                                ProfileText.toString(sb, socketSum);
                                sr.add(ProfileText.style(slen, sb.length() - slen, dmagenta, 0));
                                sb.append("\n");
                                break;
                            }
                            case 99: {
                                sb.delete(sb.length() - 9, sb.length());
                                sb.append("[******]");
                                sb.append(" ");
                                sb.append(FormatUtil.print((Object)new Date(tm), (String)"HH:mm:ss.SSS"));
                                sb.append("   ");
                                sb.append(String.format("%6s", FormatUtil.print((Object)(tm - prev_tm), (String)"#,##0")));
                                sb.append(" ");
                                sb.append(String.format("%6s", FormatUtil.print((Object)(cpu - prev_cpu), (String)"#,##0")));
                                sb.append("  ");
                                slen = sb.length();
                                ProfileText.toString(sb, (StepControl)sum);
                                sr.add(ProfileText.style(slen, sb.length() - slen, dred, 0));
                                sb.append("\n");
                                truncated = true;
                            }
                        }
                        break block73;
                    }
                    stepSingle = (StepSingle)profiles[i];
                    if (stepSingle.getStepType() != 14) break block74;
                    ThreadCallPossibleStep threadStep = (ThreadCallPossibleStep)stepSingle;
                    XLogData threadStepXlog = null;
                    if (threadStep.txid != 0L) {
                        threadStepXlog = XLogProxy.getXLogData(xperf.serverId, DateUtil.yyyymmdd((long)xperf.p.endTime), threadStep.txid);
                    }
                    if (threadStepXlog != null) {
                        threadStep.threaded = 1;
                        threadStep.elapsed = threadStepXlog.p.elapsed;
                    }
                    if (threadStep.threaded == 0) break block73;
                }
                tm = (long)stepSingle.start_time + stime;
                cpu = stepSingle.start_cpu;
                boolean ignoreCpu = false;
                if (cpu < 0L) {
                    ignoreCpu = true;
                }
                int p1 = sb.length();
                String pid = String.format("[%06d]", stepSingle.parent);
                sb.append(stepSingle.parent == -1 ? "    -   " : pid);
                sb.append(" ");
                sb.append(String.format("[%06d]", stepSingle.index));
                sb.append(" ");
                sb.append(FormatUtil.print((Object)new Date(tm), (String)"HH:mm:ss.SSS"));
                sb.append("   ");
                slen = sb.length();
                sb.append(String.format("%6s", FormatUtil.print((Object)(tm - prev_tm), (String)"#,##0")));
                int gapTime = CastUtil.cint((Object)(tm - prev_tm));
                int n = elapsedRate = xperf.p.elapsed == 0 ? 0 : CastUtil.cint((Object)((double)gapTime / (double)xperf.p.elapsed * 100.0));
                if (elapsedRate > 50) {
                    sr.add(ProfileText.style(slen, sb.length() - slen, dred, 1));
                } else if (elapsedRate > 20) {
                    sr.add(ProfileText.style(slen, sb.length() - slen, dblue, 1));
                } else if (elapsedRate > 10) {
                    sr.add(ProfileText.style(slen, sb.length() - slen, dgreen, 1));
                }
                sb.append(" ");
                if (ignoreCpu) {
                    sb.append(String.format("%6s", FormatUtil.print((Object)0, (String)"#,##0")));
                } else {
                    sb.append(String.format("%6s", FormatUtil.print((Object)XLogUtil.getCpuTime((Step)stepSingle), (String)"#,##0")));
                }
                sb.append("  ");
                int lineHead = sb.length() - p1;
                int space = 0;
                if (indent.containsKey(stepSingle.parent)) {
                    space = (Integer)indent.get(stepSingle.parent) + 1;
                }
                indent.put(stepSingle.index, space);
                lineHead += space;
                while (space > 0) {
                    sb.append(" ");
                    --space;
                }
                switch (stepSingle.getStepType()) {
                    case 1: {
                        slen = sb.length();
                        int dotPos = ProfileText.toString(sb, (MethodStep)stepSingle, isSimplified);
                        sr.add(ProfileText.style(slen, 1, dyellow, 1));
                        if (isSimplified && dotPos > 0) {
                            sr.add(ProfileText.style(slen + 1, dotPos, dyellow, 0));
                            sr.add(ProfileText.style(slen + dotPos + 1, 1, dyellow, 1));
                            sr.add(ProfileText.style(slen + dotPos + 2, sb.length() - (slen + dotPos + 2), dyellow, 0));
                            break;
                        }
                        sr.add(ProfileText.style(slen + 1, sb.length() - slen + 1, dyellow, 0));
                        break;
                    }
                    case 10: {
                        slen = sb.length();
                        int dotPos = ProfileText.toString(sb, (MethodStep)stepSingle, isSimplified);
                        sr.add(ProfileText.style(slen, 1, dyellow, 1));
                        sr.add(ProfileText.style(slen + 1, sb.length() - slen + 1, dyellow, 0));
                        MethodStep2 m2 = (MethodStep2)stepSingle;
                        if (m2.error == 0) break;
                        slen = sb.length();
                        sb.append("\n").append(TextProxy.error.getText(m2.error));
                        sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                        break;
                    }
                    case 51: {
                        slen = sb.length();
                        ProfileText.toString(sb, (SpanStep)stepSingle);
                        sr.add(ProfileText.style(slen, sb.length() - slen, dgreen, 0));
                        SpanStep spanStep = (SpanStep)stepSingle;
                        if (spanStep.error != 0) {
                            slen = sb.length();
                            sb.append("\n").append(TextProxy.error.getText(spanStep.error));
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                        }
                        if (spanStep.localEndpointServiceName != 0) {
                            slen = sb.length();
                            StringBuilder tempSb = ProfileText.appendSpanEndpoints(date, serverId, (CommonSpanStep)spanStep);
                            sb.append(ProfileText.spacingToNewLine(tempSb.toString(), lineHead + 4));
                            sr.add(ProfileText.style(slen, sb.length() - slen, dyellow, 0));
                        }
                        if (spanStep.tags.size() > 0) {
                            slen = sb.length();
                            ProfileText.appendSpanTags(sb, lineHead, (CommonSpanStep)spanStep);
                            sr.add(ProfileText.style(slen, sb.length() - slen, dyellow, 0));
                        }
                        if (spanStep.annotationTimestamps.size() <= 0) break;
                        slen = sb.length();
                        ProfileText.appendSpanAnnotations(sb, lineHead, (CommonSpanStep)spanStep);
                        sr.add(ProfileText.style(slen, sb.length() - slen, dyellow, 0));
                        break;
                    }
                    case 2: 
                    case 8: 
                    case 16: {
                        SqlStep sql = (SqlStep)stepSingle;
                        slen = sb.length();
                        ProfileText.toString(sb, sql, serverId, lineHead, bindSqlParam);
                        sr.add(ProfileText.style(slen, sb.length() - slen, blue, 0));
                        if (sql.error == 0) break;
                        slen = sb.length();
                        sb.append("\n").append(TextProxy.error.getText(sql.error));
                        sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                        break;
                    }
                    case 3: {
                        slen = sb.length();
                        ProfileText.toString(sb, (MessageStep)stepSingle);
                        sr.add(ProfileText.style(slen, sb.length() - slen, dgreen, 0));
                        break;
                    }
                    case 9: {
                        slen = sb.length();
                        ProfileText.toString(sb, (HashedMessageStep)stepSingle);
                        sr.add(ProfileText.style(slen, sb.length() - slen, dgreen, 0));
                        break;
                    }
                    case 17: {
                        slen = sb.length();
                        ParameterizedMessageStep pmStep = (ParameterizedMessageStep)stepSingle;
                        ProfileText.toString(sb, pmStep);
                        sr.add(ProfileText.style(slen, sb.length() - slen, ProfileText.getColor(pmStep.getLevel()), 0));
                        break;
                    }
                    case 12: {
                        slen = sb.length();
                        ProfileText.toString(sb, (DumpStep)stepSingle, lineHead);
                        sr.add(ProfileText.style(slen, sb.length() - slen, dgray, 0));
                        break;
                    }
                    case 6: 
                    case 15: {
                        ApiCallStep apicall = (ApiCallStep)stepSingle;
                        slen = sb.length();
                        ProfileText.toString(sb, apicall);
                        sr.add(ProfileText.underlineStyle(slen, sb.length() - slen, dmagenta, 0, 4));
                        if (apicall.error == 0) break;
                        slen = sb.length();
                        sb.append("\n").append(TextProxy.error.getText(apicall.error));
                        sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                        break;
                    }
                    case 13: {
                        DispatchStep dispatchStep = (DispatchStep)stepSingle;
                        slen = sb.length();
                        ProfileText.toString(sb, dispatchStep);
                        sr.add(ProfileText.underlineStyle(slen, sb.length() - slen, dmagenta, 0, 4));
                        if (dispatchStep.error == 0) break;
                        slen = sb.length();
                        sb.append("\n").append(TextProxy.error.getText(dispatchStep.error));
                        sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                        break;
                    }
                    case 14: {
                        ThreadCallPossibleStep tcSteap = (ThreadCallPossibleStep)stepSingle;
                        slen = sb.length();
                        ProfileText.toString(sb, tcSteap);
                        sr.add(ProfileText.underlineStyle(slen, sb.length() - slen, dmagenta, 0, 4));
                        break;
                    }
                    case 7: {
                        ThreadSubmitStep threadSubmit = (ThreadSubmitStep)stepSingle;
                        slen = sb.length();
                        ProfileText.toString(sb, threadSubmit);
                        sr.add(ProfileText.underlineStyle(slen, sb.length() - slen, dmagenta, 0, 4));
                        if (threadSubmit.error == 0) break;
                        slen = sb.length();
                        sb.append("\n").append(TextProxy.error.getText(threadSubmit.error));
                        sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                        break;
                    }
                    case 52: {
                        SpanCallStep spanCall = (SpanCallStep)stepSingle;
                        slen = sb.length();
                        ProfileText.toString(sb, spanCall);
                        sr.add(ProfileText.underlineStyle(slen, sb.length() - slen, dmagenta, 0, 4));
                        if (spanCall.error != 0) {
                            slen = sb.length();
                            sb.append("\n").append(TextProxy.error.getText(spanCall.error));
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                        }
                        if (spanCall.localEndpointServiceName != 0) {
                            slen = sb.length();
                            StringBuilder tempSb = ProfileText.appendSpanEndpoints(date, serverId, (CommonSpanStep)spanCall);
                            sb.append(ProfileText.spacingToNewLine(tempSb.toString(), lineHead + 4));
                            sr.add(ProfileText.style(slen, sb.length() - slen, dyellow, 0));
                        }
                        if (spanCall.tags.size() > 0) {
                            slen = sb.length();
                            ProfileText.appendSpanTags(sb, lineHead, (CommonSpanStep)spanCall);
                            sr.add(ProfileText.style(slen, sb.length() - slen, dyellow, 0));
                        }
                        if (spanCall.annotationTimestamps.size() <= 0) break;
                        slen = sb.length();
                        ProfileText.appendSpanAnnotations(sb, lineHead, (CommonSpanStep)spanCall);
                        sr.add(ProfileText.style(slen, sb.length() - slen, dyellow, 0));
                        break;
                    }
                    case 5: {
                        SocketStep socket = (SocketStep)stepSingle;
                        slen = sb.length();
                        ProfileText.toString(sb, socket);
                        sr.add(ProfileText.style(slen, sb.length() - slen, dmagenta, 0));
                        if (socket.error == 0) break;
                        slen = sb.length();
                        sb.append("\n").append(TextProxy.error.getText(socket.error));
                        sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                    }
                }
                sb.append("\n");
                if (!ignoreCpu) {
                    prev_cpu = cpu;
                }
                prev_tm = tm;
            }
            ++i;
        }
        if (!truncated) {
            tm = xperf.p.endTime;
            cpu = xperf.p.cpu;
            sb.append("        ");
            sb.append(" ");
            sb.append("[******]");
            sb.append(" ");
            sb.append(FormatUtil.print((Object)new Date(tm), (String)"HH:mm:ss.SSS"));
            sb.append("   ");
            sb.append(String.format("%6s", FormatUtil.print((Object)(tm - prev_tm), (String)"#,##0")));
            sb.append(" ");
            sb.append(String.format("%6s", FormatUtil.print((Object)(cpu - prev_cpu), (String)"#,##0")));
            sb.append("  end of transaction \n");
        }
        sb.append("------------------------------------------------------------------------------------------\n");
        text.setText(sb.toString());
        text.setStyleRanges(sr.toArray(new StyleRange[sr.size()]));
    }

    private static void appendSpanAnnotations(StringBuffer sb, int lineHead, CommonSpanStep spanStep) {
        try {
            sb.append(ProfileText.spacingToNewLine(">[annotations]", lineHead + 4));
            int annotCount = 0;
            while (annotCount < spanStep.annotationTimestamps.size()) {
                String annotMessage = String.valueOf(FormatUtil.print((Object)new Date(spanStep.annotationTimestamps.getLong(annotCount)), (String)"HH:mm:ss.SSS")) + " " + spanStep.annotationValues.getString(annotCount);
                sb.append(ProfileText.spacing(annotMessage, lineHead + 11));
                ++annotCount;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void appendSpanTags(StringBuffer sb, int lineHead, CommonSpanStep spanStep) {
        String tagsString = spanStep.tags.keySet().stream().map(k -> String.valueOf(k) + ": " + commonSpanStep.tags.getText(k)).collect(Collectors.joining("\n"));
        sb.append(ProfileText.spacingToNewLine(">[tags]", lineHead + 4));
        sb.append(ProfileText.spacing(tagsString, lineHead + 11));
    }

    private static StringBuilder appendSpanEndpoints(String date, int serverId, CommonSpanStep spanStep) {
        StringBuilder tempSb = new StringBuilder();
        tempSb.append(">[LE]").append(TextProxy.object.getLoadText(date, spanStep.localEndpointServiceName, serverId)).append(":").append(IPUtil.toString((byte[])spanStep.localEndpointIp)).append(":").append(spanStep.localEndpointPort);
        if (spanStep.remoteEndpointServiceName != 0) {
            tempSb.append("[RE]").append(TextProxy.object.getLoadText(date, spanStep.localEndpointServiceName, serverId)).append(":").append(IPUtil.toString((byte[])spanStep.remoteEndpointIp)).append(":").append(spanStep.remoteEndpointPort);
        }
        return tempSb;
    }

    public static void buildThreadProfile(XLogData data, StyledText text, Step[] profiles) {
        long stime;
        if (profiles == null) {
            profiles = new Step[]{};
        }
        int serverId = data.serverId;
        String date = DateUtil.yyyymmdd((long)data.p.endTime);
        profiles = SortUtil.sort((Step[])profiles);
        XLogUtil.loadStepText(serverId, date, profiles);
        Color blue = text.getDisplay().getSystemColor(9);
        Color dmagenta = text.getDisplay().getSystemColor(12);
        Color red = text.getDisplay().getSystemColor(3);
        Color dred = text.getDisplay().getSystemColor(4);
        Color dgreen = text.getDisplay().getSystemColor(6);
        ArrayList<StyleRange> sr = new ArrayList<StyleRange>();
        int slen = 0;
        StringBuffer sb = new StringBuffer();
        sb.append("------------------------------------------------------------------------------------------\n");
        sb.append("    p#      #    \t  TIME         T-GAP   CPU          CONTENTS\n");
        sb.append("------------------------------------------------------------------------------------------\n");
        if (profiles.length == 0) {
            sb.append("\n                     ( No xlog profile collected ) ");
            text.setText(sb.toString());
            text.setStyleRanges(sr.toArray(new StyleRange[sr.size()]));
            return;
        }
        long prev_tm = stime = data.p.endTime - (long)data.p.elapsed;
        long tm = stime;
        int prev_cpu = -1;
        int cpu = 0;
        int sumCnt = 1;
        HashMap<Integer, Integer> indent = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < profiles.length) {
            if (profiles[i] instanceof StepSummary) {
                sb.append("        ").append(" ");
                sb.append(String.format("[%06d]", sumCnt++));
                sb.append(" ");
                StepSummary sum = (StepSummary)profiles[i];
                switch (sum.getStepType()) {
                    case 11: {
                        MethodSum p = (MethodSum)sum;
                        slen = sb.length();
                        String m = TextProxy.method.getText(p.hash);
                        if (m == null) {
                            m = Hexa32.toString32((long)p.hash);
                        }
                        sb.append(m).append(" ");
                        sr.add(ProfileText.style(slen, sb.length() - slen, blue, 0));
                        sb.append(" count=").append(FormatUtil.print((Object)p.count, (String)"#,##0"));
                        sb.append(" time=").append(FormatUtil.print((Object)p.elapsed, (String)"#,##0")).append(" ms");
                        sb.append(" cpu=").append(FormatUtil.print((Object)p.cputime, (String)"#,##0"));
                        sb.append("\n");
                        break;
                    }
                    case 21: {
                        SqlSum sql = (SqlSum)sum;
                        slen = sb.length();
                        ProfileText.toString(sb, sql, serverId);
                        sr.add(ProfileText.style(slen, sb.length() - slen, blue, 0));
                        sb.append("\n");
                        break;
                    }
                    case 43: {
                        ApiCallSum apicall = (ApiCallSum)sum;
                        slen = sb.length();
                        ProfileText.toString(sb, apicall);
                        sr.add(ProfileText.style(slen, sb.length() - slen, dmagenta, 0));
                        sb.append("\n");
                        break;
                    }
                    case 42: {
                        SocketSum socketSum = (SocketSum)sum;
                        slen = sb.length();
                        ProfileText.toString(sb, socketSum);
                        sr.add(ProfileText.style(slen, sb.length() - slen, dmagenta, 0));
                        sb.append("\n");
                        break;
                    }
                    case 99: {
                        sb.delete(sb.length() - 9, sb.length());
                        sb.append("[******]");
                        sb.append(" ");
                        sb.append(FormatUtil.print((Object)new Date(data.p.endTime), (String)"HH:mm:ss.SSS"));
                        sb.append("   ");
                        sb.append(String.format("%6s", FormatUtil.print((Object)data.p.elapsed, (String)"#,##0")));
                        sb.append(" ");
                        sb.append(String.format("%6s", FormatUtil.print((Object)data.p.cpu, (String)"#,##0")));
                        sb.append("  ");
                        slen = sb.length();
                        ProfileText.toString(sb, (StepControl)sum);
                        sr.add(ProfileText.style(slen, sb.length() - slen, dred, 0));
                        sb.append("\n");
                    }
                }
            } else {
                StepSingle stepSingle = (StepSingle)profiles[i];
                if (stepSingle.getStepType() != 14 || ((ThreadCallPossibleStep)stepSingle).threaded != 0) {
                    tm = stime + (long)stepSingle.start_time;
                    cpu = stepSingle.start_cpu;
                    int p1 = sb.length();
                    String pid = String.format("[%06d]", stepSingle.parent);
                    sb.append(stepSingle.parent == -1 ? "    -   " : pid);
                    sb.append(" ");
                    sb.append(String.format("[%06d]", stepSingle.index));
                    sb.append(" ");
                    sb.append(FormatUtil.print((Object)new Date(tm), (String)"HH:mm:ss.SSS"));
                    sb.append("   ");
                    sb.append(String.format("%6s", FormatUtil.print((Object)(tm - prev_tm), (String)"#,##0")));
                    sb.append(" ");
                    if (prev_cpu == -1) {
                        sb.append(String.format("%6s", FormatUtil.print((Object)0, (String)"#,##0")));
                    } else {
                        sb.append(String.format("%6s", FormatUtil.print((Object)XLogUtil.getCpuTime((Step)stepSingle), (String)"#,##0")));
                    }
                    sb.append("  ");
                    int lineHead = sb.length() - p1;
                    int space = 0;
                    if (indent.containsKey(stepSingle.parent)) {
                        space = (Integer)indent.get(stepSingle.parent) + 1;
                    }
                    indent.put(stepSingle.index, space);
                    lineHead += space;
                    while (space > 0) {
                        sb.append(" ");
                        --space;
                    }
                    switch (stepSingle.getStepType()) {
                        case 1: {
                            ProfileText.toString(sb, (MethodStep)stepSingle, false);
                            break;
                        }
                        case 10: {
                            ProfileText.toString(sb, (MethodStep)stepSingle, false);
                            MethodStep2 m2 = (MethodStep2)stepSingle;
                            if (m2.error == 0) break;
                            slen = sb.length();
                            sb.append("\n").append(TextProxy.error.getText(m2.error));
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                            break;
                        }
                        case 2: 
                        case 8: 
                        case 16: {
                            SqlStep sql = (SqlStep)stepSingle;
                            slen = sb.length();
                            ProfileText.toString(sb, sql, serverId, lineHead, false);
                            sr.add(ProfileText.style(slen, sb.length() - slen, blue, 0));
                            if (sql.error == 0) break;
                            slen = sb.length();
                            sb.append("\n").append(TextProxy.error.getText(sql.error));
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                            break;
                        }
                        case 3: {
                            slen = sb.length();
                            ProfileText.toString(sb, (MessageStep)stepSingle);
                            sr.add(ProfileText.style(slen, sb.length() - slen, dgreen, 0));
                            break;
                        }
                        case 9: {
                            slen = sb.length();
                            ProfileText.toString(sb, (HashedMessageStep)stepSingle);
                            sr.add(ProfileText.style(slen, sb.length() - slen, dgreen, 0));
                            break;
                        }
                        case 17: {
                            slen = sb.length();
                            ParameterizedMessageStep pmStep = (ParameterizedMessageStep)stepSingle;
                            ProfileText.toString(sb, pmStep);
                            sr.add(ProfileText.style(slen, sb.length() - slen, ProfileText.getColor(pmStep.getLevel()), 0));
                            break;
                        }
                        case 12: {
                            slen = sb.length();
                            ProfileText.toString(sb, (DumpStep)stepSingle, lineHead);
                            sr.add(ProfileText.style(slen, sb.length() - slen, dgreen, 0));
                            break;
                        }
                        case 6: 
                        case 15: {
                            ApiCallStep apicall = (ApiCallStep)stepSingle;
                            slen = sb.length();
                            ProfileText.toString(sb, apicall);
                            sr.add(ProfileText.underlineStyle(slen, sb.length() - slen, dmagenta, 0, 4));
                            if (apicall.error == 0) break;
                            slen = sb.length();
                            sb.append("\n").append(TextProxy.error.getText(apicall.error));
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                            break;
                        }
                        case 13: {
                            DispatchStep step = (DispatchStep)stepSingle;
                            slen = sb.length();
                            ProfileText.toString(sb, step);
                            sr.add(ProfileText.underlineStyle(slen, sb.length() - slen, dmagenta, 0, 4));
                            if (step.error == 0) break;
                            slen = sb.length();
                            sb.append("\n").append(TextProxy.error.getText(step.error));
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                            break;
                        }
                        case 14: {
                            ThreadCallPossibleStep tcSteap = (ThreadCallPossibleStep)stepSingle;
                            slen = sb.length();
                            ProfileText.toString(sb, tcSteap);
                            sr.add(ProfileText.underlineStyle(slen, sb.length() - slen, dmagenta, 0, 4));
                            break;
                        }
                        case 7: {
                            ThreadSubmitStep threadSubmit = (ThreadSubmitStep)stepSingle;
                            slen = sb.length();
                            ProfileText.toString(sb, threadSubmit);
                            sr.add(ProfileText.underlineStyle(slen, sb.length() - slen, dmagenta, 0, 4));
                            if (threadSubmit.error == 0) break;
                            slen = sb.length();
                            sb.append("\n").append(TextProxy.error.getText(threadSubmit.error));
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                            break;
                        }
                        case 5: {
                            SocketStep socket = (SocketStep)stepSingle;
                            slen = sb.length();
                            ProfileText.toString(sb, socket);
                            sr.add(ProfileText.style(slen, sb.length() - slen, dmagenta, 0));
                            if (socket.error == 0) break;
                            slen = sb.length();
                            sb.append("\n").append(TextProxy.error.getText(socket.error));
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                        }
                    }
                    sb.append("\n");
                    prev_cpu = cpu;
                    prev_tm = tm;
                }
            }
            ++i;
        }
        sb.append("------------------------------------------------------------------------------------------\n");
        text.setText(sb.toString());
        text.setStyleRanges(sr.toArray(new StyleRange[sr.size()]));
    }

    public static void toString(StringBuffer sb, ApiCallStep p) {
        String m = TextProxy.apicall.getText(p.hash);
        if (m == null) {
            m = Hexa32.toString32((long)p.hash);
        }
        sb.append("call: ").append(m).append(" ").append(FormatUtil.print((Object)p.elapsed, (String)"#,##0")).append(" ms");
        if (p.txid != 0L) {
            if (p instanceof ApiCallStep2 && ((ApiCallStep2)p).async == 1) {
                sb.append(" [async]");
            }
            if (p.address != null) {
                sb.append(" [" + p.address + "]");
            }
        }
        if (p.txid != 0L) {
            sb.append(" <" + Hexa32.toString32((long)p.txid) + ">");
        }
    }

    public static void toString(StringBuffer sb, SpanCallStep p) {
        String m = TextProxy.service.getText(p.hash);
        if (m == null) {
            m = Hexa32.toString32((long)p.hash);
        }
        sb.append("call: ").append(m).append(" ").append(FormatUtil.print((Object)p.elapsed, (String)"#,##0")).append(" ms");
        if (p.txid != 0L && p.address != null) {
            sb.append(" [" + p.address + "]");
        }
        if (p.txid != 0L) {
            sb.append(" <" + Hexa32.toString32((long)p.txid) + ">");
        }
    }

    public static void toString(StringBuffer sb, DispatchStep step) {
        String m = TextProxy.apicall.getText(step.hash);
        if (m == null) {
            m = Hexa32.toString32((long)step.hash);
        }
        sb.append("call: ").append(m).append(" ").append(FormatUtil.print((Object)step.elapsed, (String)"#,##0")).append(" ms");
        if (step.txid != 0L) {
            sb.append(" <" + Hexa32.toString32((long)step.txid) + ">");
        }
    }

    public static void toString(StringBuffer sb, ThreadCallPossibleStep step) {
        String m = TextProxy.apicall.getText(step.hash);
        if (m == null) {
            m = Hexa32.toString32((long)step.hash);
        }
        sb.append("call:thread: ").append(m).append(" ").append(FormatUtil.print((Object)step.elapsed, (String)"#,##0")).append(" ms");
        if (step.txid != 0L) {
            sb.append(" <" + Hexa32.toString32((long)step.txid) + ">");
        }
    }

    public static void toString(StringBuffer sb, HashedMessageStep p) {
        String m = TextProxy.hashMessage.getText(p.hash);
        if (m == null) {
            m = Hexa32.toString32((long)p.hash);
        }
        if (p.time != -1) {
            sb.append(m).append(" #").append(FormatUtil.print((Object)p.value, (String)"#,##0")).append(" ").append(FormatUtil.print((Object)p.time, (String)"#,##0")).append(" ms");
        } else {
            sb.append(m);
        }
    }

    public static void toString(StringBuffer sb, ParameterizedMessageStep pmStep) {
        String messageFormat = TextProxy.hashMessage.getText(pmStep.getHash());
        String message = messageFormat == null ? Hexa32.toString32((long)pmStep.getHash()) : pmStep.buildMessasge(messageFormat);
        sb.append(message);
        if (pmStep.getElapsed() != -1) {
            sb.append(" [").append(FormatUtil.print((Object)pmStep.getElapsed(), (String)"#,##0")).append(" ms]");
        }
    }

    public static void toString(StringBuffer sb, DumpStep p, int lineHead) {
        sb.append("<auto generated thread dump>:[").append(p.threadId).append("] ").append(p.threadName).append('\n');
        sb.append(StringUtil.leftPad((String)"", (int)lineHead)).append("   -> State : ").append(p.threadState).append('\n');
        if (StringUtil.isNotEmpty((String)p.lockName)) {
            sb.append(StringUtil.leftPad((String)"", (int)lineHead)).append("   -> Lock : ").append(p.lockName).append('\n');
        }
        if (StringUtil.isNotEmpty((String)p.lockOwnerName)) {
            sb.append(StringUtil.leftPad((String)"", (int)lineHead)).append("   -> Lock Owner : ").append(p.lockOwnerName).append('\n');
        }
        if (p.lockOwnerId > 0L) {
            sb.append(StringUtil.leftPad((String)"", (int)lineHead)).append("   -> Lock Owner Id ").append(p.lockOwnerId).append('\n');
        }
        int[] nArray = p.stacks;
        int n = p.stacks.length;
        int n2 = 0;
        while (n2 < n) {
            int stackElementHash = nArray[n2];
            String m = TextProxy.stackElement.getText(stackElementHash);
            if (m == null) {
                m = Hexa32.toString32((long)stackElementHash);
            }
            sb.append(StringUtil.leftPad((String)"", (int)lineHead)).append(m).append('\n');
            ++n2;
        }
    }

    public static void toString(StringBuffer sb, ThreadSubmitStep p) {
        String m = TextProxy.apicall.getText(p.hash);
        if (m == null) {
            m = Hexa32.toString32((long)p.hash);
        }
        sb.append("thread: ").append(m).append(" ").append(FormatUtil.print((Object)p.elapsed, (String)"#,##0")).append(" ms");
        if (p.txid != 0L) {
            sb.append(" <" + Hexa32.toString32((long)p.txid) + ">");
        }
    }

    public static void toString(StringBuffer sb, SocketStep p) {
        String ip = IPUtil.toString((byte[])p.ipaddr);
        sb.append("socket: ").append(ip == null ? "unknown" : ip).append(":").append(String.valueOf(p.port) + " ").append(FormatUtil.print((Object)p.elapsed, (String)"#,##0")).append(" ms");
    }

    public static void toString(StringBuffer sb, ApiCallSum p) {
        String m = TextProxy.apicall.getText(p.hash);
        if (m == null) {
            m = Hexa32.toString32((long)p.hash);
        }
        sb.append("call: ").append(m).append(" ");
        sb.append(" count=").append(FormatUtil.print((Object)p.count, (String)"#,##0"));
        sb.append(" time=").append(FormatUtil.print((Object)p.elapsed, (String)"#,##0")).append(" ms");
        sb.append(" cpu=").append(FormatUtil.print((Object)p.cputime, (String)"#,##0"));
        if (p.error > 0) {
            sb.append(" error=").append(FormatUtil.print((Object)p.error, (String)"#,##0"));
        }
    }

    public static void toString(StringBuffer sb, SocketSum p) {
        String ip = IPUtil.toString((byte[])p.ipaddr);
        sb.append("socket: ").append(ip == null ? "unknown" : ip).append(":").append(String.valueOf(p.port) + " ");
        sb.append(" count=").append(FormatUtil.print((Object)p.count, (String)"#,##0"));
        sb.append(" time=").append(FormatUtil.print((Object)p.elapsed, (String)"#,##0")).append(" ms");
        if (p.error > 0) {
            sb.append(" error=").append(FormatUtil.print((Object)p.error, (String)"#,##0"));
        }
    }

    public static void toString(StringBuffer sb, SqlStep p, int serverId, int lineHead, boolean bindParam) {
        if (p instanceof SqlStep2) {
            sb.append(SqlXType.toString((byte)((SqlStep2)p).xtype));
        }
        String m = TextProxy.sql.getText(p.hash);
        if ((m = ProfileText.spacing(m, lineHead)) == null) {
            m = Hexa32.toString32((long)p.hash);
        }
        Server server = ServerManager.getInstance().getServer(serverId);
        boolean showParam = true;
        if (server != null) {
            showParam = server.isAllowAction("AllowSqlParameter");
        }
        if (showParam && bindParam) {
            sb.append(SqlMakerUtil.replaceSQLParameter(m, p.param));
        } else {
            sb.append(m);
        }
        if (!StringUtil.isEmpty((String)p.param) && !bindParam) {
            sb.append("\n").append(StringUtil.leftPad((String)"", (int)lineHead));
            sb.append("[").append(showParam ? p.param : "******").append("]");
        }
        if (p instanceof SqlStep3) {
            int updatedCount = ((SqlStep3)p).updated;
            if (updatedCount > -1) {
                sb.append(" <Affected Rows : " + updatedCount + ">");
            } else if (updatedCount == -2) {
                sb.append(" <Affected Rows : unknown>");
            }
        }
        sb.append(" ").append(FormatUtil.print((Object)p.elapsed, (String)"#,##0")).append(" ms");
    }

    public static String spacing(String m, int lineHead) {
        if (m == null) {
            return m;
        }
        String dummy = StringUtil.leftPad((String)"", (int)lineHead);
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader sr = new BufferedReader(new StringReader(m));
            String s = null;
            while ((s = sr.readLine()) != null) {
                if ((s = StringUtil.trim((String)s)).length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append("\n").append(dummy);
                }
                sb.append(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String spacingToNewLine(String m, int lineHead) {
        if (m == null) {
            return m;
        }
        String dummy = StringUtil.leftPad((String)"", (int)lineHead);
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader sr = new BufferedReader(new StringReader(m));
            String s = null;
            while ((s = sr.readLine()) != null) {
                if (s.length() <= 0) continue;
                sb.append("\n").append(dummy).append(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void toString(StringBuffer sb, SqlSum p, int serverId) {
        String m = TextProxy.sql.getText(p.hash);
        if (m == null) {
            m = Hexa32.toString32((long)p.hash);
        }
        sb.append(m);
        if (!StringUtil.isEmpty((String)p.param)) {
            Server server = ServerManager.getInstance().getServer(serverId);
            boolean showParam = server.isAllowAction("AllowSqlParameter");
            sb.append(" [").append(showParam ? p.param : "******").append("]");
        }
        sb.append(" count=").append(FormatUtil.print((Object)p.count, (String)"#,##0"));
        sb.append(" time=").append(FormatUtil.print((Object)p.elapsed, (String)"#,##0")).append(" ms");
        sb.append(" cpu=").append(FormatUtil.print((Object)p.cputime, (String)"#,##0"));
        if (p.error > 0) {
            sb.append(" error=").append(FormatUtil.print((Object)p.error, (String)"#,##0"));
        }
    }

    public static void toString(StringBuffer sb, MessageStep p) {
        sb.append(p.message);
    }

    public static void toString(StringBuffer sb, StepControl p) {
        sb.append(p.message);
    }

    public static int toString(StringBuffer sb, MethodStep p, boolean isSimplified) {
        String m = TextProxy.method.getText(p.hash);
        if (m == null) {
            m = Hexa32.toString32((long)p.hash);
        }
        if (isSimplified) {
            String simple = ProfileText.simplifyMethod(m);
            sb.append(simple).append(" [").append(FormatUtil.print((Object)p.elapsed, (String)"#,##0")).append("ms]").append(" -- ").append(m);
            return simple.indexOf(35);
        }
        sb.append(m).append(" ").append(FormatUtil.print((Object)p.elapsed, (String)"#,##0")).append(" ms");
        return m.indexOf(46);
    }

    public static void toString(StringBuffer sb, SpanStep p) {
        String m = TextProxy.service.getText(p.hash);
        if (m == null) {
            m = Hexa32.toString32((long)p.hash);
        }
        sb.append(m).append(" ").append(FormatUtil.print((Object)p.elapsed, (String)"#,##0")).append(" ms");
    }

    public static String simplifyMethod(String method) {
        String[] parts = StringUtil.split((String)method, (char)'.');
        if (parts.length >= 2) {
            String methodName = parts[parts.length - 1];
            int bracePos = methodName.indexOf(40);
            if (bracePos <= 0) {
                return method;
            }
            return String.valueOf(parts[parts.length - 2]) + "#" + methodName.substring(0, bracePos) + "()";
        }
        return method;
    }

    public static StyleRange style(int start, int length, Color c, int f) {
        StyleRange t = new StyleRange();
        t.start = start;
        t.length = length;
        t.foreground = c;
        t.fontStyle = f;
        return t;
    }

    public static StyleRange style(int start, int length, int f) {
        StyleRange t = new StyleRange();
        t.start = start;
        t.length = length;
        t.fontStyle = f;
        return t;
    }

    public static StyleRange style(int start, int length, Color c, int f, Color backc) {
        StyleRange t = new StyleRange();
        t.start = start;
        t.length = length;
        t.foreground = c;
        t.fontStyle = f;
        t.background = backc;
        return t;
    }

    public static StyleRange underlineStyle(int start, int length, Color c, int fontStyle, int underlineStyle) {
        StyleRange t = new StyleRange();
        t.start = start;
        t.length = length;
        t.foreground = c;
        t.fontStyle = fontStyle;
        t.underline = true;
        t.underlineStyle = underlineStyle;
        return t;
    }
}

