/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import scouter.client.model.TextProxy;
import scouter.client.util.StepWrapper;
import scouter.client.xlog.ProfileText;
import scouter.client.xlog.views.XLogProfileView;
import scouter.lang.pack.XLogPack;
import scouter.lang.step.ApiCallStep;
import scouter.lang.step.ApiCallSum;
import scouter.lang.step.DispatchStep;
import scouter.lang.step.HashedMessageStep;
import scouter.lang.step.MessageStep;
import scouter.lang.step.MethodStep;
import scouter.lang.step.MethodStep2;
import scouter.lang.step.MethodSum;
import scouter.lang.step.ParameterizedMessageStep;
import scouter.lang.step.SocketStep;
import scouter.lang.step.SocketSum;
import scouter.lang.step.SqlStep;
import scouter.lang.step.SqlSum;
import scouter.lang.step.StepSingle;
import scouter.lang.step.StepSummary;
import scouter.lang.step.ThreadCallPossibleStep;
import scouter.util.FormatUtil;
import scouter.util.Hexa32;
import scouter.util.IPUtil;
import scouter.util.StringUtil;

public class ProfileTextFull {
    public static void buildXLogData(String date, StyledText text, XLogPack p, int serverId) {
        String t;
        int servId = serverId;
        String error = TextProxy.error.getLoadText(date, p.error, servId);
        String objName = TextProxy.object.getLoadText(date, p.objHash, servId);
        int slen = 0;
        ArrayList<StyleRange> sr = new ArrayList<StyleRange>();
        Color red = text.getDisplay().getSystemColor(3);
        StringBuffer sb = new StringBuffer();
        sb.append("\u25ba txid    = ").append(Hexa32.toString32((long)p.txid)).append("\n");
        sb.append("\u25ba objName = ").append(objName).append("\n");
        sb.append("\u25ba endtime = ").append(FormatUtil.print((Object)new Date(p.endTime), (String)"yyyyMMdd HH:mm:ss.SSS")).append("\n");
        sb.append("\u25ba elapsed = ").append(FormatUtil.print((Object)p.elapsed, (String)"#,##0")).append(" ms\n");
        sb.append("\u25ba service = ").append(TextProxy.service.getText(p.service)).append("\n");
        if (error != null) {
            sb.append("\u25ba error   = ");
            slen = sb.length();
            sb.append(error).append("\n");
            sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
        }
        sb.append("\u25ba ipaddr=" + IPUtil.toString((byte[])p.ipaddr) + ", ");
        sb.append("userid=" + p.userid);
        sb.append("\n\u25ba cpu=" + FormatUtil.print((Object)p.cpu, (String)"#,##0") + " ms, ");
        sb.append("kbytes=" + p.kbytes + ", ");
        sb.append("status=" + p.status);
        if (p.sqlCount > 0) {
            sb.append("\n\u25ba sqlCount=" + p.sqlCount + ", ");
            sb.append("sqlTime=" + FormatUtil.print((Object)p.sqlTime, (String)"#,##0") + " ms");
        }
        if (p.apicallCount > 0) {
            sb.append("\n\u25ba ApiCallCount=" + p.apicallCount + ", ");
            sb.append("ApiCallTime=" + FormatUtil.print((Object)p.apicallTime, (String)"#,##0") + " ms");
        }
        if (StringUtil.isNotEmpty((String)(t = TextProxy.userAgent.getLoadText(date, p.userAgent, serverId)))) {
            sb.append("\n\u25ba userAgent=" + t);
        }
        if (StringUtil.isNotEmpty((String)(t = TextProxy.referer.getLoadText(date, p.referer, serverId)))) {
            sb.append("\n\u25ba referer=" + t);
        }
        if (StringUtil.isNotEmpty((String)(t = TextProxy.group.getLoadText(date, p.group, serverId)))) {
            sb.append("\n\u25ba group=" + t);
        }
        if (p.hasDump == 1) {
            sb.append("\n\u25ba dump=Y");
        }
        sb.append("\n");
        text.setText(sb.toString());
        text.setStyleRanges(sr.toArray(new StyleRange[sr.size()]));
    }

    public static void buildProfile(String date, StyledText text, XLogPack pack, StepWrapper[] orgProfiles, int pageNum, int rowPerPage, Button prevBtn, Button nextBtn, Button startBtn, Button endBtn, int length, int serverId, int searchLineIndex, boolean isSummary) {
        long stime;
        String spaceStr = "";
        String astarStr = "";
        int j = 0;
        while (j < length) {
            spaceStr = String.valueOf(spaceStr) + " ";
            astarStr = String.valueOf(astarStr) + "*";
            ++j;
        }
        if (orgProfiles == null) {
            orgProfiles = new StepWrapper[]{};
        }
        boolean lastPage = false;
        int startIdx = pageNum * rowPerPage;
        int lastIdx = pageNum * rowPerPage + rowPerPage;
        if (lastIdx >= orgProfiles.length) {
            lastIdx = orgProfiles.length;
            lastPage = true;
        }
        int ix = 0;
        StepWrapper[] profiles = new StepWrapper[lastIdx - startIdx];
        int inx = startIdx;
        while (inx < lastIdx) {
            profiles[ix] = orgProfiles[inx];
            ++ix;
            ++inx;
        }
        int slen = 0;
        ArrayList<StyleRange> sr = new ArrayList<StyleRange>();
        Color blue = text.getDisplay().getSystemColor(9);
        Color dmagenta = text.getDisplay().getSystemColor(12);
        Color red = text.getDisplay().getSystemColor(3);
        Color yellow = text.getDisplay().getSystemColor(7);
        Color dgreen = text.getDisplay().getSystemColor(6);
        StringBuffer sb = new StringBuffer();
        sb.append("------------------------------------------------------------------------------------------\n");
        sb.append("  p# " + spaceStr + "# " + spaceStr + " TIME         T-GAP   CPU          CONTENTS\n");
        sb.append("------------------------------------------------------------------------------------------\n");
        if (profiles.length == 0) {
            sb.append("\n                     ( No xlog profile collected ) ");
            text.setText(sb.toString());
            text.setStyleRanges(sr.toArray(new StyleRange[sr.size()]));
            return;
        }
        long prev_tm = stime = pack.endTime - (long)pack.elapsed;
        if (pageNum > 0) {
            prev_tm = orgProfiles[startIdx - 1].time;
        }
        long prev_cpu = 0L;
        if (pageNum > 0) {
            prev_cpu = orgProfiles[startIdx - 1].cpu;
        }
        if (pageNum == 0) {
            sb.append(" " + spaceStr + " ");
            sb.append(" ");
            sb.append("[" + astarStr + "]");
            sb.append(" ");
            sb.append(FormatUtil.print((Object)new Date(stime), (String)"HH:mm:ss.SSS"));
            sb.append("   ");
            sb.append(String.format("%6s", "0"));
            sb.append(" ");
            sb.append(String.format("%6s", "0"));
            sb.append("  start transaction \n");
        }
        long tm = pack.endTime;
        long cpu = pack.cpu;
        int i = 0;
        while (i < profiles.length) {
            if (profiles[i].step instanceof StepSummary) {
                int p1 = sb.length();
                sb.append(spaceStr).append("   ");
                sb.append(String.format("[%0" + length + "d]", profiles[i].sSummaryIdx));
                sb.append(" ");
                int lineHead = sb.length() - p1;
                StepSummary sum = (StepSummary)profiles[i].step;
                switch (sum.getStepType()) {
                    case 11: {
                        MethodSum p = (MethodSum)sum;
                        slen = sb.length();
                        String m = TextProxy.method.getText(p.hash);
                        if (m == null) {
                            m = Hexa32.toString32((long)p.hash);
                        }
                        sb.append(m).append(" ");
                        if (searchLineIndex == profiles[i].sSummaryIdx) {
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 1, yellow));
                        } else {
                            sr.add(ProfileText.style(slen, sb.length() - slen, blue, 0));
                        }
                        sb.append(" count=").append(FormatUtil.print((Object)p.count, (String)"#,##0"));
                        sb.append(" time=").append(FormatUtil.print((Object)p.elapsed, (String)"#,##0")).append(" ms");
                        sb.append(" cpu=").append(FormatUtil.print((Object)p.cputime, (String)"#,##0"));
                        sb.append("\n");
                        break;
                    }
                    case 21: {
                        SqlSum sql = (SqlSum)sum;
                        slen = sb.length();
                        ProfileText.toString(sb, sql, serverId);
                        if (searchLineIndex == profiles[i].sSummaryIdx) {
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 1, yellow));
                        } else {
                            sr.add(ProfileText.style(slen, sb.length() - slen, blue, 0));
                        }
                        sb.append("\n");
                        break;
                    }
                    case 43: {
                        ApiCallSum apicall = (ApiCallSum)sum;
                        slen = sb.length();
                        ProfileText.toString(sb, apicall);
                        if (searchLineIndex == profiles[i].sSummaryIdx) {
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 1, yellow));
                        } else {
                            sr.add(ProfileText.style(slen, sb.length() - slen, dmagenta, 0));
                        }
                        sb.append("\n");
                        break;
                    }
                    case 42: {
                        XLogProfileView.isSummary = true;
                        SocketSum socketSum = (SocketSum)sum;
                        slen = sb.length();
                        ProfileText.toString(sb, socketSum);
                        sr.add(ProfileText.style(slen, sb.length() - slen, dmagenta, 0));
                        sb.append("\n");
                    }
                }
            } else {
                StepSingle stepSingle = (StepSingle)profiles[i].step;
                if (stepSingle.getStepType() != 14 || ((ThreadCallPossibleStep)stepSingle).threaded != 0) {
                    tm = profiles[i].time;
                    cpu = profiles[i].cpu;
                    int p1 = sb.length();
                    String pid = String.format("[%0" + length + "d]", stepSingle.parent);
                    sb.append(stepSingle.parent == -1 ? String.valueOf(spaceStr) + "  " : pid);
                    sb.append(" ");
                    sb.append(String.format("[%0" + length + "d]", stepSingle.index));
                    sb.append(" ");
                    sb.append(FormatUtil.print((Object)new Date(tm), (String)"HH:mm:ss.SSS"));
                    sb.append("   ");
                    sb.append(String.format("%6s", FormatUtil.print((Object)(tm - prev_tm), (String)"#,##0")));
                    sb.append(" ");
                    sb.append(String.format("%6s", FormatUtil.print((Object)(cpu - prev_cpu), (String)"#,##0")));
                    sb.append("  ");
                    int lineHead = sb.length() - p1;
                    int space = profiles[i].indent;
                    while (space > 0) {
                        sb.append(" ");
                        --space;
                    }
                    switch (stepSingle.getStepType()) {
                        case 1: {
                            slen = sb.length();
                            ProfileText.toString(sb, (MethodStep)stepSingle, false);
                            if (searchLineIndex != stepSingle.index) break;
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 1, yellow));
                            break;
                        }
                        case 10: {
                            slen = sb.length();
                            ProfileText.toString(sb, (MethodStep)stepSingle, false);
                            if (searchLineIndex == stepSingle.index) {
                                sr.add(ProfileText.style(slen, sb.length() - slen, red, 1, yellow));
                            }
                            MethodStep2 m2 = (MethodStep2)stepSingle;
                            if (m2.error == 0) break;
                            slen = sb.length();
                            sb.append("\n").append(TextProxy.error.getText(m2.error));
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                            break;
                        }
                        case 2: 
                        case 8: 
                        case 16: {
                            SqlStep sql = (SqlStep)stepSingle;
                            slen = sb.length();
                            ProfileText.toString(sb, sql, serverId, lineHead, false);
                            if (searchLineIndex == stepSingle.index) {
                                sr.add(ProfileText.style(slen, sb.length() - slen, red, 1, yellow));
                            } else {
                                sr.add(ProfileText.style(slen, sb.length() - slen, blue, 0));
                            }
                            if (sql.error == 0) break;
                            slen = sb.length();
                            sb.append("\n").append(TextProxy.error.getText(sql.error));
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                            break;
                        }
                        case 3: {
                            slen = sb.length();
                            ProfileText.toString(sb, (MessageStep)stepSingle);
                            if (searchLineIndex == stepSingle.index) {
                                sr.add(ProfileText.style(slen, sb.length() - slen, red, 1, yellow));
                                break;
                            }
                            sr.add(ProfileText.style(slen, sb.length() - slen, dgreen, 0));
                            break;
                        }
                        case 9: {
                            slen = sb.length();
                            ProfileText.toString(sb, (HashedMessageStep)stepSingle);
                            if (searchLineIndex == stepSingle.index) {
                                sr.add(ProfileText.style(slen, sb.length() - slen, red, 1, yellow));
                                break;
                            }
                            sr.add(ProfileText.style(slen, sb.length() - slen, dgreen, 0));
                            break;
                        }
                        case 17: {
                            slen = sb.length();
                            ParameterizedMessageStep pmStep = (ParameterizedMessageStep)stepSingle;
                            ProfileText.toString(sb, pmStep);
                            if (searchLineIndex == stepSingle.index) {
                                sr.add(ProfileText.style(slen, sb.length() - slen, red, 1, yellow));
                                break;
                            }
                            sr.add(ProfileText.style(slen, sb.length() - slen, ProfileText.getColor(pmStep.getLevel()), 0));
                            break;
                        }
                        case 6: 
                        case 15: {
                            ApiCallStep apicall = (ApiCallStep)stepSingle;
                            slen = sb.length();
                            ProfileText.toString(sb, apicall);
                            if (searchLineIndex == stepSingle.index) {
                                sr.add(ProfileText.style(slen, sb.length() - slen, red, 1, yellow));
                            } else {
                                sr.add(ProfileText.style(slen, sb.length() - slen, dmagenta, 0));
                            }
                            if (apicall.error == 0) break;
                            slen = sb.length();
                            sb.append("\n").append(TextProxy.error.getText(apicall.error));
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                            break;
                        }
                        case 13: {
                            DispatchStep step = (DispatchStep)stepSingle;
                            slen = sb.length();
                            ProfileText.toString(sb, step);
                            if (searchLineIndex == stepSingle.index) {
                                sr.add(ProfileText.style(slen, sb.length() - slen, red, 1, yellow));
                            } else {
                                sr.add(ProfileText.style(slen, sb.length() - slen, dmagenta, 0));
                            }
                            if (step.error == 0) break;
                            slen = sb.length();
                            sb.append("\n").append(TextProxy.error.getText(step.error));
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                            break;
                        }
                        case 14: {
                            ThreadCallPossibleStep tcStep = (ThreadCallPossibleStep)stepSingle;
                            slen = sb.length();
                            ProfileText.toString(sb, tcStep);
                            if (searchLineIndex == stepSingle.index) {
                                sr.add(ProfileText.style(slen, sb.length() - slen, red, 1, yellow));
                                break;
                            }
                            sr.add(ProfileText.style(slen, sb.length() - slen, dmagenta, 0));
                            break;
                        }
                        case 5: {
                            SocketStep socket = (SocketStep)stepSingle;
                            slen = sb.length();
                            ProfileText.toString(sb, socket);
                            sr.add(ProfileText.style(slen, sb.length() - slen, dmagenta, 0));
                            if (socket.error == 0) break;
                            slen = sb.length();
                            sb.append("\n").append(TextProxy.error.getText(socket.error));
                            sr.add(ProfileText.style(slen, sb.length() - slen, red, 0));
                        }
                    }
                    sb.append("\n");
                    prev_cpu = cpu;
                    prev_tm = tm;
                }
            }
            ++i;
        }
        if (lastPage) {
            nextBtn.setEnabled(false);
            endBtn.setEnabled(false);
            tm = pack.endTime;
            cpu = pack.cpu;
            sb.append(" " + spaceStr + " ");
            sb.append(" ");
            sb.append("[" + astarStr + "]");
            sb.append(" ");
            sb.append(FormatUtil.print((Object)new Date(tm), (String)"HH:mm:ss.SSS"));
            sb.append("   ");
            if (!isSummary) {
                sb.append(String.format("%6s", FormatUtil.print((Object)(tm - prev_tm), (String)"#,##0")));
            } else {
                sb.append(String.format("%6s", FormatUtil.print((Object)pack.elapsed, (String)"#,##0")));
            }
            sb.append(" ");
            sb.append(String.format("%6s", FormatUtil.print((Object)(cpu - prev_cpu), (String)"#,##0")));
            sb.append("  end of transaction \n");
            sb.append("------------------------------------------------------------------------------------------\n");
        } else {
            nextBtn.setEnabled(true);
            endBtn.setEnabled(true);
        }
        if (pageNum == 0) {
            prevBtn.setEnabled(false);
            startBtn.setEnabled(false);
        } else {
            prevBtn.setEnabled(true);
            startBtn.setEnabled(true);
        }
        text.setText(sb.toString());
        text.setStyleRanges(sr.toArray(new StyleRange[sr.size()]));
    }
}

