/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Button;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.actions.OpenWorkspaceExplorerAction;
import scouter.client.model.TextProxy;
import scouter.client.model.XLogData;
import scouter.client.model.XLogProxy;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.RCPUtil;
import scouter.client.util.StepWrapper;
import scouter.client.xlog.ProfileTextFull;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogPack;
import scouter.lang.step.Step;
import scouter.lang.step.StepSingle;
import scouter.lang.step.StepSummary;
import scouter.util.DateUtil;
import scouter.util.SortUtil;

public class SaveProfileJob
extends Job {
    public static String xLogDirName = "xlog";
    String workingDir = "";
    public static String xLogFileName = "xlog.xlog";
    public static String profileFileName = "xlog.prof";
    public static String profileSummaryFileName = "xlog_summary.prof";
    long date;
    String yyyymmdd;
    XLogData xLogData;
    String txid;
    int maxBlock;
    private int serverId;
    boolean isSummary;
    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();

    public SaveProfileJob(String name, long date, XLogData xLogData, String txid, int serverId, boolean isSummary) {
        super(name);
        this.date = date;
        this.yyyymmdd = DateUtil.yyyymmdd((long)date);
        this.xLogData = xLogData;
        this.txid = txid;
        this.serverId = serverId;
        this.isSummary = isSummary;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.checkDir();
        monitor.beginTask("Saveing full Profile to... " + this.workingDir, -1);
        this.createDirAndFile();
        this.saveFullProfile(this.downloadFullProfile());
        this.saveXLogData();
        monitor.done();
        ExUtil.exec(PlatformUI.getWorkbench().getDisplay(), new Runnable(){

            @Override
            public void run() {
                OpenWorkspaceExplorerAction act = new OpenWorkspaceExplorerAction(SaveProfileJob.this.window, "Workspace Explorer", Images.explorer, true, SaveProfileJob.this.serverId);
                act.run();
            }
        });
        return Status.OK_STATUS;
    }

    private void checkDir() {
        String service = TextProxy.service.getText(this.xLogData.p.service).replaceAll("/", "_");
        if (service.length() > 80) {
            service = service.substring(0, 80);
        }
        String serverName = ServerManager.getInstance().getServer(this.serverId).getName();
        String dir = RCPUtil.getWorkingDirectory() + "/" + serverName + "/" + this.yyyymmdd + this.xLogData.objName + "/" + xLogDirName;
        File rootDir = new File(dir);
        File[] fs = rootDir.listFiles();
        if (fs != null) {
            this.workingDir = String.valueOf(dir) + "/" + "_" + String.format("%03d-", fs.length + 1) + DateUtil.format((long)this.date, (String)"HHmmss") + "_" + this.txid + "_" + service + "/";
            File[] fileArray = fs;
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String dirPath = f.getAbsolutePath();
                if (f.isDirectory() && dirPath != null && dirPath.indexOf(String.valueOf(this.txid) + "_" + service) != -1) {
                    this.workingDir = String.valueOf(dirPath) + "/";
                    break;
                }
                ++n2;
            }
        } else {
            this.workingDir = String.valueOf(dir) + "/" + "[001-" + DateUtil.format((long)this.date, (String)"HHmmss") + "]" + this.txid + "_" + service + "/";
        }
    }

    private void saveXLogData() {
        try {
            FileOutputStream fileOuputStream = new FileOutputStream(String.valueOf(this.workingDir) + xLogFileName);
            DataOutputX outX = new DataOutputX();
            fileOuputStream.write(outX.writePack((Pack)this.xLogData.p).toByteArray());
            fileOuputStream.close();
        }
        catch (Exception e) {
            ConsoleProxy.errorSafe(e.toString());
        }
    }

    private void createDirAndFile() {
        File profsumFile;
        File profFile;
        File xlogFile;
        File xlogDir = new File(this.workingDir);
        if (!xlogDir.exists()) {
            xlogDir.mkdirs();
        }
        if ((xlogFile = new File(xlogDir, xLogFileName)).exists()) {
            xlogFile.delete();
        }
        if ((profFile = new File(xlogDir, profileFileName)).exists()) {
            profFile.delete();
        }
        if ((profsumFile = new File(xlogDir, profileSummaryFileName)).exists()) {
            profsumFile.delete();
        }
    }

    private byte[] downloadFullProfile() {
        return XLogProxy.getFullProfileByteArray(DateUtil.yyyymmdd((long)this.xLogData.p.endTime), this.xLogData.p.txid, this.maxBlock, this.serverId);
    }

    private void saveFullProfile(byte[] p) {
        try {
            FileOutputStream fileOuputStream = !this.isSummary ? new FileOutputStream(String.valueOf(this.workingDir) + profileFileName) : new FileOutputStream(String.valueOf(this.workingDir) + profileSummaryFileName);
            fileOuputStream.write(p);
            fileOuputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static XLogPack getTranxData(File xlogDir, StyledText header, int serverId) {
        String xlogPath = String.valueOf(xlogDir.getAbsolutePath()) + "/" + xLogFileName;
        File xlogFile = new File(xlogPath);
        if (!xlogFile.canRead()) {
            return null;
        }
        byte[] xlogb = new byte[(int)xlogFile.length()];
        try {
            FileInputStream xlogInputStream = new FileInputStream(xlogFile);
            xlogInputStream.read(xlogb);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        DataInputX inX = new DataInputX(xlogb);
        XLogPack p = null;
        try {
            p = (XLogPack)inX.readPack();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String date = DateUtil.yyyymmdd((long)p.endTime);
        if (p != null) {
            ProfileTextFull.buildXLogData(date, header, p, serverId);
        }
        return p;
    }

    public static StepWrapper[] getProfileData(XLogPack pack, File xLogDir, boolean isSummary) {
        String profilePath = !isSummary ? String.valueOf(xLogDir.getAbsolutePath()) + "/" + profileFileName : String.valueOf(xLogDir.getAbsolutePath()) + "/" + profileSummaryFileName;
        File profileFile = new File(profilePath);
        if (!profileFile.canRead()) {
            return null;
        }
        byte[] profb = new byte[(int)profileFile.length()];
        try {
            FileInputStream profileInputStream = new FileInputStream(profileFile);
            profileInputStream.read(profb);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Step[] profile = null;
        try {
            profile = Step.toObjects((byte[])profb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        profile = SortUtil.sort((Step[])profile);
        HashMap<Integer, Integer> indent = new HashMap<Integer, Integer>();
        long stime = pack.endTime - (long)pack.elapsed;
        StepWrapper[] profWr = new StepWrapper[profile.length];
        int expectedIdx = 0;
        int sSummaryIdx = 1;
        int inx = 0;
        while (inx < profile.length) {
            if (profile[inx] instanceof StepSingle) {
                StepSingle sSingle = (StepSingle)profile[inx];
                int space = 0;
                if (indent.containsKey(sSingle.parent)) {
                    space = (Integer)indent.get(sSingle.parent) + 2;
                }
                indent.put(sSingle.index, space);
                profWr[inx] = new StepWrapper((long)sSingle.start_time + stime, sSingle.start_cpu, space, -1, (Step)sSingle);
                expectedIdx = sSingle.index + 1;
            } else if (profile[inx] instanceof StepSummary) {
                StepSummary sSummary = (StepSummary)profile[inx];
                profWr[inx] = new StepWrapper(-1L, -1L, -1, sSummaryIdx, (Step)sSummary);
                ++sSummaryIdx;
            }
            ++inx;
        }
        return profWr;
    }

    public static void setProfileData(XLogPack pack, StepWrapper[] profiles, StyledText text, int pageNum, int rowPerPage, Button prevBtn, Button nextBtn, Button startBtn, Button endBtn, int length, int serverId, int searchLineIndex, boolean isSummary) {
        String date = DateUtil.yyyymmdd((long)pack.endTime);
        int total = profiles.length / rowPerPage + 1;
        if (profiles.length % rowPerPage == 0) {
            --total;
        }
        if (pageNum > total) {
            pageNum = total - 1;
        }
        ProfileTextFull.buildProfile(date, text, pack, profiles, pageNum, rowPerPage, prevBtn, nextBtn, startBtn, endBtn, length, serverId, searchLineIndex, isSummary);
    }
}

