/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog;

import java.util.HashSet;
import scouter.client.model.TextProxy;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogPack;
import scouter.lang.step.ApiCallStep;
import scouter.lang.step.ApiCallSum;
import scouter.lang.step.DispatchStep;
import scouter.lang.step.DumpStep;
import scouter.lang.step.HashedMessageStep;
import scouter.lang.step.MethodStep;
import scouter.lang.step.MethodSum;
import scouter.lang.step.ParameterizedMessageStep;
import scouter.lang.step.SocketStep;
import scouter.lang.step.SpanCallStep;
import scouter.lang.step.SpanStep;
import scouter.lang.step.SqlStep;
import scouter.lang.step.SqlSum;
import scouter.lang.step.Step;
import scouter.lang.step.ThreadCallPossibleStep;
import scouter.lang.step.ThreadSubmitStep;

public class XLogUtil {
    public static void loadStepText(int serverId, String yyyymmdd, Step[] p) {
        HashSet<Integer> spanSet = new HashSet<Integer>();
        HashSet<Integer> methodSet = new HashSet<Integer>();
        HashSet<Integer> sqlSet = new HashSet<Integer>();
        HashSet<Integer> subcallSet = new HashSet<Integer>();
        HashSet<Integer> errorSet = new HashSet<Integer>();
        HashSet<Integer> hashedMsgSet = new HashSet<Integer>();
        HashSet<Integer> stackElementSet = new HashSet<Integer>();
        int i = 0;
        while (i < p.length) {
            switch (p[i].getStepType()) {
                case 2: 
                case 8: 
                case 16: {
                    if (TextProxy.sql.getText(((SqlStep)p[i]).hash) == null) {
                        sqlSet.add(((SqlStep)p[i]).hash);
                    }
                    if (((SqlStep)p[i]).error == 0 || TextProxy.error.getText(((SqlStep)p[i]).error) != null) break;
                    errorSet.add(((SqlStep)p[i]).error);
                    break;
                }
                case 21: {
                    if (TextProxy.sql.getText(((SqlSum)p[i]).hash) != null) break;
                    sqlSet.add(((SqlStep)p[i]).hash);
                    break;
                }
                case 9: {
                    if (TextProxy.hashMessage.getText(((HashedMessageStep)p[i]).hash) != null) break;
                    hashedMsgSet.add(((HashedMessageStep)p[i]).hash);
                    break;
                }
                case 17: {
                    if (TextProxy.hashMessage.getText(((ParameterizedMessageStep)p[i]).getHash()) != null) break;
                    hashedMsgSet.add(((ParameterizedMessageStep)p[i]).getHash());
                    break;
                }
                case 12: {
                    DumpStep dumpStep = (DumpStep)p[i];
                    int[] nArray = dumpStep.stacks;
                    int n = dumpStep.stacks.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int stackElementHash = nArray[n2];
                        if (TextProxy.stackElement.getText(stackElementHash) == null) {
                            stackElementSet.add(stackElementHash);
                        }
                        ++n2;
                    }
                    break;
                }
                case 1: 
                case 10: {
                    if (TextProxy.method.getText(((MethodStep)p[i]).hash) != null) break;
                    methodSet.add(((MethodStep)p[i]).hash);
                    break;
                }
                case 51: {
                    if (TextProxy.service.getText(((SpanStep)p[i]).hash) != null) break;
                    spanSet.add(((SpanStep)p[i]).hash);
                    break;
                }
                case 52: {
                    if (TextProxy.service.getText(((SpanCallStep)p[i]).hash) != null) break;
                    spanSet.add(((SpanCallStep)p[i]).hash);
                    break;
                }
                case 11: {
                    if (TextProxy.method.getText(((MethodSum)p[i]).hash) != null) break;
                    methodSet.add(((MethodSum)p[i]).hash);
                    break;
                }
                case 5: {
                    if (((SocketStep)p[i]).error == 0 || TextProxy.error.getText(((SocketStep)p[i]).error) != null) break;
                    errorSet.add(((SocketStep)p[i]).error);
                    break;
                }
                case 6: 
                case 15: {
                    if (TextProxy.apicall.getText(((ApiCallStep)p[i]).hash) == null) {
                        subcallSet.add(((ApiCallStep)p[i]).hash);
                    }
                    if (((ApiCallStep)p[i]).error == 0 || TextProxy.error.getText(((ApiCallStep)p[i]).error) != null) break;
                    errorSet.add(((ApiCallStep)p[i]).error);
                    break;
                }
                case 13: {
                    if (TextProxy.apicall.getText(((DispatchStep)p[i]).hash) == null) {
                        subcallSet.add(((DispatchStep)p[i]).hash);
                    }
                    if (((DispatchStep)p[i]).error == 0 || TextProxy.error.getText(((DispatchStep)p[i]).error) != null) break;
                    errorSet.add(((DispatchStep)p[i]).error);
                    break;
                }
                case 14: {
                    if (TextProxy.apicall.getText(((ThreadCallPossibleStep)p[i]).hash) != null) break;
                    subcallSet.add(((ThreadCallPossibleStep)p[i]).hash);
                    break;
                }
                case 43: {
                    if (TextProxy.apicall.getText(((ApiCallSum)p[i]).hash) != null) break;
                    subcallSet.add(((ApiCallSum)p[i]).hash);
                    break;
                }
                case 7: {
                    if (TextProxy.apicall.getText(((ThreadSubmitStep)p[i]).hash) == null) {
                        subcallSet.add(((ThreadSubmitStep)p[i]).hash);
                    }
                    if (((ThreadSubmitStep)p[i]).error == 0 || TextProxy.error.getText(((ThreadSubmitStep)p[i]).error) != null) break;
                    errorSet.add(((ThreadSubmitStep)p[i]).error);
                }
            }
            ++i;
        }
        TextProxy.service.load(yyyymmdd, spanSet, serverId);
        TextProxy.method.load(yyyymmdd, methodSet, serverId);
        TextProxy.sql.load(yyyymmdd, sqlSet, serverId);
        TextProxy.apicall.load(yyyymmdd, subcallSet, serverId);
        TextProxy.error.load(yyyymmdd, errorSet, serverId);
        TextProxy.hashMessage.load(yyyymmdd, hashedMsgSet, serverId);
        TextProxy.stackElement.load(yyyymmdd, stackElementSet, serverId);
    }

    public static int getCpuTime(Step p) {
        switch (p.getStepType()) {
            case 2: 
            case 8: 
            case 16: {
                SqlStep ss = (SqlStep)p;
                return ss.cputime;
            }
            case 1: 
            case 10: {
                MethodStep ms = (MethodStep)p;
                return ms.cputime;
            }
            case 6: 
            case 15: {
                ApiCallStep acs = (ApiCallStep)p;
                return acs.cputime;
            }
            case 7: {
                ThreadSubmitStep tss = (ThreadSubmitStep)p;
                return tss.cputime;
            }
        }
        return 0;
    }

    public static XLogPack toXLogPack(Pack p) {
        switch (p.getPackType()) {
            case 21: {
                return (XLogPack)p;
            }
        }
        return null;
    }
}

