/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import scouter.client.popup.CalendarDialog;
import scouter.client.util.ImageUtil;
import scouter.client.xlog.views.XLogLoadTimeView;

public class OpenXLogLoadTimeAction
extends Action
implements CalendarDialog.ILoadCalendarDialog {
    public static final String ID = OpenXLogLoadTimeAction.class.getName();
    private final IWorkbenchWindow window;
    private String objType;
    private int serverId;
    private long stime;
    private long etime;

    public OpenXLogLoadTimeAction(IWorkbenchWindow window, String objType, Image image, int serverId, long stime, long etime) {
        this.window = window;
        this.objType = objType;
        this.serverId = serverId;
        this.stime = stime;
        this.etime = etime;
        this.setText("XLog");
        this.setId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(image));
    }

    public OpenXLogLoadTimeAction(IWorkbenchWindow window, String label, String objType, Image image, int serverId) {
        this(window, objType, image, serverId, 0L, 0L);
    }

    public void run() {
        if (this.window != null) {
            try {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                CalendarDialog dialog = new CalendarDialog(display, this);
                if (this.stime > 0L && this.etime > 0L) {
                    dialog.showWithEndTime(this.stime, this.etime);
                } else {
                    dialog.showWithEndTime();
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
        if (this.window != null) {
            try {
                XLogLoadTimeView view = (XLogLoadTimeView)this.window.getActivePage().showView(XLogLoadTimeView.ID, String.valueOf(this.objType) + startTime + endTime, 1);
                if (view != null) {
                    view.setInput(startTime, endTime, this.objType, this.serverId);
                }
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }

    @Override
    public void onPressedOk(String date) {
    }

    @Override
    public void onPressedCancel() {
    }
}

