/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.actions;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.model.TextProxy;
import scouter.client.model.XLogData;
import scouter.client.model.XLogProxy;
import scouter.client.net.TcpProxy;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.xlog.XLogUtil;
import scouter.client.xlog.views.XLogProfileView;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogPack;
import scouter.lang.step.Step;
import scouter.util.DateUtil;
import scouter.util.Hexa32;

public class OpenXLogProfileJob
extends Job {
    Display display;
    XLogData data;
    String date;
    long txid;
    long gxid;
    int serverId;
    String secId = "profileview";

    public OpenXLogProfileJob(Display display, String date, long txid, long gxid) {
        super("Load XLog Profile");
        this.display = display;
        this.date = date;
        this.txid = txid;
        this.gxid = gxid;
    }

    public OpenXLogProfileJob(Display display, String date, long txid, long gxid, int serverId) {
        super("Load XLog Profile");
        this.display = display;
        this.date = date;
        this.txid = txid;
        this.gxid = gxid;
        this.serverId = serverId;
    }

    public OpenXLogProfileJob(Display display, XLogData xlogData, int serverId) {
        super("Load XLog Profile");
        this.display = display;
        this.data = xlogData;
        this.date = DateUtil.yyyymmdd((long)xlogData.p.endTime);
        this.txid = xlogData.p.txid;
        this.gxid = xlogData.p.gxid;
        this.serverId = serverId;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Load Profile....", -1);
        if (this.data == null || this.gxid != 0L && this.txid != this.gxid) {
            if (this.serverId == 0) {
                Set<Integer> serverSet = ServerManager.getInstance().getOpenServerList();
                for (int serverId : serverSet) {
                    this.data = this.getXLogData(serverId, this.date, this.txid, this.gxid);
                    if (this.data == null) continue;
                    this.serverId = serverId;
                    this.secId = Hexa32.toString32((long)this.txid);
                    break;
                }
            } else {
                this.data = this.getXLogData(this.serverId, this.date, this.txid, this.gxid);
                this.secId = Hexa32.toString32((long)this.txid);
            }
        }
        if (this.data == null) {
            ConsoleProxy.errorSafe("Cannot find : " + Hexa32.toString32((long)this.txid));
            return Status.CANCEL_STATUS;
        }
        final Step[] steps = XLogProxy.getProfile(this.date, this.txid, this.serverId);
        ExUtil.exec(this.display, new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    XLogProfileView view = (XLogProfileView)win.getActivePage().showView(XLogProfileView.ID, OpenXLogProfileJob.this.secId, 1);
                    view.setInput(steps, OpenXLogProfileJob.this.data, OpenXLogProfileJob.this.data.serverId);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        return Status.OK_STATUS;
    }

    private XLogData getXLogData(int serverId, String date, long txid, long gxid) {
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            MapPack param = new MapPack();
            param.put("date", date);
            param.put("txid", txid);
            param.put("gxid", gxid);
            Pack p = tcp.getSingle("XLOG_READ_BY_TXID", (Pack)param);
            if (p != null) {
                XLogPack xp = XLogUtil.toXLogPack(p);
                XLogData d = new XLogData(xp, serverId);
                d.objName = TextProxy.object.getLoadText(date, xp.objHash, serverId);
                d.serviceName = TextProxy.service.getLoadText(date, xp.service, serverId);
                XLogData xLogData = d;
                return xLogData;
            }
        }
        catch (Throwable th) {
            ConsoleProxy.errorSafe(th.toString());
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return null;
    }
}

