/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.model.XLogData;
import scouter.client.model.XLogProxy;
import scouter.client.util.ExUtil;
import scouter.client.xlog.views.XLogThreadProfileView;
import scouter.lang.step.Step;
import scouter.util.DateUtil;
import scouter.util.Hexa32;

public class OpenXLogThreadProfileJob
extends Job {
    final XLogData data;
    final long threadTxid;

    public OpenXLogThreadProfileJob(XLogData xlogData, long threadId) {
        super("Load XLog Thread Profile");
        this.data = xlogData;
        this.threadTxid = threadId;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Load Thread Profile....", -1);
        String date = DateUtil.yyyymmdd((long)this.data.p.endTime);
        final Step[] steps = XLogProxy.getProfile(date, this.threadTxid, this.data.serverId);
        ExUtil.exec(Display.getDefault(), new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    XLogThreadProfileView view = (XLogThreadProfileView)win.getActivePage().showView(XLogThreadProfileView.ID, Hexa32.toString32((long)OpenXLogThreadProfileJob.this.threadTxid), 1);
                    view.setInput(OpenXLogThreadProfileJob.this.data, steps, OpenXLogThreadProfileJob.this.threadTxid, OpenXLogThreadProfileJob.this.data.serverId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return Status.OK_STATUS;
    }
}

