/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.dialog;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import scouter.client.Images;
import scouter.client.xlog.XLogFilterStatus;
import scouter.client.xlog.views.XLogViewCommon;
import scouter.util.StringUtil;

public class XLogFilterDialog
extends Dialog {
    Combo objCombo;
    Text serviceTxt;
    Text ipTxt;
    Text startHmsFromTxt;
    Text startHmsToTxt;
    Text resTimeFromTxt;
    Text resTimeToTxt;
    Text userAgentTxt;
    Text loginText;
    Text descText;
    Text hasDumpYn;
    Text text1Text;
    Text text2Text;
    Text text3Text;
    Text text4Text;
    Text text5Text;
    Text profileSizeText;
    Text profileByteText;
    Button onlySqlBtn;
    Button onlyApiBtn;
    Button onlyErrorBtn;
    Button onlySyncBtn;
    Button onlyAsyncBtn;
    Button clearBtn;
    Button applyBtn;
    XLogViewCommon view;
    XLogFilterStatus status;
    XLogFilterStatus newStatus;
    int filterHash;
    VerifyListener hhmmssListener = e -> {
        if (!StringUtil.isInteger((String)e.text) && !StringUtil.isEmpty((String)e.text)) {
            e.doit = false;
            return;
        }
        Text text = (Text)e.getSource();
        String prev = text.getText();
        String after = String.valueOf(prev.substring(0, e.start)) + e.text + prev.substring(e.end);
        int i = after.length();
        while (i < 6) {
            after = String.valueOf(after) + '0';
            ++i;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HHmmss");
        try {
            LocalTime.parse(after, formatter);
        }
        catch (DateTimeParseException ignore) {
            e.doit = false;
        }
    };
    VerifyListener numberListener = e -> {
        if (!StringUtil.isInteger((String)e.text) && !StringUtil.isEmpty((String)e.text)) {
            e.doit = false;
            return;
        }
    };
    VerifyListener ynListener = e -> {
        e.text = e.text.toUpperCase();
        if (!("".equals(e.text) || "Y".equals(e.text) || "N".equals(e.text))) {
            e.doit = false;
            return;
        }
    };

    public XLogFilterDialog(XLogViewCommon view) {
        super(view.getSite().getShell());
        this.view = view;
    }

    public void setStatus(XLogFilterStatus status) {
        this.status = status;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.setShellStyle(2144);
        this.setBlockOnOpen(false);
        this.newStatus = this.status.clone();
        this.filterHash = this.status.hashCode();
        container.setLayout((Layout)new GridLayout(1, true));
        Button helpBtn = new Button(container, 8);
        helpBtn.setText("Help");
        helpBtn.setImage(Images.help);
        helpBtn.setLayoutData((Object)new GridData(131072, 4, true, false));
        helpBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"https://github.com/scouter-project/scouter/blob/master/scouter.document/views/XLog-Filter.md");
            }
        });
        Group filterGrp = new Group(container, 0);
        filterGrp.setLayoutData((Object)new GridData(4, 4, true, true));
        filterGrp.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)filterGrp, 0);
        label.setText("Object");
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.objCombo = new Combo((Composite)filterGrp, 2816);
        this.objCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.objCombo.setItems(this.view.getExistObjNames());
        this.objCombo.setText(this.status.objName);
        this.objCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                XLogFilterDialog.this.newStatus.objName = XLogFilterDialog.this.objCombo.getText();
                XLogFilterDialog.this.compareHash();
            }
        });
        label = new Label((Composite)filterGrp, 0);
        label.setText("Service");
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.serviceTxt = new Text((Composite)filterGrp, 2052);
        this.serviceTxt.setLayoutData((Object)new GridData(4, 4, true, false));
        this.serviceTxt.setText(this.status.service);
        this.serviceTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                XLogFilterDialog.this.newStatus.service = XLogFilterDialog.this.serviceTxt.getText();
                XLogFilterDialog.this.compareHash();
            }
        });
        label = new Label((Composite)filterGrp, 0);
        label.setText("IP");
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.ipTxt = new Text((Composite)filterGrp, 2052);
        this.ipTxt.setLayoutData((Object)new GridData(4, 4, true, false));
        this.ipTxt.setText(this.status.ip);
        this.ipTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                XLogFilterDialog.this.newStatus.ip = XLogFilterDialog.this.ipTxt.getText();
                XLogFilterDialog.this.compareHash();
            }
        });
        label = new Label((Composite)filterGrp, 0);
        label.setText("Response(ms)");
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        Composite resTimeComposite = new Composite((Composite)filterGrp, 0);
        resTimeComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        FillLayout resTimeFilllayout = new FillLayout();
        resTimeFilllayout.marginWidth = 0;
        resTimeFilllayout.marginHeight = 0;
        resTimeComposite.setLayout((Layout)resTimeFilllayout);
        this.resTimeFromTxt = new Text(resTimeComposite, 2052);
        this.resTimeFromTxt.setTextLimit(6);
        this.resTimeFromTxt.setText(this.status.responseTimeFrom);
        this.resTimeFromTxt.addVerifyListener(this.numberListener);
        this.resTimeFromTxt.addModifyListener(arg0 -> {
            this.newStatus.responseTimeFrom = this.resTimeFromTxt.getText();
            this.compareHash();
        });
        label = new Label(resTimeComposite, 0x1000000);
        label.setText(" ~ ");
        this.resTimeToTxt = new Text(resTimeComposite, 2052);
        this.resTimeToTxt.setTextLimit(6);
        this.resTimeToTxt.setText(this.status.responseTimeTo);
        this.resTimeToTxt.addVerifyListener(this.numberListener);
        this.resTimeToTxt.addModifyListener(arg0 -> {
            this.newStatus.responseTimeTo = this.resTimeToTxt.getText();
            this.compareHash();
        });
        label = new Label((Composite)filterGrp, 0);
        label.setText("StartHMS");
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        Composite startTimeComposite = new Composite((Composite)filterGrp, 0);
        startTimeComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        FillLayout filllayout = new FillLayout();
        filllayout.marginWidth = 0;
        filllayout.marginHeight = 0;
        startTimeComposite.setLayout((Layout)filllayout);
        this.startHmsFromTxt = new Text(startTimeComposite, 2052);
        this.startHmsFromTxt.setTextLimit(6);
        this.startHmsFromTxt.setText(this.status.startHmsFrom);
        this.startHmsFromTxt.addVerifyListener(this.hhmmssListener);
        this.startHmsFromTxt.addModifyListener(arg0 -> {
            this.newStatus.startHmsFrom = this.startHmsFromTxt.getText();
            this.compareHash();
        });
        label = new Label(startTimeComposite, 0x1000000);
        label.setText(" ~ ");
        this.startHmsToTxt = new Text(startTimeComposite, 2052);
        this.startHmsToTxt.setTextLimit(6);
        this.startHmsToTxt.setText(this.status.startHmsTo);
        this.startHmsToTxt.addVerifyListener(this.hhmmssListener);
        this.startHmsToTxt.addModifyListener(arg0 -> {
            this.newStatus.startHmsTo = this.startHmsToTxt.getText();
            this.compareHash();
        });
        label = new Label((Composite)filterGrp, 0);
        label.setText("LOGIN");
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.loginText = new Text((Composite)filterGrp, 2052);
        this.loginText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.loginText.setText(this.status.login);
        this.loginText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                XLogFilterDialog.this.newStatus.login = XLogFilterDialog.this.loginText.getText();
                XLogFilterDialog.this.compareHash();
            }
        });
        label = new Label((Composite)filterGrp, 0);
        label.setText("DESC");
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.descText = new Text((Composite)filterGrp, 2052);
        this.descText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.descText.setText(this.status.desc);
        this.descText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                XLogFilterDialog.this.newStatus.desc = XLogFilterDialog.this.descText.getText();
                XLogFilterDialog.this.compareHash();
            }
        });
        label = new Label((Composite)filterGrp, 0);
        label.setText("User-Agent");
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.userAgentTxt = new Text((Composite)filterGrp, 2052);
        this.userAgentTxt.setLayoutData((Object)new GridData(4, 4, true, false));
        this.userAgentTxt.setText(this.status.userAgent);
        this.userAgentTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                XLogFilterDialog.this.newStatus.userAgent = XLogFilterDialog.this.userAgentTxt.getText();
                XLogFilterDialog.this.compareHash();
            }
        });
        label = new Label((Composite)filterGrp, 0);
        label.setText("has dump YN");
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.hasDumpYn = new Text((Composite)filterGrp, 2052);
        this.hasDumpYn.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hasDumpYn.setText(this.status.hasDumpYn);
        this.hasDumpYn.addVerifyListener(this.ynListener);
        this.hasDumpYn.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                XLogFilterDialog.this.newStatus.hasDumpYn = XLogFilterDialog.this.hasDumpYn.getText();
                XLogFilterDialog.this.compareHash();
            }
        });
        label = new Label((Composite)filterGrp, 0);
        label.setText("TEXT1");
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.text1Text = new Text((Composite)filterGrp, 2052);
        this.text1Text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.text1Text.setText(this.status.text1);
        this.text1Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                XLogFilterDialog.this.newStatus.text1 = XLogFilterDialog.this.text1Text.getText();
                XLogFilterDialog.this.compareHash();
            }
        });
        label = new Label((Composite)filterGrp, 0);
        label.setText("TEXT2");
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.text2Text = new Text((Composite)filterGrp, 2052);
        this.text2Text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.text2Text.setText(this.status.text2);
        this.text2Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                XLogFilterDialog.this.newStatus.text2 = XLogFilterDialog.this.text2Text.getText();
                XLogFilterDialog.this.compareHash();
            }
        });
        label = new Label((Composite)filterGrp, 0);
        label.setText("TEXT3");
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.text3Text = new Text((Composite)filterGrp, 2052);
        this.text3Text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.text3Text.setText(this.status.text3);
        this.text3Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                XLogFilterDialog.this.newStatus.text3 = XLogFilterDialog.this.text3Text.getText();
                XLogFilterDialog.this.compareHash();
            }
        });
        label = new Label((Composite)filterGrp, 0);
        label.setText("TEXT4");
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.text4Text = new Text((Composite)filterGrp, 2052);
        this.text4Text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.text4Text.setText(this.status.text4);
        this.text4Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                XLogFilterDialog.this.newStatus.text4 = XLogFilterDialog.this.text4Text.getText();
                XLogFilterDialog.this.compareHash();
            }
        });
        label = new Label((Composite)filterGrp, 0);
        label.setText("TEXT5");
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.text5Text = new Text((Composite)filterGrp, 2052);
        this.text5Text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.text5Text.setText(this.status.text5);
        this.text5Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                XLogFilterDialog.this.newStatus.text5 = XLogFilterDialog.this.text5Text.getText();
                XLogFilterDialog.this.compareHash();
            }
        });
        label = new Label((Composite)filterGrp, 0);
        label.setText("PROFILE-SIZE");
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.profileSizeText = new Text((Composite)filterGrp, 2052);
        this.profileSizeText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.profileSizeText.setText(this.status.profileSizeText);
        this.profileSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                XLogFilterDialog.this.newStatus.profileSizeText = XLogFilterDialog.this.profileSizeText.getText();
                XLogFilterDialog.this.compareHash();
            }
        });
        label = new Label((Composite)filterGrp, 0);
        label.setText("PROFILE-BYTE");
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.profileByteText = new Text((Composite)filterGrp, 2052);
        this.profileByteText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.profileByteText.setText(this.status.profileBytesText);
        this.profileByteText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                XLogFilterDialog.this.newStatus.profileBytesText = XLogFilterDialog.this.profileByteText.getText();
                XLogFilterDialog.this.compareHash();
            }
        });
        Group checkGroup = new Group((Composite)filterGrp, 0);
        checkGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        checkGroup.setLayout((Layout)new GridLayout(3, true));
        this.onlySqlBtn = new Button((Composite)checkGroup, 32);
        this.onlySqlBtn.setText("SQL");
        this.onlySqlBtn.setLayoutData((Object)new GridData(16384, 4, true, false));
        this.onlySqlBtn.setSelection(this.status.onlySql);
        this.onlySqlBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLogFilterDialog.this.newStatus.onlySql = XLogFilterDialog.this.onlySqlBtn.getSelection();
                XLogFilterDialog.this.compareHash();
            }
        });
        this.onlyApiBtn = new Button((Composite)checkGroup, 32);
        this.onlyApiBtn.setText("ApiCall");
        this.onlyApiBtn.setLayoutData((Object)new GridData(16384, 4, true, false));
        this.onlyApiBtn.setSelection(this.status.onlyApicall);
        this.onlyApiBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLogFilterDialog.this.newStatus.onlyApicall = XLogFilterDialog.this.onlyApiBtn.getSelection();
                XLogFilterDialog.this.compareHash();
            }
        });
        this.onlyErrorBtn = new Button((Composite)checkGroup, 32);
        this.onlyErrorBtn.setText("Error");
        this.onlyErrorBtn.setLayoutData((Object)new GridData(16384, 4, true, false));
        this.onlyErrorBtn.setSelection(this.status.onlyError);
        this.onlyErrorBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLogFilterDialog.this.newStatus.onlyError = XLogFilterDialog.this.onlyErrorBtn.getSelection();
                XLogFilterDialog.this.compareHash();
            }
        });
        this.onlySyncBtn = new Button((Composite)checkGroup, 32);
        this.onlySyncBtn.setText("Sync");
        this.onlySyncBtn.setLayoutData((Object)new GridData(16384, 4, true, false));
        this.onlySyncBtn.setSelection(this.status.onlySync);
        this.onlySyncBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLogFilterDialog.this.newStatus.onlySync = XLogFilterDialog.this.onlySyncBtn.getSelection();
                XLogFilterDialog.this.compareHash();
            }
        });
        this.onlyAsyncBtn = new Button((Composite)checkGroup, 32);
        this.onlyAsyncBtn.setText("Async");
        this.onlyAsyncBtn.setLayoutData((Object)new GridData(16384, 4, true, false));
        this.onlyAsyncBtn.setSelection(this.status.onlyAsync);
        this.onlyAsyncBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLogFilterDialog.this.newStatus.onlyAsync = XLogFilterDialog.this.onlyAsyncBtn.getSelection();
                XLogFilterDialog.this.compareHash();
            }
        });
        Composite btnComp = new Composite(container, 0);
        btnComp.setLayoutData((Object)new GridData(131072, 4, true, false));
        btnComp.setLayout((Layout)new RowLayout());
        RowData rd = new RowData();
        rd.width = 90;
        this.clearBtn = new Button(btnComp, 8);
        this.clearBtn.setLayoutData((Object)rd);
        this.clearBtn.setText("&Clear");
        this.clearBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLogFilterDialog.this.objCombo.setText("");
                XLogFilterDialog.this.serviceTxt.setText("");
                XLogFilterDialog.this.ipTxt.setText("");
                XLogFilterDialog.this.startHmsFromTxt.setText("");
                XLogFilterDialog.this.startHmsToTxt.setText("");
                XLogFilterDialog.this.resTimeFromTxt.setText("");
                XLogFilterDialog.this.resTimeToTxt.setText("");
                XLogFilterDialog.this.loginText.setText("");
                XLogFilterDialog.this.descText.setText("");
                XLogFilterDialog.this.hasDumpYn.setText("");
                XLogFilterDialog.this.text1Text.setText("");
                XLogFilterDialog.this.text2Text.setText("");
                XLogFilterDialog.this.text3Text.setText("");
                XLogFilterDialog.this.text4Text.setText("");
                XLogFilterDialog.this.text5Text.setText("");
                XLogFilterDialog.this.userAgentTxt.setText("");
                XLogFilterDialog.this.onlySqlBtn.setSelection(false);
                XLogFilterDialog.this.onlyApiBtn.setSelection(false);
                XLogFilterDialog.this.onlyErrorBtn.setSelection(false);
                XLogFilterDialog.this.onlySyncBtn.setSelection(false);
                XLogFilterDialog.this.onlyAsyncBtn.setSelection(false);
                XLogFilterDialog.this.profileSizeText.setText("");
                XLogFilterDialog.this.profileByteText.setText("");
                XLogFilterDialog.this.newStatus = new XLogFilterStatus();
                if (XLogFilterDialog.this.newStatus.hashCode() != XLogFilterDialog.this.filterHash) {
                    XLogFilterDialog.this.applyBtn.setEnabled(true);
                }
            }
        });
        this.applyBtn = new Button(btnComp, 8);
        this.applyBtn.setLayoutData((Object)rd);
        this.applyBtn.setText("&Apply");
        this.applyBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String startHmsTo;
                String startHmsFrom = XLogFilterDialog.this.startHmsFromTxt.getText();
                if (startHmsFrom.length() > 0 && startHmsFrom.length() < 6) {
                    int i = startHmsFrom.length();
                    while (i < 6) {
                        startHmsFrom = String.valueOf(startHmsFrom) + '0';
                        ++i;
                    }
                    XLogFilterDialog.this.startHmsFromTxt.setText(startHmsFrom);
                }
                if ((startHmsTo = XLogFilterDialog.this.startHmsToTxt.getText()).length() > 0 && startHmsTo.length() < 6) {
                    int i = startHmsTo.length();
                    while (i < 6) {
                        startHmsTo = String.valueOf(startHmsTo) + '0';
                        ++i;
                    }
                    XLogFilterDialog.this.startHmsToTxt.setText(startHmsTo);
                }
                XLogFilterDialog.this.view.setFilter(XLogFilterDialog.this.newStatus);
                XLogFilterDialog.this.filterHash = XLogFilterDialog.this.newStatus.hashCode();
                XLogFilterDialog.this.compareHash();
            }
        });
        this.applyBtn.setEnabled(false);
        return container;
    }

    private void compareHash() {
        if (this.newStatus.hashCode() != this.filterHash) {
            this.applyBtn.setEnabled(true);
        } else {
            this.applyBtn.setEnabled(false);
        }
    }

    protected void okPressed() {
        if (this.newStatus.hashCode() != this.filterHash) {
            this.view.setFilter(this.newStatus);
            this.filterHash = this.newStatus.hashCode();
            this.compareHash();
        }
        super.okPressed();
    }

    protected Point getInitialSize() {
        return this.getShell().computeSize(300, -1);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("XLog Filter");
    }
}

