/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.model.XLogData;
import scouter.client.net.TcpProxy;
import scouter.client.popup.CalendarDialog;
import scouter.client.server.ServerManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageCombo;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.client.xlog.XLogUtil;
import scouter.client.xlog.views.XLogSelectionView;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.ObjectPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.Hexa32;
import scouter.util.StringUtil;

public class XLogSearchDialog
implements CalendarDialog.ILoadCalendarDialog {
    Shell dialog;
    IWorkbenchWindow win;
    int serverId;
    String objType;
    String requestCmd;
    Group normalSearchGrp;
    Group quickSearchGrp;
    Text ragneText;
    ImageCombo objectCombo;
    Text ipText;
    Text loginText;
    Text descText;
    Text text1Text;
    Text text2Text;
    Text text3Text;
    Text text4Text;
    Text text5Text;
    Text serviceText;
    Text dateText;
    Text txidText;
    ImageCombo txidCombo;
    long stime;
    long etime;
    String date;

    public XLogSearchDialog(IWorkbenchWindow win, int serverId, String objType) {
        this.win = win;
        this.serverId = serverId;
        this.objType = objType;
    }

    public void show() {
        CounterEngine counterEngine = ServerManager.getInstance().getServer(this.serverId).getCounterEngine();
        this.dialog = new Shell(this.win.getShell(), 67680);
        UIUtil.setDialogDefaultFunctions(this.dialog);
        this.dialog.setText("Search XLog - " + counterEngine.getDisplayNameObjectType(this.objType));
        this.dialog.setLayout((Layout)new GridLayout(1, true));
        Button normalRadio = new Button((Composite)this.dialog, 16);
        normalRadio.setText("Normal Search(Max:500)");
        GridData gr = new GridData(16384, 4, false, false);
        gr.widthHint = 300;
        normalRadio.setLayoutData((Object)gr);
        normalRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLogSearchDialog.this.requestCmd = "SEARCH_XLOG_LIST";
                XLogSearchDialog.this.normalSearchGrp.setEnabled(true);
                XLogSearchDialog.this.ragneText.setEnabled(true);
                XLogSearchDialog.this.objectCombo.setEnabled(true);
                XLogSearchDialog.this.ipText.setEnabled(true);
                XLogSearchDialog.this.loginText.setEnabled(true);
                XLogSearchDialog.this.descText.setEnabled(true);
                XLogSearchDialog.this.text1Text.setEnabled(true);
                XLogSearchDialog.this.text2Text.setEnabled(true);
                XLogSearchDialog.this.text3Text.setEnabled(true);
                XLogSearchDialog.this.text4Text.setEnabled(true);
                XLogSearchDialog.this.text5Text.setEnabled(true);
                XLogSearchDialog.this.serviceText.setEnabled(true);
                XLogSearchDialog.this.quickSearchGrp.setEnabled(false);
                XLogSearchDialog.this.dateText.setEnabled(false);
                XLogSearchDialog.this.txidCombo.setEnabled(false);
                XLogSearchDialog.this.txidText.setEnabled(false);
            }
        });
        this.normalSearchGrp = new Group((Composite)this.dialog, 0);
        gr = new GridData(4, 4, true, false);
        this.normalSearchGrp.setLayoutData((Object)gr);
        this.normalSearchGrp.setLayout((Layout)new GridLayout(3, false));
        this.normalSearchGrp.setText("Search Condition");
        Label label = new Label((Composite)this.normalSearchGrp, 0);
        gr = new GridData(4, 0x1000000, false, false);
        gr.widthHint = 70;
        label.setLayoutData((Object)gr);
        label.setText("Time Range");
        this.ragneText = new Text((Composite)this.normalSearchGrp, 2056);
        this.ragneText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.ragneText.setBackground(ColorUtil.getInstance().getColor(1));
        Button button = new Button((Composite)this.normalSearchGrp, 8);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button.setImage(Images.CTXMENU_RDC);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        CalendarDialog dialog = new CalendarDialog(XLogSearchDialog.this.win.getShell().getDisplay(), XLogSearchDialog.this);
                        dialog.showWithEndTime(XLogSearchDialog.this.stime, XLogSearchDialog.this.etime);
                    }
                }
            }
        });
        label = new Label((Composite)this.normalSearchGrp, 0);
        gr = new GridData(4, 4, false, false);
        gr.widthHint = 70;
        label.setLayoutData((Object)gr);
        label.setText("Object");
        this.objectCombo = new ImageCombo((Composite)this.normalSearchGrp, 2056);
        gr = new GridData(4, 4, true, false, 2, 1);
        this.objectCombo.setLayoutData(gr);
        this.objectCombo.setBackground(ColorUtil.getInstance().getColor(1));
        this.objectCombo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                XLogSearchDialog.this.objectCombo.removeAll();
                if (XLogSearchDialog.this.stime > 0L) {
                    ArrayList<ObjectPack> list = XLogSearchDialog.this.loadObjectList(DateUtil.yyyymmdd((long)XLogSearchDialog.this.stime));
                    int i = 0;
                    while (i < list.size()) {
                        ObjectPack pack = list.get(i);
                        XLogSearchDialog.this.objectCombo.add(pack.objName, null);
                        XLogSearchDialog.this.objectCombo.setData(pack.objName, pack.objHash);
                        ++i;
                    }
                }
            }
        });
        label = new Label((Composite)this.normalSearchGrp, 0);
        gr = new GridData(4, 4, false, false);
        gr.widthHint = 70;
        label.setLayoutData((Object)gr);
        label.setText("Service");
        this.serviceText = new Text((Composite)this.normalSearchGrp, 2048);
        gr = new GridData(4, 4, true, false, 2, 1);
        this.serviceText.setLayoutData((Object)gr);
        label = new Label((Composite)this.normalSearchGrp, 0);
        gr = new GridData(4, 4, false, false);
        gr.widthHint = 70;
        label.setLayoutData((Object)gr);
        label.setText("IP");
        this.ipText = new Text((Composite)this.normalSearchGrp, 2048);
        gr = new GridData(4, 4, true, false, 2, 1);
        this.ipText.setLayoutData((Object)gr);
        label = new Label((Composite)this.normalSearchGrp, 0);
        gr = new GridData(4, 4, false, false);
        gr.widthHint = 70;
        label.setLayoutData((Object)gr);
        label.setText("LOGIN");
        this.loginText = new Text((Composite)this.normalSearchGrp, 2048);
        gr = new GridData(4, 4, true, false, 2, 1);
        this.loginText.setLayoutData((Object)gr);
        label = new Label((Composite)this.normalSearchGrp, 0);
        gr = new GridData(4, 4, false, false);
        gr.widthHint = 70;
        label.setLayoutData((Object)gr);
        label.setText("DESC");
        this.descText = new Text((Composite)this.normalSearchGrp, 2048);
        gr = new GridData(4, 4, true, false, 2, 1);
        this.descText.setLayoutData((Object)gr);
        label = new Label((Composite)this.normalSearchGrp, 0);
        gr = new GridData(4, 4, false, false);
        gr.widthHint = 70;
        label.setLayoutData((Object)gr);
        label.setText("TEXT1");
        this.text1Text = new Text((Composite)this.normalSearchGrp, 2048);
        gr = new GridData(4, 4, true, false, 2, 1);
        this.text1Text.setLayoutData((Object)gr);
        label = new Label((Composite)this.normalSearchGrp, 0);
        gr = new GridData(4, 4, false, false);
        gr.widthHint = 70;
        label.setLayoutData((Object)gr);
        label.setText("TEXT2");
        this.text2Text = new Text((Composite)this.normalSearchGrp, 2048);
        gr = new GridData(4, 4, true, false, 2, 1);
        this.text2Text.setLayoutData((Object)gr);
        label = new Label((Composite)this.normalSearchGrp, 0);
        gr = new GridData(4, 4, false, false);
        gr.widthHint = 70;
        label.setLayoutData((Object)gr);
        label.setText("TEXT3");
        this.text3Text = new Text((Composite)this.normalSearchGrp, 2048);
        gr = new GridData(4, 4, true, false, 2, 1);
        this.text3Text.setLayoutData((Object)gr);
        label = new Label((Composite)this.normalSearchGrp, 0);
        gr = new GridData(4, 4, false, false);
        gr.widthHint = 70;
        label.setLayoutData((Object)gr);
        label.setText("TEXT4");
        this.text4Text = new Text((Composite)this.normalSearchGrp, 2048);
        gr = new GridData(4, 4, true, false, 2, 1);
        this.text4Text.setLayoutData((Object)gr);
        label = new Label((Composite)this.normalSearchGrp, 0);
        gr = new GridData(4, 4, false, false);
        gr.widthHint = 70;
        label.setLayoutData((Object)gr);
        label.setText("TEXT5");
        this.text5Text = new Text((Composite)this.normalSearchGrp, 2048);
        gr = new GridData(4, 4, true, false, 2, 1);
        this.text5Text.setLayoutData((Object)gr);
        Button quickRadio = new Button((Composite)this.dialog, 16);
        quickRadio.setText("Quick Search");
        gr = new GridData(16384, 4, false, false);
        quickRadio.setLayoutData((Object)gr);
        quickRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLogSearchDialog.this.requestCmd = "QUICKSEARCH_XLOG_LIST";
                XLogSearchDialog.this.quickSearchGrp.setEnabled(true);
                XLogSearchDialog.this.dateText.setEnabled(true);
                XLogSearchDialog.this.txidCombo.setEnabled(true);
                XLogSearchDialog.this.txidText.setEnabled(true);
                XLogSearchDialog.this.normalSearchGrp.setEnabled(false);
                XLogSearchDialog.this.ragneText.setEnabled(false);
                XLogSearchDialog.this.objectCombo.setEnabled(false);
                XLogSearchDialog.this.ipText.setEnabled(false);
                XLogSearchDialog.this.loginText.setEnabled(false);
                XLogSearchDialog.this.descText.setEnabled(false);
                XLogSearchDialog.this.text1Text.setEnabled(false);
                XLogSearchDialog.this.text2Text.setEnabled(false);
                XLogSearchDialog.this.text3Text.setEnabled(false);
                XLogSearchDialog.this.text4Text.setEnabled(false);
                XLogSearchDialog.this.text5Text.setEnabled(false);
                XLogSearchDialog.this.serviceText.setEnabled(false);
            }
        });
        this.quickSearchGrp = new Group((Composite)this.dialog, 0);
        gr = new GridData(4, 4, true, false);
        this.quickSearchGrp.setLayoutData((Object)gr);
        this.quickSearchGrp.setLayout((Layout)new GridLayout(3, false));
        this.quickSearchGrp.setText("QuickSearch Condition");
        this.dateText = new Text((Composite)this.quickSearchGrp, 2056);
        gr = new GridData(4, 0x1000000, true, false);
        gr.widthHint = 70;
        this.dateText.setLayoutData((Object)gr);
        this.dateText.setBackground(ColorUtil.getInstance().getColor(1));
        this.dateText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CalendarDialog dialog = new CalendarDialog(XLogSearchDialog.this.win.getShell().getDisplay(), XLogSearchDialog.this);
                dialog.show(-1, -1, DateUtil.getTime((String)XLogSearchDialog.this.date, (String)"yyyyMMdd"));
            }
        });
        this.txidCombo = new ImageCombo((Composite)this.quickSearchGrp, 2056);
        gr = new GridData(4, 0x1000000, true, false);
        gr.widthHint = 30;
        this.txidCombo.setLayoutData(gr);
        this.txidCombo.setBackground(ColorUtil.getInstance().getColor(1));
        this.txidCombo.add("txid", null);
        this.txidCombo.add("gxid", null);
        this.txidCombo.select(0);
        this.txidText = new Text((Composite)this.quickSearchGrp, 2048);
        this.txidText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button okBtn = new Button((Composite)this.dialog, 8);
        gr = new GridData(131072, 4, false, false);
        gr.widthHint = 100;
        okBtn.setLayoutData((Object)gr);
        okBtn.setText("&Search");
        okBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (XLogSearchDialog.this.requestCmd.equals("SEARCH_XLOG_LIST")) {
                    XLogSearchDialog.this.searchXLog();
                } else if (XLogSearchDialog.this.requestCmd.equals("QUICKSEARCH_XLOG_LIST")) {
                    XLogSearchDialog.this.quickSearchXLog();
                }
            }
        });
        this.init();
        normalRadio.setSelection(true);
        normalRadio.notifyListeners(13, new Event());
        this.dialog.pack();
        this.dialog.open();
    }

    private void init() {
        long now = TimeUtil.getCurrentTime(this.serverId);
        long stime = now - 300000L;
        this.onPressedOk(stime, now);
        this.onPressedOk(DateUtil.yyyymmdd((long)now));
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
        this.stime = startTime;
        this.etime = endTime;
        String yyyymmdd = DateUtil.yyyymmdd((long)startTime);
        this.ragneText.setText("(" + yyyymmdd.substring(0, 4) + "-" + yyyymmdd.substring(4, 6) + "-" + yyyymmdd.substring(6, 8) + ") " + DateUtil.format((long)startTime, (String)"HH:mm") + "~" + DateUtil.format((long)endTime, (String)"HH:mm"));
    }

    @Override
    public void onPressedOk(String date) {
        this.date = date;
        this.dateText.setText(String.valueOf(date.substring(0, 4)) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8));
    }

    @Override
    public void onPressedCancel() {
    }

    private ArrayList<ObjectPack> loadObjectList(String date) {
        ArrayList<ObjectPack> objList = new ArrayList<ObjectPack>();
        TcpProxy proxy = TcpProxy.getTcpProxy(this.serverId);
        try {
            MapPack param = new MapPack();
            param.put("date", date);
            MapPack out = (MapPack)proxy.getSingle("OBJECT_LIST_LOAD_DATE", (Pack)param);
            ListValue objTypeLv = out.getList("objType");
            ListValue objHashLv = out.getList("objHash");
            ListValue objNameLv = out.getList("objName");
            if (objHashLv == null || objHashLv.size() < 0) {
                ArrayList<ObjectPack> arrayList = objList;
                return arrayList;
            }
            int i = 0;
            while (i < objHashLv.size()) {
                ObjectPack pack = new ObjectPack();
                pack.objType = objTypeLv.getString(i);
                if (pack.objType.equals(this.objType)) {
                    pack.objHash = (int)objHashLv.getLong(i);
                    pack.objName = objNameLv.getString(i);
                    objList.add(pack);
                }
                ++i;
            }
            Collections.sort(objList, new Comparator<Pack>(){

                @Override
                public int compare(Pack o1, Pack o2) {
                    ObjectPack m1 = (ObjectPack)o1;
                    ObjectPack m2 = (ObjectPack)o2;
                    int c = m1.objType.compareTo(m2.objType);
                    if (c != 0) {
                        return c;
                    }
                    if (m1.objName != null) {
                        return m1.objName.compareTo(m2.objName);
                    }
                    return m1.objHash - m2.objHash;
                }
            });
        }
        finally {
            TcpProxy.putTcpProxy(proxy);
        }
        return objList;
    }

    private void searchXLog() {
        String ip;
        String serviceName;
        MapPack param = new MapPack();
        param.put("stime", this.stime);
        param.put("etime", this.etime);
        String objName = this.objectCombo.getText();
        if (StringUtil.isNotEmpty((String)objName)) {
            param.put("objHash", CastUtil.clong((Object)this.objectCombo.getData(objName)));
        }
        if (StringUtil.isNotEmpty((String)(serviceName = this.serviceText.getText()))) {
            param.put("service", serviceName);
        }
        if (StringUtil.isNotEmpty((String)(ip = this.ipText.getText()))) {
            param.put("ip", ip);
        }
        if (StringUtil.isNotEmpty((String)this.loginText.getText())) {
            param.put("login", this.loginText.getText());
        }
        if (StringUtil.isNotEmpty((String)this.descText.getText())) {
            param.put("desc", this.descText.getText());
        }
        if (StringUtil.isNotEmpty((String)this.text1Text.getText())) {
            param.put("text1", this.text1Text.getText());
        }
        if (StringUtil.isNotEmpty((String)this.text2Text.getText())) {
            param.put("text2", this.text2Text.getText());
        }
        if (StringUtil.isNotEmpty((String)this.text3Text.getText())) {
            param.put("text3", this.text3Text.getText());
        }
        if (StringUtil.isNotEmpty((String)this.text4Text.getText())) {
            param.put("text4", this.text4Text.getText());
        }
        if (StringUtil.isNotEmpty((String)this.text5Text.getText())) {
            param.put("text5", this.text5Text.getText());
        }
        new SearchXLogJob(param).schedule();
        this.dialog.close();
    }

    private void quickSearchXLog() {
        MapPack param = new MapPack();
        param.put("date", this.date);
        String id = this.txidText.getText();
        try {
            long txid = 0L;
            try {
                txid = Long.parseLong(id.trim());
            }
            catch (NumberFormatException e) {
                txid = Hexa32.toLong32((String)id.trim());
            }
            param.put(this.txidCombo.getText(), txid);
            new SearchXLogJob(param).schedule();
            this.dialog.close();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.win.getShell(), (String)"Error", (String)(String.valueOf(e.toString()) + " : " + id));
        }
    }

    class SearchXLogJob
    extends Job {
        MapPack param;

        public SearchXLogJob(MapPack param) {
            super("Search XLog");
            this.param = param;
        }

        protected IStatus run(IProgressMonitor monitor) {
            TcpProxy tcp = TcpProxy.getTcpProxy(XLogSearchDialog.this.serverId);
            List<Pack> list = null;
            try {
                try {
                    monitor.beginTask("Search XLog....... ", -1);
                    list = tcp.process(XLogSearchDialog.this.requestCmd, (Pack)this.param);
                }
                catch (Exception e) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    TcpProxy.putTcpProxy(tcp);
                    return iStatus;
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
            final ArrayList<XLogData> datas = new ArrayList<XLogData>();
            int i = 0;
            int size = list == null ? 0 : list.size();
            while (i < size) {
                Pack pack = list.get(i);
                datas.add(new XLogData(XLogUtil.toXLogPack(pack), XLogSearchDialog.this.serverId));
                ++i;
            }
            ExUtil.exec(XLogSearchDialog.this.win.getShell().getDisplay(), new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        XLogSelectionView view = (XLogSelectionView)win.getActivePage().showView(XLogSelectionView.ID, "" + System.identityHashCode((Object)SearchXLogJob.this), 1);
                        view.setInput(datas, ((SearchXLogJob)SearchXLogJob.this).XLogSearchDialog.this.objType, DateUtil.yyyymmdd((long)((SearchXLogJob)SearchXLogJob.this).XLogSearchDialog.this.stime));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }
}

