/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.dialog;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import scouter.client.Images;
import scouter.client.model.XLogData;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.LongKeyLinkedMap;

public abstract class XLogSummaryAbstractDialog {
    Display display;
    Shell dialog;
    protected LongKeyLinkedMap<XLogData> dataMap;
    protected Label rangeLabel;
    long stime;
    long etime;
    protected TableViewer viewer;
    TableColumnLayout tableColumnLayout;
    private Clipboard clipboard;

    public XLogSummaryAbstractDialog(Display display, LongKeyLinkedMap<XLogData> dataMap) {
        this.display = display;
        this.dataMap = dataMap;
    }

    public void setRange(long stime, long etime) {
        this.stime = stime;
        this.etime = etime;
    }

    public void show() {
        this.dialog = new Shell(this.display, 3312);
        this.dialog.setText(this.getTitle());
        this.createDialogArea();
        this.clipboard = new Clipboard(null);
        this.dialog.pack();
        this.dialog.open();
    }

    public abstract String getTitle();

    private void copyToClipboard(TableItem[] items) {
        if (this.viewer != null) {
            int colCnt = this.viewer.getTable().getColumnCount();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < colCnt) {
                TableColumn column = this.viewer.getTable().getColumn(i);
                sb.append(column.getText());
                if (i == colCnt - 1) {
                    sb.append("\n");
                } else {
                    sb.append("\t");
                }
                ++i;
            }
            if (items != null && items.length > 0) {
                TableItem[] tableItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    int i2 = 0;
                    while (i2 < colCnt) {
                        sb.append(item.getText(i2));
                        if (i2 == colCnt - 1) {
                            sb.append("\n");
                        } else {
                            sb.append("\t");
                        }
                        ++i2;
                    }
                    ++n2;
                }
                this.clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
                MessageDialog.openInformation((Shell)this.dialog, (String)"Copy", (String)"Copied to clipboard");
            }
        }
    }

    protected void createDialogArea() {
        this.dialog.setLayout((Layout)new GridLayout(1, true));
        Composite upperComp = new Composite((Composite)this.dialog, 0);
        upperComp.setLayoutData((Object)new GridData(4, 4, true, false));
        upperComp.setLayout((Layout)new GridLayout(2, true));
        this.rangeLabel = new Label(upperComp, 0);
        this.rangeLabel.setLayoutData((Object)new GridData(4, 1024, true, false));
        Composite btnComp = new Composite(upperComp, 0);
        btnComp.setLayoutData((Object)new GridData(131072, 4, true, false));
        btnComp.setLayout((Layout)new RowLayout());
        Button copyBtn = new Button(btnComp, 8);
        copyBtn.setText("Copy All");
        copyBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XLogSummaryAbstractDialog.this.copyToClipboard(XLogSummaryAbstractDialog.this.viewer.getTable().getItems());
            }
        });
        Button exportBtn = new Button(btnComp, 8);
        exportBtn.setText("CSV");
        exportBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(XLogSummaryAbstractDialog.this.display.getActiveShell(), 8192);
                dialog.setOverwrite(true);
                String filename = "[" + DateUtil.format((long)XLogSummaryAbstractDialog.this.stime, (String)"yyyyMMdd_HHmmss") + "-" + DateUtil.format((long)XLogSummaryAbstractDialog.this.etime, (String)"HHmmss") + "]" + XLogSummaryAbstractDialog.this.getTitle().replaceAll(" ", "_") + ".csv";
                dialog.setFileName(filename);
                dialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
                dialog.setFilterNames(new String[]{"CSV File(*.csv)", "All Files"});
                String fileSelected = dialog.open();
                if (fileSelected != null) {
                    CSVWriter cw = null;
                    try {
                        try {
                            cw = new CSVWriter((Writer)new FileWriter(fileSelected));
                            int colCnt = XLogSummaryAbstractDialog.this.viewer.getTable().getColumnCount();
                            ArrayList<String> list = new ArrayList<String>();
                            int i = 0;
                            while (i < colCnt) {
                                TableColumn column = XLogSummaryAbstractDialog.this.viewer.getTable().getColumn(i);
                                list.add(column.getText());
                                ++i;
                            }
                            cw.writeNext(list.toArray(new String[list.size()]));
                            cw.flush();
                            TableItem[] items = XLogSummaryAbstractDialog.this.viewer.getTable().getItems();
                            if (items != null && items.length > 0) {
                                TableItem[] tableItemArray = items;
                                int n = items.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TableItem item = tableItemArray[n2];
                                    list.clear();
                                    int i2 = 0;
                                    while (i2 < colCnt) {
                                        list.add(item.getText(i2));
                                        ++i2;
                                    }
                                    cw.writeNext(list.toArray(new String[list.size()]));
                                    cw.flush();
                                    ++n2;
                                }
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            try {
                                if (cw != null) {
                                    cw.close();
                                }
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    finally {
                        try {
                            if (cw != null) {
                                cw.close();
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        });
        Composite tableComp = new Composite((Composite)this.dialog, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 800;
        gd.heightHint = 400;
        tableComp.setLayoutData((Object)gd);
        this.tableColumnLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)this.tableColumnLayout);
        this.viewer = new TableViewer(tableComp, 68354);
        this.createColumns();
        final Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.viewer));
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 || e.stateMask == 0x400000) {
                    switch (e.keyCode) {
                        case 67: 
                        case 99: {
                            TableItem[] items = table.getSelection();
                            if (items == null || items.length < 1) {
                                return;
                            }
                            XLogSummaryAbstractDialog.this.copyToClipboard(items);
                            break;
                        }
                        case 65: 
                        case 97: {
                            table.selectAll();
                        }
                    }
                }
            }
        });
        this.createTableContextMenu();
        this.calcAsync();
    }

    private void createTableContextMenu() {
        MenuManager manager = new MenuManager();
        this.viewer.getControl().setMenu(manager.createContextMenu(this.viewer.getControl()));
        manager.add((IAction)new Action("&Copy", ImageDescriptor.createFromImage((Image)Images.copy)){

            public void run() {
                TableItem[] items = XLogSummaryAbstractDialog.this.viewer.getTable().getSelection();
                if (items == null || items.length < 1) {
                    return;
                }
                XLogSummaryAbstractDialog.this.copyToClipboard(items);
            }
        });
    }

    protected abstract void calcAsync();

    protected abstract void createMainColumn();

    private void createColumns() {
        this.createMainColumn();
        SummaryColumnEnum[] summaryColumnEnumArray = SummaryColumnEnum.values();
        int n = summaryColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SummaryColumnEnum column = summaryColumnEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case COUNT: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryObject) {
                                return FormatUtil.print((Object)((SummaryObject)element).count, (String)"#,##0");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case ERROR: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryObject) {
                                return FormatUtil.print((Object)((SummaryObject)element).error, (String)"#,##0");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case TOTAL_ELAPSED: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryObject) {
                                return FormatUtil.print((Object)((SummaryObject)element).sumTime, (String)"#,##0");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case AVG_ELAPSED: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryObject) {
                                return FormatUtil.print((Object)((double)((SummaryObject)element).sumTime / (double)((SummaryObject)element).count), (String)"#,##0");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case TOTAL_CPU: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryObject) {
                                return FormatUtil.print((Object)((SummaryObject)element).cpu, (String)"#,##0");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case AVG_CPU: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryObject) {
                                return FormatUtil.print((Object)((double)((SummaryObject)element).cpu / (double)((SummaryObject)element).count), (String)"#,##0");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case TOTAL_MEMORY: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryObject) {
                                return FormatUtil.print((Object)((SummaryObject)element).memory, (String)"#,##0");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case AVG_MEMORY: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryObject) {
                                return FormatUtil.print((Object)((double)((SummaryObject)element).memory / (double)((SummaryObject)element).count), (String)"#,##0");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case TOTAL_SQLTIME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryObject) {
                                return FormatUtil.print((Object)((SummaryObject)element).sqltime, (String)"#,##0");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case AVG_SQLTIME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryObject) {
                                return FormatUtil.print((Object)((double)((SummaryObject)element).sqltime / (double)((SummaryObject)element).count), (String)"#,##0");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case TOTAL_APICALLTIME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryObject) {
                                return FormatUtil.print((Object)((SummaryObject)element).apicalltime, (String)"#,##0");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case AVG_APICALLTIME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryObject) {
                                return FormatUtil.print((Object)((double)((SummaryObject)element).apicalltime / (double)((SummaryObject)element).count), (String)"#,##0");
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    protected TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(true);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(width, true));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)XLogSummaryAbstractDialog.this.viewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    static enum SummaryColumnEnum {
        COUNT("Count", 100, 131072, true, true, true),
        ERROR("Error", 80, 131072, true, true, true),
        TOTAL_ELAPSED("Total Elapsed(ms)", 150, 131072, true, true, true),
        AVG_ELAPSED("Avg Elapsed(ms)", 150, 131072, true, true, true),
        TOTAL_CPU("Total Cpu(ms)", 100, 131072, true, true, true),
        AVG_CPU("Avg Cpu(ms)", 100, 131072, true, true, true),
        TOTAL_MEMORY("Total Mem(KBytes)", 150, 131072, true, true, true),
        AVG_MEMORY("Avg Mem(KBytes)", 150, 131072, true, true, true),
        TOTAL_SQLTIME("Total SQL Time(ms)", 150, 131072, true, true, true),
        AVG_SQLTIME("Avg SQL Time(ms)", 150, 131072, true, true, true),
        TOTAL_APICALLTIME("Total APICall Time(ms)", 150, 131072, true, true, true),
        AVG_APICALLTIME("Avg APICall Time(ms)", 150, 131072, true, true, true);

        private final String title;
        private final int weight;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private SummaryColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.weight = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.weight;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }

    protected static abstract class SummaryObject {
        int count;
        long sumTime;
        int error;
        long maxTime;
        long cpu;
        long memory;
        long sqltime;
        long apicalltime;

        protected SummaryObject() {
        }
    }
}

