/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.dialog;

import java.util.HashMap;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import scouter.client.model.XLogData;
import scouter.client.threads.ObjectSelectManager;
import scouter.client.util.ExUtil;
import scouter.client.xlog.dialog.XLogSummaryAbstractDialog;
import scouter.util.DateUtil;
import scouter.util.IPUtil;
import scouter.util.LongEnumer;
import scouter.util.LongKeyLinkedMap;
import scouter.util.TopN;

public class XLogSummaryIPDialog
extends XLogSummaryAbstractDialog {
    public XLogSummaryIPDialog(Display display, LongKeyLinkedMap<XLogData> dataMap) {
        super(display, dataMap);
    }

    @Override
    protected void calcAsync() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                HashMap<String, IpSummary> summaryMap = new HashMap<String, IpSummary>();
                LongEnumer longEnumer = XLogSummaryIPDialog.this.dataMap.keys();
                while (longEnumer.hasMoreElements()) {
                    XLogData d = (XLogData)XLogSummaryIPDialog.this.dataMap.get(longEnumer.nextLong());
                    long time = d.p.endTime;
                    if (!d.filter_ok || time < XLogSummaryIPDialog.this.stime || time > XLogSummaryIPDialog.this.etime || ObjectSelectManager.getInstance().isUnselectedObject(d.p.objHash)) continue;
                    String ip = IPUtil.toString((byte[])d.p.ipaddr);
                    IpSummary summary = (IpSummary)summaryMap.get(ip);
                    if (summary == null) {
                        summary = new IpSummary();
                        summary.ip = ip;
                        summaryMap.put(ip, summary);
                    }
                    summary.count = summary.count + 1;
                    summary.sumTime += (long)d.p.elapsed;
                    if ((long)d.p.elapsed > summary.maxTime) {
                        summary.maxTime = d.p.elapsed;
                    }
                    if (d.p.error != 0) {
                        summary.error = summary.error + 1;
                    }
                    summary.cpu += (long)d.p.cpu;
                    summary.memory += (long)d.p.kbytes;
                    summary.sqltime += (long)d.p.sqlTime;
                    summary.apicalltime += (long)d.p.apicallTime;
                }
                final TopN stn = new TopN(10000, TopN.DIRECTION.DESC);
                for (IpSummary so : summaryMap.values()) {
                    stn.add((Comparable)so);
                }
                ExUtil.exec((Composite)XLogSummaryIPDialog.this.viewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        (this).XLogSummaryIPDialog.this.rangeLabel.setText(String.valueOf(DateUtil.format((long)(this).XLogSummaryIPDialog.this.stime, (String)"yyyy-MM-dd HH:mm:ss")) + " ~ " + DateUtil.format((long)(this).XLogSummaryIPDialog.this.etime, (String)"HH:mm:ss") + " (" + stn.size() + ")");
                        (this).XLogSummaryIPDialog.this.viewer.setInput((Object)stn.getList());
                    }
                });
            }
        });
    }

    @Override
    public String getTitle() {
        return "IP Summary";
    }

    @Override
    protected void createMainColumn() {
        TableViewerColumn c = this.createTableViewerColumn("IP", 150, 0x1000000, false);
        ColumnLabelProvider labelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IpSummary) {
                    return ((IpSummary)element).ip;
                }
                return null;
            }
        };
        c.setLabelProvider((CellLabelProvider)labelProvider);
    }

    private static class IpSummary
    extends XLogSummaryAbstractDialog.SummaryObject
    implements Comparable<IpSummary> {
        String ip;

        private IpSummary() {
        }

        @Override
        public int compareTo(IpSummary o) {
            return this.count - o.count;
        }
    }
}

