/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import scouter.client.model.TextProxy;
import scouter.client.model.XLogData;
import scouter.client.threads.ObjectSelectManager;
import scouter.client.util.ExUtil;
import scouter.client.xlog.dialog.XLogSummaryAbstractDialog;
import scouter.util.DateUtil;
import scouter.util.LongEnumer;
import scouter.util.LongKeyLinkedMap;
import scouter.util.TopN;

public class XLogSummaryRefererDialog
extends XLogSummaryAbstractDialog {
    public XLogSummaryRefererDialog(Display display, LongKeyLinkedMap<XLogData> dataMap) {
        super(display, dataMap);
    }

    @Override
    protected void calcAsync() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                HashMap<Integer, RefererSummary> summaryMap = new HashMap<Integer, RefererSummary>();
                HashMap<Integer, ArrayList<Integer>> loadTextMap = new HashMap<Integer, ArrayList<Integer>>();
                LongEnumer longEnumer = XLogSummaryRefererDialog.this.dataMap.keys();
                while (longEnumer.hasMoreElements()) {
                    XLogData d = (XLogData)XLogSummaryRefererDialog.this.dataMap.get(longEnumer.nextLong());
                    long time = d.p.endTime;
                    if (!d.filter_ok || time < XLogSummaryRefererDialog.this.stime || time > XLogSummaryRefererDialog.this.etime || ObjectSelectManager.getInstance().isUnselectedObject(d.p.objHash)) continue;
                    RefererSummary summary = (RefererSummary)summaryMap.get(d.p.referer);
                    if (summary == null) {
                        summary = new RefererSummary(d.p.referer);
                        summaryMap.put(d.p.referer, summary);
                        ArrayList<Integer> loadTextList = (ArrayList<Integer>)loadTextMap.get(d.serverId);
                        if (loadTextList == null) {
                            loadTextList = new ArrayList<Integer>();
                            loadTextMap.put(d.serverId, loadTextList);
                        }
                        loadTextList.add(d.p.referer);
                    }
                    summary.count = summary.count + 1;
                    summary.sumTime += (long)d.p.elapsed;
                    if ((long)d.p.elapsed > summary.maxTime) {
                        summary.maxTime = d.p.elapsed;
                    }
                    if (d.p.error != 0) {
                        summary.error = summary.error + 1;
                    }
                    summary.cpu += (long)d.p.cpu;
                    summary.memory += (long)d.p.kbytes;
                    summary.sqltime += (long)d.p.sqlTime;
                    summary.apicalltime += (long)d.p.apicallTime;
                }
                for (Integer serverId : loadTextMap.keySet()) {
                    TextProxy.referer.load(DateUtil.yyyymmdd((long)XLogSummaryRefererDialog.this.etime), (Collection)loadTextMap.get(serverId), (int)serverId);
                }
                final TopN stn = new TopN(10000, TopN.DIRECTION.DESC);
                for (RefererSummary so : summaryMap.values()) {
                    stn.add((Comparable)so);
                }
                ExUtil.exec((Composite)XLogSummaryRefererDialog.this.viewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        (this).XLogSummaryRefererDialog.this.rangeLabel.setText(String.valueOf(DateUtil.format((long)(this).XLogSummaryRefererDialog.this.stime, (String)"yyyy-MM-dd HH:mm:ss")) + " ~ " + DateUtil.format((long)(this).XLogSummaryRefererDialog.this.etime, (String)"HH:mm:ss") + " (" + stn.size() + ")");
                        (this).XLogSummaryRefererDialog.this.viewer.setInput((Object)stn.getList());
                    }
                });
            }
        });
    }

    @Override
    public String getTitle() {
        return "Referer Summary";
    }

    @Override
    protected void createMainColumn() {
        TableViewerColumn c = this.createTableViewerColumn("Referer", 200, 16384, false);
        ColumnLabelProvider labelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RefererSummary) {
                    return TextProxy.referer.getText(((RefererSummary)element).hash);
                }
                return null;
            }
        };
        c.setLabelProvider((CellLabelProvider)labelProvider);
    }

    private static class RefererSummary
    extends XLogSummaryAbstractDialog.SummaryObject
    implements Comparable<RefererSummary> {
        int hash;

        RefererSummary(int hash) {
            this.hash = hash;
        }

        @Override
        public int compareTo(RefererSummary o) {
            return this.count - o.count;
        }
    }
}

