/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.xlog.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import scouter.client.model.TextProxy;
import scouter.client.model.XLogData;
import scouter.client.threads.ObjectSelectManager;
import scouter.client.util.ExUtil;
import scouter.client.xlog.dialog.XLogSummaryAbstractDialog;
import scouter.util.DateUtil;
import scouter.util.LongEnumer;
import scouter.util.LongKeyLinkedMap;
import scouter.util.TopN;

public class XLogSummaryServiceDialog
extends XLogSummaryAbstractDialog {
    public XLogSummaryServiceDialog(Display display, LongKeyLinkedMap<XLogData> dataMap) {
        super(display, dataMap);
    }

    @Override
    protected void calcAsync() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                HashMap<Integer, ServiceSummary> summaryMap = new HashMap<Integer, ServiceSummary>();
                HashMap<Integer, ArrayList<Integer>> loadTextMap = new HashMap<Integer, ArrayList<Integer>>();
                LongEnumer longEnumer = XLogSummaryServiceDialog.this.dataMap.keys();
                while (longEnumer.hasMoreElements()) {
                    XLogData d = (XLogData)XLogSummaryServiceDialog.this.dataMap.get(longEnumer.nextLong());
                    long time = d.p.endTime;
                    if (!d.filter_ok || time < XLogSummaryServiceDialog.this.stime || time > XLogSummaryServiceDialog.this.etime || ObjectSelectManager.getInstance().isUnselectedObject(d.p.objHash)) continue;
                    ServiceSummary summary = (ServiceSummary)summaryMap.get(d.p.service);
                    if (summary == null) {
                        summary = new ServiceSummary(d.p.service);
                        summaryMap.put(d.p.service, summary);
                        ArrayList<Integer> loadTextList = (ArrayList<Integer>)loadTextMap.get(d.serverId);
                        if (loadTextList == null) {
                            loadTextList = new ArrayList<Integer>();
                            loadTextMap.put(d.serverId, loadTextList);
                        }
                        loadTextList.add(d.p.service);
                    }
                    summary.count = summary.count + 1;
                    summary.sumTime += (long)d.p.elapsed;
                    if ((long)d.p.elapsed > summary.maxTime) {
                        summary.maxTime = d.p.elapsed;
                    }
                    if (d.p.error != 0) {
                        summary.error = summary.error + 1;
                    }
                    summary.cpu += (long)d.p.cpu;
                    summary.memory += (long)d.p.kbytes;
                    summary.sqltime += (long)d.p.sqlTime;
                    summary.apicalltime += (long)d.p.apicallTime;
                }
                for (Integer serverId : loadTextMap.keySet()) {
                    TextProxy.service.load(DateUtil.yyyymmdd((long)XLogSummaryServiceDialog.this.etime), (Collection)loadTextMap.get(serverId), (int)serverId);
                }
                final TopN stn = new TopN(10000, TopN.DIRECTION.DESC);
                for (ServiceSummary so : summaryMap.values()) {
                    stn.add((Comparable)so);
                }
                ExUtil.exec((Composite)XLogSummaryServiceDialog.this.viewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        (this).XLogSummaryServiceDialog.this.rangeLabel.setText(String.valueOf(DateUtil.format((long)(this).XLogSummaryServiceDialog.this.stime, (String)"yyyy-MM-dd HH:mm:ss")) + " ~ " + DateUtil.format((long)(this).XLogSummaryServiceDialog.this.etime, (String)"HH:mm:ss") + " (" + stn.size() + ")");
                        (this).XLogSummaryServiceDialog.this.viewer.setInput((Object)stn.getList());
                    }
                });
            }
        });
    }

    @Override
    public String getTitle() {
        return "Service Summary";
    }

    @Override
    protected void createMainColumn() {
        TableViewerColumn c = this.createTableViewerColumn("Service", 200, 16384, false);
        ColumnLabelProvider labelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ServiceSummary) {
                    return TextProxy.service.getText(((ServiceSummary)element).hash);
                }
                return null;
            }
        };
        c.setLabelProvider((CellLabelProvider)labelProvider);
    }

    private static class ServiceSummary
    extends XLogSummaryAbstractDialog.SummaryObject
    implements Comparable<ServiceSummary> {
        int hash;

        ServiceSummary(int hash) {
            this.hash = hash;
        }

        @Override
        public int compareTo(ServiceSummary o) {
            return this.count - o.count;
        }
    }
}

